/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;

public class OpenPGPKeyReader {
    private final OpenPGPImplementation implementation;
    private final OpenPGPPolicy policy;

    public OpenPGPKeyReader() {
        this(OpenPGPImplementation.getInstance());
    }

    public OpenPGPKeyReader(OpenPGPImplementation openPGPImplementation) {
        this(openPGPImplementation, openPGPImplementation.policy());
    }

    public OpenPGPKeyReader(OpenPGPImplementation openPGPImplementation, OpenPGPPolicy openPGPPolicy) {
        this.implementation = openPGPImplementation;
        this.policy = openPGPPolicy;
    }

    public OpenPGPCertificate parseCertificate(String string) throws IOException {
        OpenPGPCertificate openPGPCertificate = this.parseCertificateOrKey(string);
        if (openPGPCertificate instanceof OpenPGPKey) {
            throw new IOException("Could not parse OpenPGPCertificate: Is OpenPGPKey.");
        }
        return openPGPCertificate;
    }

    public OpenPGPCertificate parseCertificate(InputStream inputStream) throws IOException {
        OpenPGPCertificate openPGPCertificate = this.parseCertificateOrKey(inputStream);
        if (openPGPCertificate instanceof OpenPGPKey) {
            throw new IOException("Could not parse OpenPGPCertificate: Is OpenPGPKey.");
        }
        return openPGPCertificate;
    }

    public OpenPGPCertificate parseCertificate(byte[] byArray) throws IOException {
        OpenPGPCertificate openPGPCertificate = this.parseCertificateOrKey(byArray);
        if (openPGPCertificate instanceof OpenPGPKey) {
            throw new IOException("Could not parse OpenPGPCertificate: Is OpenPGPKey.");
        }
        return openPGPCertificate;
    }

    public OpenPGPCertificate parseCertificateOrKey(String string) throws IOException {
        return this.parseCertificateOrKey(Strings.toUTF8ByteArray((String)string));
    }

    public OpenPGPCertificate parseCertificateOrKey(InputStream inputStream) throws IOException {
        return this.parseCertificateOrKey(Streams.readAll((InputStream)inputStream));
    }

    public OpenPGPCertificate parseCertificateOrKey(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = PGPUtil.getDecoderStream(byteArrayInputStream);
        BCPGInputStream bCPGInputStream = BCPGInputStream.wrap(inputStream);
        PGPObjectFactory pGPObjectFactory = this.implementation.pgpObjectFactory(bCPGInputStream);
        Object object = pGPObjectFactory.nextObject();
        while (object instanceof PGPMarker) {
            object = pGPObjectFactory.nextObject();
        }
        if (object instanceof PGPSecretKeyRing) {
            return new OpenPGPKey((PGPSecretKeyRing)object, this.implementation, this.policy);
        }
        if (object instanceof PGPPublicKeyRing) {
            return new OpenPGPCertificate((PGPPublicKeyRing)object, this.implementation, this.policy);
        }
        throw new IOException("Neither a certificate, nor secret key.");
    }

    public OpenPGPKey parseKey(String string) throws IOException {
        return this.parseKey(Strings.toUTF8ByteArray((String)string));
    }

    public OpenPGPKey parseKey(InputStream inputStream) throws IOException {
        return this.parseKey(Streams.readAll((InputStream)inputStream));
    }

    public OpenPGPKey parseKey(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = PGPUtil.getDecoderStream(byteArrayInputStream);
        BCPGInputStream bCPGInputStream = BCPGInputStream.wrap(inputStream);
        PGPObjectFactory pGPObjectFactory = this.implementation.pgpObjectFactory(bCPGInputStream);
        Object object = pGPObjectFactory.nextObject();
        while (object instanceof PGPMarker) {
            object = pGPObjectFactory.nextObject();
        }
        if (!(object instanceof PGPSecretKeyRing)) {
            throw new IOException("Not a secret key.");
        }
        PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)object;
        return new OpenPGPKey(pGPSecretKeyRing, this.implementation, this.policy);
    }

    public List<OpenPGPCertificate> parseKeysOrCertificates(String string) throws IOException {
        return this.parseKeysOrCertificates(Strings.toUTF8ByteArray((String)string));
    }

    public List<OpenPGPCertificate> parseKeysOrCertificates(InputStream inputStream) throws IOException {
        return this.parseKeysOrCertificates(Streams.readAll((InputStream)inputStream));
    }

    public List<OpenPGPCertificate> parseKeysOrCertificates(byte[] byArray) throws IOException {
        Object object;
        ArrayList<OpenPGPCertificate> arrayList = new ArrayList<OpenPGPCertificate>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = PGPUtil.getDecoderStream(byteArrayInputStream);
        inputStream = PGPUtil.getDecoderStream(inputStream);
        PGPObjectFactory pGPObjectFactory = this.implementation.pgpObjectFactory(inputStream);
        while ((object = pGPObjectFactory.nextObject()) != null) {
            if (object instanceof PGPMarker) continue;
            if (object instanceof PGPSecretKeyRing) {
                arrayList.add(new OpenPGPKey((PGPSecretKeyRing)object, this.implementation, this.policy));
                continue;
            }
            if (object instanceof PGPPublicKeyRing) {
                arrayList.add(new OpenPGPCertificate((PGPPublicKeyRing)object, this.implementation, this.policy));
                continue;
            }
            throw new IOException("Neither a certificate, nor secret key.");
        }
        return arrayList;
    }

    public List<OpenPGPCertificate> parseCertificates(String string) throws IOException {
        return this.parseCertificates(Strings.toUTF8ByteArray((String)string));
    }

    public List<OpenPGPCertificate> parseCertificates(InputStream inputStream) throws IOException {
        return this.parseCertificates(Streams.readAll((InputStream)inputStream));
    }

    public List<OpenPGPCertificate> parseCertificates(byte[] byArray) throws IOException {
        Object object;
        ArrayList<OpenPGPCertificate> arrayList = new ArrayList<OpenPGPCertificate>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = PGPUtil.getDecoderStream(byteArrayInputStream);
        inputStream = PGPUtil.getDecoderStream(inputStream);
        PGPObjectFactory pGPObjectFactory = this.implementation.pgpObjectFactory(inputStream);
        while ((object = pGPObjectFactory.nextObject()) != null) {
            if (object instanceof PGPMarker) continue;
            if (object instanceof PGPPublicKeyRing) {
                arrayList.add(new OpenPGPCertificate((PGPPublicKeyRing)object, this.implementation, this.policy));
                continue;
            }
            throw new IOException("Encountered unexpected packet: " + object.getClass().getName());
        }
        return arrayList;
    }

    public List<OpenPGPKey> parseKeys(String string) throws IOException {
        return this.parseKeys(Strings.toUTF8ByteArray((String)string));
    }

    public List<OpenPGPKey> parseKeys(InputStream inputStream) throws IOException {
        return this.parseKeys(Streams.readAll((InputStream)inputStream));
    }

    public List<OpenPGPKey> parseKeys(byte[] byArray) throws IOException {
        Object object;
        ArrayList<OpenPGPKey> arrayList = new ArrayList<OpenPGPKey>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = PGPUtil.getDecoderStream(byteArrayInputStream);
        inputStream = PGPUtil.getDecoderStream(inputStream);
        PGPObjectFactory pGPObjectFactory = this.implementation.pgpObjectFactory(inputStream);
        while ((object = pGPObjectFactory.nextObject()) != null) {
            if (object instanceof PGPMarker) continue;
            if (object instanceof PGPSecretKeyRing) {
                arrayList.add(new OpenPGPKey((PGPSecretKeyRing)object, this.implementation, this.policy));
                continue;
            }
            throw new IOException("Encountered unexpected packet: " + object.getClass().getName());
        }
        return arrayList;
    }
}

