/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.registry.EditorDescriptor;

public class FileEditorMapping
implements IFileEditorMapping,
Cloneable {
    private static final String STAR = "*";
    private static final String DOT = ".";
    private String name = "*";
    private String extension;
    private List<IEditorDescriptor> editors = new ArrayList<IEditorDescriptor>(1);
    private List<IEditorDescriptor> deletedEditors = new ArrayList<IEditorDescriptor>(1);
    private List<IEditorDescriptor> declaredDefaultEditors = new ArrayList<IEditorDescriptor>(1);

    public FileEditorMapping(String extension) {
        this(STAR, extension);
    }

    public FileEditorMapping(String name, String extension) {
        if (name == null || name.length() < 1) {
            this.setName(STAR);
        } else {
            this.setName(name);
        }
        if (extension == null) {
            this.setExtension("");
        } else {
            this.setExtension(extension);
        }
    }

    public void addEditor(EditorDescriptor editor) {
        Assert.isNotNull((Object)editor);
        this.editors.add(editor);
        this.deletedEditors.remove(editor);
    }

    public Object clone() {
        try {
            FileEditorMapping clone = (FileEditorMapping)super.clone();
            clone.editors = (List)((ArrayList)this.editors).clone();
            clone.deletedEditors = (List)((ArrayList)this.deletedEditors).clone();
            clone.declaredDefaultEditors = (List)((ArrayList)this.declaredDefaultEditors).clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void mapping;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileEditorMapping)) {
            return false;
        }
        FileEditorMapping fileEditorMapping = (FileEditorMapping)obj;
        return Objects.equals(this.name, mapping.name) && Objects.equals(this.extension, mapping.extension) && Objects.equals(this.editors, mapping.editors) && Objects.equals(this.declaredDefaultEditors, mapping.declaredDefaultEditors) && Objects.equals(this.deletedEditors, mapping.deletedEditors);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.declaredDefaultEditors);
        result = 31 * result + Objects.hashCode(this.deletedEditors);
        result = 31 * result + Objects.hashCode(this.editors);
        result = 31 * result + Objects.hashCode(this.extension);
        return 31 * result + Objects.hashCode(this.name);
    }

    @Override
    public IEditorDescriptor getDefaultEditor() {
        if (this.editors.isEmpty() || WorkbenchActivityHelper.restrictUseOf(this.editors.get(0))) {
            return null;
        }
        return this.editors.get(0);
    }

    IEditorDescriptor[] getUnfilteredEditors() {
        return this.editors.toArray(new IEditorDescriptor[this.editors.size()]);
    }

    @Override
    public IEditorDescriptor[] getEditors() {
        Collection<IEditorDescriptor> descs = WorkbenchActivityHelper.restrictCollection(this.editors, new ArrayList());
        return descs.toArray(new IEditorDescriptor[descs.size()]);
    }

    @Override
    public IEditorDescriptor[] getDeletedEditors() {
        IEditorDescriptor[] array = new IEditorDescriptor[this.deletedEditors.size()];
        this.deletedEditors.toArray(array);
        return array;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        IEditorDescriptor editor = this.getDefaultEditor();
        if (editor == null) {
            return WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
        }
        return editor.getImageDescriptor();
    }

    @Override
    public String getLabel() {
        return TextProcessor.process((String)(this.name + (String)(this.extension.isEmpty() ? "" : DOT + this.extension)), (String)"*.");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void removeEditor(IEditorDescriptor editor) {
        Assert.isNotNull((Object)editor);
        this.editors.remove(editor);
        this.deletedEditors.add(editor);
        this.declaredDefaultEditors.remove(editor);
    }

    public void setDefaultEditor(IEditorDescriptor editor) {
        Assert.isNotNull((Object)editor);
        this.editors.remove(editor);
        this.editors.add(0, editor);
        this.declaredDefaultEditors.remove(editor);
        this.declaredDefaultEditors.add(0, editor);
    }

    public void setEditorsList(List<IEditorDescriptor> newEditors) {
        this.editors = newEditors;
        this.declaredDefaultEditors.retainAll(newEditors);
    }

    public void setDeletedEditorsList(List<IEditorDescriptor> newDeletedEditors) {
        this.deletedEditors = newDeletedEditors;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IEditorDescriptor[] getDeclaredDefaultEditors() {
        Collection<IEditorDescriptor> descs = WorkbenchActivityHelper.restrictCollection(this.declaredDefaultEditors, new ArrayList());
        return descs.toArray(new IEditorDescriptor[descs.size()]);
    }

    public boolean isDeclaredDefaultEditor(IEditorDescriptor editor) {
        return this.declaredDefaultEditors.contains(editor) && !WorkbenchActivityHelper.restrictUseOf(editor);
    }

    public void setDefaultEditors(List<IEditorDescriptor> defaultEditors) {
        this.declaredDefaultEditors = defaultEditors;
    }
}

