/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.help;

import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelp;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.AbstractHelpUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class WorkbenchHelpSystem
implements IWorkbenchHelpSystem {
    public static final String HELP_KEY = "org.eclipse.ui.help";
    private static final String HELP_SYSTEM_EXTENSION_ID = "org.eclipse.ui.helpSupport";
    private static final String HELP_SYSTEM_CLASS_ATTRIBUTE = "class";
    private static WorkbenchHelpSystem instance;
    private boolean isInitialized;
    private AbstractHelpUI pluggableHelpUI = null;
    private String desiredHelpSystemId;
    private Hashtable<String, StackTraceElement> registeredIDTable;
    private final IExtensionChangeHandler handler = new IExtensionChangeHandler(){

        public void addExtension(IExtensionTracker tracker, IExtension extension) {
        }

        public void removeExtension(IExtension source, Object[] objects) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object == WorkbenchHelpSystem.this.pluggableHelpUI) {
                    WorkbenchHelpSystem.this.isInitialized = false;
                    WorkbenchHelpSystem.this.pluggableHelpUI = null;
                    WorkbenchHelpSystem.this.helpCompatibilityWrapper = null;
                    PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler(WorkbenchHelpSystem.this.handler);
                }
                ++n2;
            }
        }
    };
    private IHelp helpCompatibilityWrapper = null;
    private static HelpListener helpListener;

    public String getDesiredHelpSystemId() {
        return this.desiredHelpSystemId;
    }

    public void setDesiredHelpSystemId(String desiredHelpSystemId) {
        this.dispose();
        this.desiredHelpSystemId = desiredHelpSystemId;
    }

    private WorkbenchHelpSystem() {
    }

    public static WorkbenchHelpSystem getInstance() {
        if (instance == null) {
            instance = new WorkbenchHelpSystem();
        }
        return instance;
    }

    public static void disposeIfNecessary() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    public void dispose() {
        this.pluggableHelpUI = null;
        this.helpCompatibilityWrapper = null;
        this.isInitialized = false;
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler(this.handler);
    }

    private AbstractHelpUI getHelpUI() {
        if (!this.isInitialized) {
            this.isInitialized = this.initializePluggableHelpUI();
        }
        return this.pluggableHelpUI;
    }

    private boolean initializePluggableHelpUI() {
        final boolean[] ret = new boolean[1];
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(WorkbenchHelpSystem.HELP_SYSTEM_EXTENSION_ID);
                if (point == null) {
                    return;
                }
                IExtension[] extensions = point.getExtensions();
                if (extensions.length == 0) {
                    return;
                }
                IConfigurationElement elementToUse = null;
                elementToUse = WorkbenchHelpSystem.this.desiredHelpSystemId == null ? this.getFirstElement(extensions) : this.findElement(WorkbenchHelpSystem.this.desiredHelpSystemId, extensions);
                if (elementToUse != null) {
                    ret[0] = this.initializePluggableHelpUI(elementToUse);
                }
            }

            private IConfigurationElement findElement(String desiredHelpSystemId, IExtension[] extensions) {
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    if (desiredHelpSystemId.equals(extension.getUniqueIdentifier())) {
                        IConfigurationElement[] elements = extension.getConfigurationElements();
                        if (elements.length == 0) {
                            return null;
                        }
                        return elements[0];
                    }
                    ++n2;
                }
                return null;
            }

            private IConfigurationElement getFirstElement(IExtension[] extensions) {
                IConfigurationElement[] elements = extensions[0].getConfigurationElements();
                if (elements.length == 0) {
                    return null;
                }
                return elements[0];
            }

            private boolean initializePluggableHelpUI(IConfigurationElement element) {
                try {
                    WorkbenchHelpSystem.this.pluggableHelpUI = (AbstractHelpUI)WorkbenchPlugin.createExtension(element, WorkbenchHelpSystem.HELP_SYSTEM_CLASS_ATTRIBUTE);
                    PlatformUI.getWorkbench().getExtensionTracker().registerHandler(WorkbenchHelpSystem.this.handler, null);
                    PlatformUI.getWorkbench().getExtensionTracker().registerObject(element.getDeclaringExtension(), (Object)WorkbenchHelpSystem.this.pluggableHelpUI, 2);
                    return true;
                }
                catch (CoreException e) {
                    WorkbenchPlugin.log("Unable to instantiate help UI" + String.valueOf(e.getStatus()), e);
                    return false;
                }
            }
        });
        return ret[0];
    }

    private static Point computePopUpLocation(Display display) {
        Point point = display.getCursorLocation();
        return new Point(point.x + 15, point.y);
    }

    private HelpListener getHelpListener() {
        if (helpListener == null) {
            helpListener = new WorkbenchHelpListener();
        }
        return helpListener;
    }

    @Deprecated(forRemoval=true, since="2023-12")
    public IHelp getHelpSupport() {
        AbstractHelpUI helpUI = this.getHelpUI();
        if (helpUI != null && this.helpCompatibilityWrapper == null) {
            this.helpCompatibilityWrapper = new CompatibilityIHelpImplementation();
        }
        return this.helpCompatibilityWrapper;
    }

    @Deprecated
    public void setHelp(IAction action, Object[] contexts) {
        Object[] objectArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Object context = objectArray[n2];
            Assert.isTrue((context instanceof String || context instanceof IContext ? 1 : 0) != 0);
            ++n2;
        }
        action.setHelpListener(event -> {
            if (contexts != null && contexts.length > 0 && this.getHelpUI() != null) {
                IContext context = null;
                if (contexts[0] instanceof String) {
                    context = HelpSystem.getContext((String)((String)contexts[0]));
                } else if (contexts[0] instanceof IContext) {
                    context = (IContext)contexts[0];
                }
                if (context != null) {
                    Point point = WorkbenchHelpSystem.computePopUpLocation(event.widget.getDisplay());
                    this.displayContext(context, point.x, point.y);
                }
            }
        });
    }

    @Deprecated
    public void setHelp(Control control, Object[] contexts) {
        Object[] objectArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Object context = objectArray[n2];
            Assert.isTrue((context instanceof String || context instanceof IContext ? 1 : 0) != 0);
            ++n2;
        }
        control.setData(HELP_KEY, (Object)contexts);
        control.removeHelpListener(this.getHelpListener());
        control.addHelpListener(this.getHelpListener());
    }

    @Deprecated
    public void setHelp(Menu menu, Object[] contexts) {
        Object[] objectArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Object context = objectArray[n2];
            Assert.isTrue((context instanceof String || context instanceof IContext ? 1 : 0) != 0);
            ++n2;
        }
        menu.setData(HELP_KEY, (Object)contexts);
        menu.removeHelpListener(this.getHelpListener());
        menu.addHelpListener(this.getHelpListener());
    }

    @Deprecated
    public void setHelp(MenuItem item, Object[] contexts) {
        Object[] objectArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Object context = objectArray[n2];
            Assert.isTrue((context instanceof String || context instanceof IContext ? 1 : 0) != 0);
            ++n2;
        }
        item.setData(HELP_KEY, (Object)contexts);
        item.removeHelpListener(this.getHelpListener());
        item.addHelpListener(this.getHelpListener());
    }

    @Override
    public void displayHelp() {
        AbstractHelpUI helpUI = this.getHelpUI();
        if (helpUI != null) {
            helpUI.displayHelp();
        }
    }

    @Override
    public void displaySearch() {
        AbstractHelpUI helpUI = this.getHelpUI();
        if (helpUI != null) {
            helpUI.displaySearch();
        }
    }

    @Override
    public void displayDynamicHelp() {
        AbstractHelpUI helpUI = this.getHelpUI();
        if (helpUI != null) {
            helpUI.displayDynamicHelp();
        }
    }

    @Override
    public void search(String expression) {
        AbstractHelpUI helpUI = this.getHelpUI();
        if (helpUI != null) {
            helpUI.search(expression);
        }
    }

    @Override
    public URL resolve(String href, boolean documentOnly) {
        AbstractHelpUI helpUI = this.getHelpUI();
        if (helpUI != null) {
            return helpUI.resolve(href, documentOnly);
        }
        return null;
    }

    @Override
    public void displayContext(IContext context, int x, int y) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        AbstractHelpUI helpUI = this.getHelpUI();
        if (helpUI != null) {
            helpUI.displayContext(context, x, y);
        }
    }

    @Override
    public void displayHelpResource(String href) {
        if (href == null) {
            throw new IllegalArgumentException();
        }
        AbstractHelpUI helpUI = this.getHelpUI();
        if (helpUI != null) {
            helpUI.displayHelpResource(href);
        }
    }

    @Override
    public void displayHelp(String contextId) {
        IContext context = HelpSystem.getContext((String)contextId);
        if (context != null) {
            Point point = WorkbenchHelpSystem.computePopUpLocation(Display.getCurrent());
            this.displayContext(context, point.x, point.y);
        }
    }

    @Override
    public void displayHelp(IContext context) {
        Point point = WorkbenchHelpSystem.computePopUpLocation(Display.getCurrent());
        AbstractHelpUI helpUI = this.getHelpUI();
        if (helpUI != null) {
            helpUI.displayContext(context, point.x, point.y);
        }
    }

    @Override
    public boolean isContextHelpDisplayed() {
        if (!this.isInitialized) {
            return false;
        }
        AbstractHelpUI helpUI = this.getHelpUI();
        return helpUI != null && helpUI.isContextHelpDisplayed();
    }

    @Override
    public void setHelp(IAction action, String contextId) {
        if (WorkbenchPlugin.DEBUG) {
            this.setHelpTrace(contextId);
        }
        action.setHelpListener(event -> {
            IContext context;
            if (this.getHelpUI() != null && (context = HelpSystem.getContext((String)contextId)) != null) {
                Point point = WorkbenchHelpSystem.computePopUpLocation(event.widget.getDisplay());
                String title = LegacyActionTools.removeMnemonics((String)action.getText());
                this.displayContext((IContext)new ContextWithTitle(context, title), point.x, point.y);
            }
        });
    }

    @Override
    public void setHelp(Control control, String contextId) {
        if (WorkbenchPlugin.DEBUG) {
            this.setHelpTrace(contextId);
        }
        control.setData(HELP_KEY, (Object)contextId);
        control.removeHelpListener(this.getHelpListener());
        control.addHelpListener(this.getHelpListener());
    }

    @Override
    public void setHelp(Menu menu, String contextId) {
        if (WorkbenchPlugin.DEBUG) {
            this.setHelpTrace(contextId);
        }
        menu.setData(HELP_KEY, (Object)contextId);
        menu.removeHelpListener(this.getHelpListener());
        menu.addHelpListener(this.getHelpListener());
    }

    @Override
    public void setHelp(MenuItem item, String contextId) {
        if (WorkbenchPlugin.DEBUG) {
            this.setHelpTrace(contextId);
        }
        item.setData(HELP_KEY, (Object)contextId);
        item.removeHelpListener(this.getHelpListener());
        item.addHelpListener(this.getHelpListener());
    }

    private void setHelpTrace(String contextId) {
        RuntimeException e = new RuntimeException();
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement currentElement = null;
        int s = 0;
        while (s < stackTrace.length) {
            if (stackTrace[s].getMethodName().equals("setHelp") && s + 1 < stackTrace.length) {
                currentElement = stackTrace[s + 1];
                break;
            }
            ++s;
        }
        if (this.registeredIDTable == null) {
            this.registeredIDTable = new Hashtable();
        }
        if (!this.registeredIDTable.containsKey(contextId)) {
            this.registeredIDTable.put(contextId, currentElement);
        } else if (!this.registeredIDTable.get(contextId).equals(currentElement)) {
            StackTraceElement initialElement = this.registeredIDTable.get(contextId);
            String error = "UI Duplicate Context ID found: '" + contextId + "'\n 1 at " + String.valueOf(initialElement) + "\n 2 at " + String.valueOf(currentElement);
            System.out.println(error);
        }
    }

    @Override
    public boolean hasHelpUI() {
        return this.getHelpUI() != null;
    }

    private class CompatibilityIHelpImplementation
    implements IHelp {
        private CompatibilityIHelpImplementation() {
        }

        @Deprecated
        public void displayHelp() {
            AbstractHelpUI helpUI = WorkbenchHelpSystem.this.getHelpUI();
            if (helpUI != null) {
                helpUI.displayHelp();
            }
        }

        @Deprecated
        public void displayContext(IContext context, int x, int y) {
            AbstractHelpUI helpUI = WorkbenchHelpSystem.this.getHelpUI();
            if (helpUI != null) {
                helpUI.displayContext(context, x, y);
            }
        }

        @Deprecated
        public void displayContext(String contextId, int x, int y) {
            IContext context = HelpSystem.getContext((String)contextId);
            if (context != null) {
                this.displayContext(context, x, y);
            }
        }

        @Deprecated
        public void displayHelpResource(String href) {
            AbstractHelpUI helpUI = WorkbenchHelpSystem.this.getHelpUI();
            if (helpUI != null) {
                helpUI.displayHelpResource(href);
            }
        }

        @Deprecated
        public void displayHelpResource(IHelpResource helpResource) {
            this.displayHelpResource(helpResource.getHref());
        }

        @Deprecated
        public void displayHelp(String toc) {
            this.displayHelpResource(toc);
        }

        @Deprecated
        public void displayHelp(String toc, String selectedTopic) {
            this.displayHelpResource(selectedTopic);
        }

        @Deprecated
        public void displayHelp(String contextId, int x, int y) {
            this.displayContext(contextId, x, y);
        }

        @Deprecated
        public void displayHelp(IContext context, int x, int y) {
            this.displayContext(context, x, y);
        }

        @Deprecated
        public IContext getContext(String contextId) {
            return HelpSystem.getContext((String)contextId);
        }

        @Deprecated
        public IToc[] getTocs() {
            return HelpSystem.getTocs();
        }

        @Deprecated
        public boolean isContextHelpDisplayed() {
            return WorkbenchHelpSystem.this.isContextHelpDisplayed();
        }
    }

    private static class ContextWithTitle
    implements IContext2 {
        private final IContext context;
        private final String title;

        ContextWithTitle(IContext context, String title) {
            this.context = context;
            this.title = title;
        }

        public String getTitle() {
            String ctitle;
            if (this.context instanceof IContext2 && (ctitle = ((IContext2)this.context).getTitle()) != null) {
                return ctitle;
            }
            return this.title;
        }

        public String getStyledText() {
            if (this.context instanceof IContext2) {
                return ((IContext2)this.context).getStyledText();
            }
            return this.context.getText();
        }

        public String getCategory(IHelpResource topic) {
            if (this.context instanceof IContext2) {
                return ((IContext2)this.context).getCategory(topic);
            }
            return null;
        }

        public IHelpResource[] getRelatedTopics() {
            return this.context.getRelatedTopics();
        }

        public String getText() {
            return this.context.getText();
        }
    }

    private static class WorkbenchHelpListener
    implements HelpListener {
        private WorkbenchHelpListener() {
        }

        public void helpRequested(HelpEvent event) {
            Object[] helpContexts;
            if (WorkbenchHelpSystem.getInstance().getHelpUI() == null) {
                return;
            }
            Object object = event.widget.getData(WorkbenchHelpSystem.HELP_KEY);
            IContext context = null;
            if (object instanceof String) {
                context = HelpSystem.getContext((String)((String)object));
            } else if (object instanceof IContext) {
                context = (IContext)object;
            } else if (object instanceof Object[] && (helpContexts = (Object[])object).length > 0) {
                Object primaryEntry = helpContexts[0];
                if (primaryEntry instanceof String) {
                    context = HelpSystem.getContext((String)((String)primaryEntry));
                } else if (primaryEntry instanceof IContext) {
                    context = (IContext)primaryEntry;
                }
            }
            if (context == null) {
                context = HelpSystem.getContext((String)"org.eclipse.ui.missing");
            }
            if (context != null) {
                Point point = WorkbenchHelpSystem.computePopUpLocation(event.widget.getDisplay());
                WorkbenchHelpSystem.getInstance().displayContext(context, point.x, point.y);
            }
        }
    }
}

