/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.presentation;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CollapseAllAction;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.ExpandAllAction;
import org.eclipse.emf.edit.ui.action.FindAction;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.RevertAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.maven.DOMElement;
import org.eclipse.oomph.maven.Realm;
import org.eclipse.oomph.maven.impl.RealmImpl;
import org.eclipse.oomph.maven.presentation.MavenEditor;
import org.eclipse.oomph.maven.presentation.MavenEditorPlugin;
import org.eclipse.oomph.maven.util.MavenValidator;
import org.eclipse.oomph.maven.util.POMXMLUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.w3c.dom.Document;

public class MavenActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(MavenEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                MavenActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                MavenEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(MavenEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return MavenActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (MavenActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)MavenActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;
    private final List<MavenEditorAction<?>> mavenEditorActions = List.of(new ReconcileRealmAction(), new ApplyElementEditsAction());

    public MavenActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.liveValidationAction = new DiagnosticDecorator.LiveValidator.LiveValidationAction(MavenEditorPlugin.getPlugin().getDialogSettings());
        this.controlAction = new ControlAction();
        this.findAction = FindAction.create();
        this.revertAction = new RevertAction();
        this.expandAllAction = new ExpandAllAction();
        this.collapseAllAction = new CollapseAllAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator("maven-settings"));
        toolBarManager.add((IContributionItem)new Separator("maven-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(MavenEditorPlugin.INSTANCE.getString("_UI_MavenEditor_menu"), "org.eclipse.oomph.mavenMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(MavenEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(MavenEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditorGen(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void setActiveEditor(IEditorPart part) {
        this.setActiveEditorGen(part);
        for (MavenEditorAction<?> mavenEditorAction : this.mavenEditorActions) {
            mavenEditorAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        }
    }

    public void selectionChangedGen(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChangedGen(event);
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShowGen(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(MavenEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(MavenEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.menuAboutToShowGen(menuManager);
        for (MavenEditorAction<?> mavenEditorAction : this.mavenEditorActions) {
            mavenEditorAction.selectionChanged();
            menuManager.insertBefore("ui-actions", mavenEditorAction);
        }
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    private static class ApplyElementEditsAction
    extends MavenEditorAction<DOMElement> {
        private final Map<Document, Map<POMXMLUtil.TextRegion, MavenValidator.ElementEdit>> edits = new LinkedHashMap<Document, Map<POMXMLUtil.TextRegion, MavenValidator.ElementEdit>>();

        public ApplyElementEditsAction() {
            super(MavenEditorPlugin.INSTANCE.getString("_UI_ApplyEdits_label"));
        }

        @Override
        protected List<? extends DOMElement> getApplicableObjects(Object selectedObject) {
            Resource resource;
            Iterator iterator;
            if (selectedObject instanceof Resource && (iterator = (resource = (Resource)selectedObject).getContents().iterator()).hasNext()) {
                EObject eObject = (EObject)iterator.next();
                return this.getApplicableObjects(eObject);
            }
            if (selectedObject instanceof DOMElement) {
                DOMElement domElement = (DOMElement)selectedObject;
                return List.of(domElement);
            }
            if (selectedObject instanceof Realm) {
                Realm realm = (Realm)selectedObject;
                return realm.getProjects();
            }
            return List.of();
        }

        @Override
        protected boolean recomputeEnabled() {
            this.edits.clear();
            for (DOMElement domElement : this.elements) {
                Map elementEdits = domElement.getElementEdits();
                for (Map.Entry entry : elementEdits.entrySet()) {
                    this.edits.computeIfAbsent((Document)entry.getKey(), key -> new TreeMap()).putAll((Map)entry.getValue());
                }
            }
            return !this.edits.isEmpty();
        }

        public void run() {
            ApplyEditsCommand applyEditsCommand = new ApplyEditsCommand(this.edits);
            applyEditsCommand.setLabel(this.getText());
            applyEditsCommand.setDescription(this.getDescription());
            this.mavenEditor.getEditingDomain().getCommandStack().execute((Command)applyEditsCommand);
            Map appliedEdits = POMXMLUtil.applyElementEdits(this.edits);
            for (Map.Entry entry : appliedEdits.entrySet()) {
                Document document = (Document)entry.getKey();
                try {
                    String content = (String)entry.getValue();
                    if (!Boolean.FALSE.booleanValue()) continue;
                    Files.writeString(POMXMLUtil.getLocation((Document)document), (CharSequence)content, POMXMLUtil.getEncoding((Document)document), new OpenOption[0]);
                }
                catch (IOException ex) {
                    MavenEditorPlugin.INSTANCE.log(ex);
                }
            }
        }

        static class ApplyEditsCommand
        extends AbstractCommand
        implements AbstractCommand.NonDirtying {
            private Map<Document, Map<POMXMLUtil.TextRegion, MavenValidator.ElementEdit>> edits;
            private Map<Document, String> undoContents = new LinkedHashMap<Document, String>();
            private Map<Document, String> redoContents = new LinkedHashMap<Document, String>();

            public ApplyEditsCommand(Map<Document, Map<POMXMLUtil.TextRegion, MavenValidator.ElementEdit>> edits) {
                this.edits = edits;
            }

            protected boolean prepare() {
                return true;
            }

            public void execute() {
                Map appliedEdits = POMXMLUtil.applyElementEdits(this.edits);
                for (Map.Entry entry : appliedEdits.entrySet()) {
                    Document document = (Document)entry.getKey();
                    String content = (String)entry.getValue();
                    try {
                        Charset encoding = POMXMLUtil.getEncoding((Document)document);
                        Path location = POMXMLUtil.getLocation((Document)document);
                        this.undoContents.put(document, Files.readString(location, encoding));
                        Files.writeString(location, (CharSequence)content, encoding, new OpenOption[0]);
                        this.redoContents.put(document, content);
                    }
                    catch (IOException ex) {
                        MavenEditorPlugin.INSTANCE.log(ex);
                    }
                }
            }

            public void undo() {
                this.apply(this.undoContents, null, null);
            }

            public void redo() {
                this.apply(this.redoContents, null, null);
            }

            private void apply(Map<Document, String> contents, Map<Document, String> undoContents, Map<Document, String> redoContents) {
                for (Map.Entry<Document, String> entry : contents.entrySet()) {
                    Document document = entry.getKey();
                    String content = entry.getValue();
                    try {
                        Charset encoding = POMXMLUtil.getEncoding((Document)document);
                        Path location = POMXMLUtil.getLocation((Document)document);
                        if (undoContents != null) {
                            undoContents.put(document, Files.readString(location, encoding));
                        }
                        Files.writeString(location, (CharSequence)content, encoding, new OpenOption[0]);
                        if (redoContents == null) continue;
                        redoContents.put(document, content);
                    }
                    catch (IOException ex) {
                        MavenEditorPlugin.INSTANCE.log(ex);
                    }
                }
            }
        }
    }

    private static abstract class MavenEditorAction<T>
    extends Action {
        protected MavenEditor mavenEditor;
        protected List<T> elements = new ArrayList<T>();

        public MavenEditorAction(String label) {
            super(label);
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof MavenEditor) {
                this.mavenEditor = (MavenEditor)workbenchPart;
                this.selectionChanged();
            } else {
                this.setEnabled(false);
                this.elements.clear();
                this.mavenEditor = null;
            }
        }

        public final void selectionChanged() {
            this.checkEnabled((IStructuredSelection)(this.mavenEditor == null ? StructuredSelection.EMPTY : (IStructuredSelection)this.mavenEditor.getSelection()));
        }

        protected abstract List<? extends T> getApplicableObjects(Object var1);

        protected void checkEnabled(IStructuredSelection selection) {
            this.elements.clear();
            for (Object object : selection) {
                this.elements.addAll(this.getApplicableObjects(object));
            }
            this.setEnabled(this.recomputeEnabled());
        }

        protected boolean recomputeEnabled() {
            return !this.elements.isEmpty();
        }
    }

    static class ReconcileRealmAction
    extends MavenEditorAction<Realm> {
        public ReconcileRealmAction() {
            super(MavenEditorPlugin.INSTANCE.getString("_UI_Reconcile_label"));
            this.setDescription(MavenEditorPlugin.INSTANCE.getString("_UI_Reconcile_description"));
        }

        @Override
        protected List<? extends Realm> getApplicableObjects(Object selectedObject) {
            EObject eObject;
            EObject root;
            Resource resource;
            Iterator iterator;
            if (selectedObject instanceof Resource && (iterator = (resource = (Resource)selectedObject).getContents().iterator()).hasNext()) {
                EObject eObject2 = (EObject)iterator.next();
                return this.getApplicableObjects(eObject2);
            }
            if (selectedObject instanceof EObject && (root = EcoreUtil.getRootContainer((EObject)(eObject = (EObject)selectedObject))) instanceof Realm) {
                Realm realm = (Realm)root;
                return List.of(realm);
            }
            return List.of();
        }

        public void run() {
            ReconcileCommand reconcileCommand = new ReconcileCommand((Realm)this.elements.get(0));
            reconcileCommand.setLabel(this.getText());
            reconcileCommand.setDescription(this.getDescription());
            this.mavenEditor.getEditingDomain().getCommandStack().execute((Command)reconcileCommand);
        }

        static class ReconcileCommand
        extends AbstractCommand
        implements AbstractCommand.NonDirtying {
            private RealmImpl realm;
            private RealmImpl.State state;

            public ReconcileCommand(Realm realm) {
                this.realm = (RealmImpl)realm;
            }

            protected boolean prepare() {
                return true;
            }

            public void execute() {
                this.state = this.realm.getState();
                this.realm.reconcile();
            }

            public void undo() {
                this.realm.setState(this.state);
            }

            public void redo() {
                this.realm.reconcile();
            }
        }
    }
}

