/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui.internal.pde;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.oomph.ui.internal.pde.Target;
import org.eclipse.oomph.ui.internal.pde.TargetSnapshot;
import org.eclipse.oomph.ui.internal.pde.UIPDEPlugin;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventHandler;

public final class TargetManager
implements IDisposable {
    private static final Target[] NO_TARGETS = new Target[0];
    private static final ThreadLocal<List<Event>> EVENTS = new InheritableThreadLocal<List<Event>>();
    private static Method TARGET_DEFINITION_WRITE_METHOD = TargetManager.getTargetDefinitionMethod("write", OutputStream.class);
    private static Method TARGET_DEFINITION_SET_CONTENTS_METHOD = TargetManager.getTargetDefinitionMethod("setContents", InputStream.class);
    private final EventHandler targetPlatformEventHandler = event -> {
        String topic = event.getTopic();
        Object data = event.getProperty("org.eclipse.e4.data");
        if ("org/eclipse/pde/core/target/TargetEvents/targetSaved".equals(topic)) {
            this.targetSaved((ITargetHandle)data, false);
        } else if ("org/eclipse/pde/core/target/TargetEvents/targetDeleted".equals(topic)) {
            this.targetDeleted((ITargetHandle)data);
        } else if ("org/eclipse/pde/core/target/TargetEvents/workspaceTargetChanged".equals(topic)) {
            ITargetHandle handle = ((ITargetDefinition)data).getHandle();
            this.activeTargetChanged(handle);
        }
    };
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Map<ITargetHandle, Target> targets = new HashMap<ITargetHandle, Target>();
    private Target[] sortedTargets = NO_TARGETS;
    private Target activeTarget;
    private Target monitoredTarget;
    private String defaultTargetName;
    private boolean autoSnapshot;

    public TargetManager() {
        try {
            TargetPlatformUtil.runWithTargetPlatformService(service -> {
                ITargetHandle handle;
                ITargetHandle[] iTargetHandleArray = service.getTargets((IProgressMonitor)new NullProgressMonitor());
                int n = iTargetHandleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    handle = iTargetHandleArray[n2];
                    ITargetDefinition definition = handle.getTargetDefinition();
                    this.targets.put(handle, new Target(this, handle, definition.getName()));
                    ++n2;
                }
                this.sortedTargets = TargetManager.sortTargets(this.targets);
                handle = service.getWorkspaceTargetHandle();
                this.activeTarget = this.targets.get(handle);
                ITargetDefinition defaultTarget = service.newDefaultTarget();
                this.defaultTargetName = defaultTarget.getName();
                return null;
            });
        }
        catch (CoreException ex) {
            throw new WrappedException((Exception)((Object)ex));
        }
        TargetManager.withEventBroker(broker -> {
            broker.subscribe("org/eclipse/pde/core/target/TargetEvents/targetSaved", this.targetPlatformEventHandler);
            broker.subscribe("org/eclipse/pde/core/target/TargetEvents/targetDeleted", this.targetPlatformEventHandler);
            broker.subscribe("org/eclipse/pde/core/target/TargetEvents/workspaceTargetChanged", this.targetPlatformEventHandler);
        });
    }

    public void dispose() {
        this.listeners.clear();
        TargetManager.withEventBroker(broker -> {
            boolean bl = broker.unsubscribe(this.targetPlatformEventHandler);
        });
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public boolean isAutoSnapshot() {
        return this.autoSnapshot;
    }

    public void setAutoSnapshot(boolean autoSnapshot) {
        if (this.autoSnapshot != autoSnapshot) {
            Target target;
            this.autoSnapshot = autoSnapshot;
            if (autoSnapshot && (target = this.monitoredTarget) != null && target.getCurrentSnapshot() == null) {
                this.targetSaved(target.getHandle(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target getTarget(ITargetHandle handle) {
        Map<ITargetHandle, Target> map = this.targets;
        synchronized (map) {
            return this.targets.get(handle);
        }
    }

    public Target[] getTargets() {
        return this.sortedTargets;
    }

    public Target getActiveTarget() {
        return this.activeTarget;
    }

    public Target getMonitoredTarget() {
        return this.monitoredTarget;
    }

    boolean monitorTarget(Target target) {
        return this.modify(events -> {
            if (target != this.monitoredTarget) {
                this.monitoredTarget = target;
                events.accept(Event.Kind.MonitoredTargetChanged, this.monitoredTarget);
                if (this.monitoredTarget != null && this.monitoredTarget.getSnapshots().length == 0) {
                    ITargetHandle handle = target.getHandle();
                    this.targetSaved(handle, false);
                }
            }
        });
    }

    String getDefaultTargetName() {
        return this.defaultTargetName;
    }

    void deleteSnapshots(Target target, Collection<TargetSnapshot> snapshots) {
        this.modify(events -> {
            target.internalDeleteSnapshots(snapshots);
            for (TargetSnapshot snapshot : snapshots) {
                events.accept(Event.Kind.TargetSnapshotRemoved, snapshot);
            }
        });
    }

    void snapshotResolutionStarted(TargetSnapshot snapshot, ITargetDefinition definition) {
        this.modify(events -> {
            snapshot.setResolving();
            events.accept(Event.Kind.TargetSnapshotResolutionStarted, snapshot);
        });
    }

    void snapshotResolutionFinished(TargetSnapshot snapshot, ITargetDefinition definition) {
        this.modify(events -> {
            snapshot.doUpdate(definition);
            events.accept(Event.Kind.TargetSnapshotResolutionFinished, snapshot);
        });
    }

    boolean restoreSnapshot(TargetSnapshot snapshot) {
        String xml = snapshot.getXML();
        if (xml != null) {
            try {
                TargetPlatformUtil.runWithTargetPlatformService(service -> {
                    ITargetDefinition definition = snapshot.getTarget().getHandle().getTargetDefinition();
                    if (TargetManager.setXML(definition, xml)) {
                        service.saveTargetDefinition(definition);
                        return true;
                    }
                    return false;
                });
            }
            catch (Exception ex) {
                UIPDEPlugin.INSTANCE.log(ex);
            }
        }
        return false;
    }

    TargetSnapshot targetSaved(ITargetHandle handle, boolean forced) {
        TargetSnapshot[] result = new TargetSnapshot[1];
        ITargetDefinition definition = TargetManager.getDefinition(handle);
        if (definition != null) {
            String name = definition.getName();
            String xml = TargetManager.getXML(definition);
            this.modify(events -> {
                Target target = this.targets.get(handle);
                if (target == null) {
                    target = new Target(this, handle, name);
                    this.targets.put(handle, target);
                    this.sortedTargets = TargetManager.sortTargets(this.targets);
                    events.accept(Event.Kind.TargetAdded, target);
                } else if (!Objects.equals(target.getName(), name)) {
                    target.setName(name);
                    events.accept(Event.Kind.TargetNameChanged, target);
                }
                if (forced || this.autoSnapshot) {
                    targetSnapshotArray[0] = target.internalTakeSnapshot(xml);
                    events.accept(Event.Kind.TargetSnapshotAdded, result[0]);
                    if (result[0].update(definition)) {
                        events.accept(Event.Kind.TargetSnapshotResolutionFinished, result[0]);
                    }
                }
            });
        }
        return result[0];
    }

    private void targetDeleted(ITargetHandle handle) {
        this.modify(events -> {
            Target target = this.targets.remove(handle);
            if (target != null) {
                this.sortedTargets = TargetManager.sortTargets(this.targets);
                events.accept(Event.Kind.TargetRemoved, target);
                if (target == this.monitoredTarget) {
                    this.monitoredTarget = null;
                    events.accept(Event.Kind.MonitoredTargetChanged, this);
                }
            }
        });
    }

    private void activeTargetChanged(ITargetHandle handle) {
        this.modify(events -> {
            Target target = this.targets.get(handle);
            if (target != this.activeTarget) {
                this.activeTarget = target;
                events.accept(Event.Kind.ActiveTargetChanged, this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modify(Modifier modifier) {
        boolean outermost;
        List<Event> events = EVENTS.get();
        boolean bl = outermost = events == null;
        if (outermost) {
            events = new ArrayList<Event>();
            EVENTS.set(events);
        }
        int initialEventsSize = events.size();
        try {
            List<Event> eventList = events;
            Map<ITargetHandle, Target> map = this.targets;
            synchronized (map) {
                modifier.run((kind, subject) -> {
                    boolean bl = eventList.add(new Event((Event.Kind)((Object)kind), subject));
                });
            }
            if (outermost && !eventList.isEmpty()) {
                for (Listener listener : this.listeners) {
                    try {
                        listener.handleTargetManagerEvents(eventList);
                    }
                    catch (Exception ex) {
                        UIPDEPlugin.INSTANCE.log(ex);
                    }
                }
            }
        }
        finally {
            if (outermost) {
                EVENTS.remove();
            }
        }
        return events.size() > initialEventsSize;
    }

    private static ITargetDefinition getDefinition(ITargetHandle handle) {
        try {
            return handle.getTargetDefinition();
        }
        catch (Exception ex) {
            UIPDEPlugin.INSTANCE.log(ex);
            return null;
        }
    }

    private static String getXML(ITargetDefinition definition) {
        if (TARGET_DEFINITION_WRITE_METHOD != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ReflectUtil.invokeMethod((Method)TARGET_DEFINITION_WRITE_METHOD, (Object)definition, (Object[])new Object[]{baos});
                return new String(baos.toByteArray(), StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                UIPDEPlugin.INSTANCE.log(ex);
            }
        }
        return null;
    }

    private static boolean setXML(ITargetDefinition definition, String xml) {
        if (TARGET_DEFINITION_SET_CONTENTS_METHOD != null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
                ReflectUtil.invokeMethod((Method)TARGET_DEFINITION_SET_CONTENTS_METHOD, (Object)definition, (Object[])new Object[]{bais});
                return true;
            }
            catch (Exception ex) {
                UIPDEPlugin.INSTANCE.log(ex);
            }
        }
        return false;
    }

    private static void withEventBroker(Consumer<IEventBroker> consumer) {
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)UIPDEPlugin.INSTANCE.getBundleContext());
        IEventBroker broker = (IEventBroker)context.get(IEventBroker.class);
        if (broker != null) {
            consumer.accept(broker);
        }
    }

    private static Target[] sortTargets(Map<ITargetHandle, Target> targets) {
        Object[] sortedTargets = targets.values().toArray(new Target[targets.size()]);
        Arrays.sort(sortedTargets);
        return sortedTargets;
    }

    private static Method getTargetDefinitionMethod(String methodName, Class<?> ... parameterTypes) {
        try {
            return ReflectUtil.getMethod(TargetDefinition.class, (String)methodName, (Class[])parameterTypes);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static final class Event {
        private final Kind kind;
        private final Object subject;

        Event(Kind kind, Object subject) {
            this.kind = kind;
            this.subject = subject;
        }

        public Kind getKind() {
            return this.kind;
        }

        public TargetManager getManager() {
            if (this.subject instanceof TargetManager) {
                return (TargetManager)this.subject;
            }
            if (this.subject instanceof Target) {
                return ((Target)this.subject).getManager();
            }
            if (this.subject instanceof TargetSnapshot) {
                return ((TargetSnapshot)this.subject).getTarget().getManager();
            }
            return null;
        }

        public Target getTarget() {
            if (this.subject instanceof Target) {
                return (Target)this.subject;
            }
            if (this.subject instanceof TargetSnapshot) {
                return ((TargetSnapshot)this.subject).getTarget();
            }
            return null;
        }

        public TargetSnapshot getSnapshot() {
            if (this.subject instanceof TargetSnapshot) {
                return (TargetSnapshot)this.subject;
            }
            return null;
        }

        public String toString() {
            return String.valueOf((Object)this.kind) + "[" + String.valueOf(this.subject) + "]";
        }

        public static enum Kind {
            TargetAdded,
            TargetRemoved,
            TargetNameChanged,
            ActiveTargetChanged,
            MonitoredTargetChanged,
            TargetSnapshotAdded,
            TargetSnapshotRemoved,
            TargetSnapshotResolutionStarted,
            TargetSnapshotResolutionFinished;

        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void handleTargetManagerEvents(List<Event> var1);
    }

    @FunctionalInterface
    private static interface Modifier {
        public void run(BiConsumer<Event.Kind, Object> var1);
    }
}

