/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.AbstractCompletionProposalFactory;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ContentProposalLabelProvider;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class UiToIdeContentProposalProvider
extends AbstractCompletionProposalFactory
implements IContentProposalProvider {
    @Inject
    private IdeContentProposalProvider ideProvider;
    @Inject
    private Provider<ContentAssistContext.Builder> builderProvider;
    @Inject
    @ContentProposalLabelProvider
    private ILabelProvider labelProvider;

    @Override
    public void createProposals(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        final ArrayList<AbstractMap.SimpleEntry> entries = new ArrayList<AbstractMap.SimpleEntry>();
        IIdeContentProposalAcceptor ideAcceptor = new IIdeContentProposalAcceptor(){

            public void accept(ContentAssistEntry entry, int priority) {
                if (entry != null) {
                    entries.add(new AbstractMap.SimpleEntry<ContentAssistEntry, Integer>(entry, priority));
                }
            }

            public boolean canAcceptMoreProposals() {
                return entries.size() < UiToIdeContentProposalProvider.this.getMaxProposals();
            }
        };
        this.ideProvider.createProposals(Arrays.asList(this.getIdeContext(context)), ideAcceptor);
        AbstractContentProposalProvider.NullSafeCompletionProposalAcceptor uiAcceptor = new AbstractContentProposalProvider.NullSafeCompletionProposalAcceptor(acceptor);
        entries.forEach(entry -> {
            ContentAssistEntry cae = (ContentAssistEntry)entry.getKey();
            ConfigurableCompletionProposal proposal = this.doCreateProposal(cae.getProposal(), this.getDisplayString(cae), this.getImage(cae), (int)((Integer)entry.getValue()), context);
            uiAcceptor.accept(proposal);
        });
    }

    protected int getMaxProposals() {
        return 1000;
    }

    private org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext getIdeContext(ContentAssistContext cac) {
        ContentAssistContext.Builder builder = (ContentAssistContext.Builder)this.builderProvider.get();
        Region replaceRegion = cac.getReplaceRegion();
        builder.setPrefix(cac.getPrefix()).setSelectedText(cac.getSelectedText()).setRootModel(cac.getRootModel()).setRootNode(cac.getRootNode()).setCurrentModel(cac.getCurrentModel()).setPreviousModel(cac.getPreviousModel()).setCurrentNode(cac.getCurrentNode()).setLastCompleteNode(cac.getLastCompleteNode()).setOffset(cac.getOffset()).setReplaceRegion((ITextRegion)new TextRegion(replaceRegion.getOffset(), replaceRegion.getLength())).setResource(cac.getResource());
        cac.getFirstSetGrammarElements().forEach(grammarElement -> builder.accept(grammarElement));
        return builder.toContext();
    }

    protected StyledString getDisplayString(ContentAssistEntry entry) {
        StyledString result = new StyledString(entry.getLabel() != null ? entry.getLabel() : entry.getProposal());
        if (!Strings.isNullOrEmpty((String)entry.getDescription())) {
            result.append(new StyledString(" \u2013 " + entry.getDescription(), StyledString.QUALIFIER_STYLER));
        }
        return result;
    }

    protected Image getImage(ContentAssistEntry entry) {
        Object source = entry.getSource();
        if (source instanceof IEObjectDescription) {
            return this.getImage((IEObjectDescription)source);
        }
        if (source instanceof EObject) {
            return this.getImage((EObject)source);
        }
        return null;
    }

    protected Image getImage(IEObjectDescription description) {
        return this.getImage(description.getEObjectOrProxy());
    }

    protected Image getImage(EObject eObject) {
        return this.labelProvider.getImage((Object)eObject);
    }
}

