/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import lpg.runtime.IToken;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTParsingOptions;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ExternalUnitElementsProvider;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParser;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalValidationVisitor;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.WorkspaceMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.BasicLineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.ExeXMISerializer;
import org.eclipse.m2m.internal.qvt.oml.compiler.LegacyResolverSupport;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.cst.ImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.AbstractQVTParser;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfStandaloneMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.lpg.AbstractLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTOCompiler {
    private static final String NAMESPACE_SEP = String.valueOf('.');
    private final Map<URI, CompiledUnit> fSource2Compiled = new HashMap<URI, CompiledUnit>();
    private final Stack<DependencyPathElement> fDependencyWalkPath = new Stack();
    private final IMetamodelRegistryProvider fMetamodelRegistryProvider;
    private final ResourceSet resourceSet;
    private ResourceSetImpl fExeXMIResourceSet;
    private boolean fUseCompiledXMI = false;

    public static QVTOCompiler createCompilerWithHistory(ResourceSet metamodelResourceSet) {
        return new QVTOCompiler(QVTOCompiler.createMetamodelRegistryProvider(metamodelResourceSet)){

            protected void afterCompileCleanup() {
            }

            public void cleanup() {
                super.cleanup();
                this.afterCompileCleanup();
            }
        };
    }

    public static QVTOCompiler createCompiler(EPackage.Registry registry) {
        ResourceSetImpl rs = new ResourceSetImpl();
        if (registry != null) {
            rs.setPackageRegistry(registry);
            HashMap<URI, Resource> uriResourceMap = new HashMap<URI, Resource>();
            for (Object nextEntry : registry.values()) {
                EPackage ePackage;
                Resource resource;
                if (!(nextEntry instanceof EPackage) || (resource = (ePackage = (EPackage)nextEntry).eResource()) == null) continue;
                uriResourceMap.put(resource.getURI(), resource);
            }
            if (!uriResourceMap.isEmpty()) {
                rs.setURIResourceMap(uriResourceMap);
            }
        }
        EPackageRegistryImpl packageRegistryImpl = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        packageRegistryImpl.putAll((Map)registry);
        IMetamodelRegistryProvider metamodelRegistryProvider = QVTOCompiler.createMetamodelRegistryProvider((EPackage.Registry)packageRegistryImpl, (ResourceSet)rs);
        return new QVTOCompiler(metamodelRegistryProvider);
    }

    public static CompiledUnit[] compile(Set<URI> unitURIs, EPackage.Registry registry) throws MdaException {
        BasicEList unitProxies = new BasicEList();
        for (URI importURI : unitURIs) {
            UnitProxy unit = UnitResolverFactory.Registry.INSTANCE.getUnit(importURI);
            if (unit == null) continue;
            unitProxies.add((Object)unit);
        }
        if (!unitProxies.isEmpty()) {
            QVTOCompiler compiler = QVTOCompiler.createCompiler(registry);
            QvtCompilerOptions options = new QvtCompilerOptions();
            options.setGenerateCompletionData(true);
            return compiler.compile((UnitProxy[])unitProxies.toArray((Object[])new UnitProxy[unitProxies.size()]), options, null);
        }
        return new CompiledUnit[0];
    }

    public QVTOCompiler(IMetamodelRegistryProvider metamodelRegistryProvider) {
        Map uriResourceMap;
        this.fMetamodelRegistryProvider = metamodelRegistryProvider;
        this.resourceSet = metamodelRegistryProvider instanceof WorkspaceMetamodelRegistryProvider ? ((WorkspaceMetamodelRegistryProvider)metamodelRegistryProvider).getResolutionResourceSet() : new ResourceSetImpl();
        this.fExeXMIResourceSet = CompiledUnit.createResourceSet();
        if (this.getResourceSet() instanceof ResourceSetImpl && (uriResourceMap = ((ResourceSetImpl)this.getResourceSet()).getURIResourceMap()) != null) {
            this.fExeXMIResourceSet.setURIResourceMap(new HashMap(uriResourceMap));
        }
    }

    public void setUseCompiledXMI(boolean flag) {
        this.fUseCompiledXMI = flag;
    }

    public CompiledUnit[] compile(UnitProxy[] sources, QvtCompilerOptions options, Monitor monitor) throws MdaException {
        if (options == null) {
            options = this.getDefaultOptions();
        }
        if (monitor == null) {
            monitor = CompilerUtils.createNullMonitor();
        }
        CompiledUnit[] result = new CompiledUnit[sources.length];
        try {
            monitor.beginTask("Compile sources", sources.length);
            int i = 0;
            UnitProxy[] unitProxyArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                UnitProxy nextSource = unitProxyArray[n2];
                if (this.isAborted(monitor)) {
                    CompilerUtils.throwOperationCanceled();
                }
                result[i++] = this.compileSingleFile(nextSource, options, CompilerUtils.createMonitor(monitor, 1));
                ++n2;
            }
        }
        finally {
            this.fDependencyWalkPath.clear();
            this.afterCompileCleanup();
            monitor.done();
        }
        return result;
    }

    public CompiledUnit compile(UnitProxy source, QvtCompilerOptions options, Monitor monitor) throws MdaException {
        return this.compile(new UnitProxy[]{source}, options, monitor)[0];
    }

    protected CSTParseResult parse(UnitProxy source, QvtCompilerOptions options) throws ParserException {
        Reader reader = null;
        UnitCS unitCS = null;
        try {
            reader = this.createReader(source);
            EPackage.Registry ePackageRegistry = this.getEPackageRegistry(source.getURI());
            QvtOperationalFileEnv env = new QvtOperationalEnvFactory(ePackageRegistry).createEnvironment(source.getURI());
            if (options.isEnableCSTModelToken()) {
                env.setOption(QVTParsingOptions.ENABLE_CSTMODEL_TOKENS, true);
            }
            QvtOperationalParser qvtParser = new QvtOperationalParser();
            unitCS = qvtParser.parse(reader, source.getName(), env);
            CSTParseResult result = new CSTParseResult();
            result.unitCS = unitCS;
            result.env = env;
            result.parser = qvtParser.getParser();
            CSTParseResult cSTParseResult = result;
            return cSTParseResult;
        }
        catch (IOException e) {
            String ioErrorMessage = NLS.bind(CompilerMessages.sourceReadingIOError, source.getURI());
            throw new ParserException(ioErrorMessage, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Reader getContentReader(UnitProxy unit) throws IOException {
        UnitContents contents = unit.getContents();
        if (!(contents instanceof UnitContents.CSTContents)) {
            throw new IllegalArgumentException("unit has no CST stream");
        }
        UnitContents.CSTContents cst = (UnitContents.CSTContents)contents;
        return cst.getContents();
    }

    protected Reader createReader(UnitProxy unit) throws IOException {
        return QVTOCompiler.getContentReader(unit);
    }

    private CSTAnalysisResult analyze(CSTParseResult parseResult, UnitProxy unit, ExternalUnitElementsProvider externalUnitElementsProvider, QvtCompilerOptions options, Monitor monitor) {
        QvtOperationalFileEnv env = parseResult.env;
        env.setQvtCompilerOptions(options);
        CSTAnalysisResult result = new CSTAnalysisResult();
        try {
            QvtOperationalVisitorCS visitor = this.createAnalyzer(parseResult.parser, options, monitor);
            UnitCS unitCS = parseResult.unitCS;
            if (unitCS != null && !unitCS.getModules().isEmpty()) {
                result.moduleEnvs = visitor.visitUnitCS(unitCS, unit, env, externalUnitElementsProvider, this.getResourceSet());
            }
        }
        catch (SemanticException e) {
            env.reportError(e.getLocalizedMessage(), 0, 0);
        }
        if (result.moduleEnvs != null) {
            for (QvtOperationalModuleEnv moduleEnv : result.moduleEnvs) {
                if (!options.isReportErrors()) continue;
                moduleEnv.setCheckForDuplicateErrors(true);
                QvtOperationalValidationVisitor validation = new QvtOperationalValidationVisitor(moduleEnv);
                validation.visitModule(moduleEnv.getModuleContextType());
                moduleEnv.setCheckForDuplicateErrors(false);
            }
        }
        return result;
    }

    protected QvtOperationalVisitorCS createAnalyzer(AbstractQVTParser parser, QvtCompilerOptions options, Monitor monitor) {
        return new QvtOperationalVisitorCS(parser, options, monitor);
    }

    protected void afterCompileCleanup() {
        this.fSource2Compiled.clear();
        this.fDependencyWalkPath.clear();
        this.fExeXMIResourceSet.getResources().clear();
    }

    private CompiledUnit compileSingleFile(UnitProxy source, QvtCompilerOptions options, Monitor monitor) throws MdaException {
        CompiledUnit nextResult = null;
        try {
            nextResult = this.doCompile(source, options, monitor);
        }
        catch (ParserException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new MdaException(cause.getMessage(), cause);
        }
        catch (IOException e) {
            throw new MdaException(e.getMessage(), (Throwable)e);
        }
        return nextResult;
    }

    private CompiledUnit doCompile(UnitProxy source, QvtCompilerOptions options, Monitor monitor) throws ParserException, IOException {
        try {
            CompiledUnit binXMIUnit;
            monitor.beginTask(String.valueOf('\'') + source.getURI().toString() + '\'', 3);
            monitor.subTask("");
            List compiledImports = null;
            DependencyPathElement dependencyElement = new DependencyPathElement(source);
            this.fDependencyWalkPath.push(dependencyElement);
            if (this.fSource2Compiled.containsKey(source.getURI())) {
                CompiledUnit compiledUnit = this.fSource2Compiled.get(source.getURI());
                return compiledUnit;
            }
            if (this.fUseCompiledXMI && (binXMIUnit = this.getCompiledExeXMIUnit(source)) != null) {
                this.fSource2Compiled.put(source.getURI(), binXMIUnit);
                CompiledUnit compiledUnit = binXMIUnit;
                return compiledUnit;
            }
            if (source.getContentType() != 0) {
                CompiledUnit loadBlackboxUnit = this.loadBlackboxUnit(source);
                this.fSource2Compiled.put(source.getURI(), loadBlackboxUnit);
                CompiledUnit compiledUnit = loadBlackboxUnit;
                return compiledUnit;
            }
            CSTParseResult parseResult = this.parse(source, options);
            monitor.worked(1);
            QvtOperationalFileEnv env = parseResult.env;
            dependencyElement.importerEnv = env;
            UnitCS unitCS = parseResult.unitCS;
            UnitResolverImpl unitResolver = new UnitResolverImpl(source);
            List<ImportCS> allUnitImportsCS = parseResult.getImports();
            Monitor importsMonitor = CompilerUtils.createMonitor(monitor, 1);
            importsMonitor.beginTask("Process imports", allUnitImportsCS.size());
            for (ImportCS nextImportCS : allUnitImportsCS) {
                String importQNameStr = QVTOCompiler.getQualifiedName(nextImportCS);
                if (importQNameStr == null || importQNameStr.length() == 0) continue;
                List<String> importedUnitQName = QvtOperationalParserUtil.getSequenceOfNames((List<SimpleNameCS>)nextImportCS.getPathNameCS().getSimpleNames());
                UnitProxy importedUnit = this.resolveImportedUnit(source, importQNameStr);
                CompiledUnit compiledImport = null;
                if (importedUnit != null) {
                    dependencyElement.currentProcessedImport = nextImportCS;
                    DependencyPathElement importerDependencyElement = this.findDependencyElement(importedUnit);
                    if (importerDependencyElement != null) {
                        ImportCS importedCS = importerDependencyElement.currentProcessedImport;
                        if (env != importerDependencyElement.importerEnv) {
                            QVTOCompiler.reportCyclicImportError(nextImportCS, importedCS, importerDependencyElement.importerEnv);
                        }
                        QVTOCompiler.reportCyclicImportError(importedCS, nextImportCS, env);
                        continue;
                    }
                    compiledImport = this.doCompile(importedUnit, options, CompilerUtils.createMonitor(importsMonitor, 1));
                } else {
                    String notFoundMessage = NLS.bind(CompilerMessages.importedCompilationUnitNotFound, QvtOperationalParserUtil.getStringRepresentation(nextImportCS.getPathNameCS(), NAMESPACE_SEP));
                    env.reportError(notFoundMessage, (CSTNode)nextImportCS.getPathNameCS());
                    importsMonitor.worked(1);
                }
                if (compiledImport == null) continue;
                if (!compiledImport.getErrors().isEmpty()) {
                    if (importedUnit.getContentType() == 0) {
                        String errorInImportMessage = NLS.bind(CompilerMessages.importHasCompilationError, QvtOperationalParserUtil.getStringRepresentation(nextImportCS.getPathNameCS()));
                        env.reportError(errorInImportMessage, (CSTNode)nextImportCS.getPathNameCS());
                    } else {
                        String rootMessage = compiledImport.getErrors().get(0).getMessage();
                        env.reportError(rootMessage, (CSTNode)nextImportCS.getPathNameCS());
                    }
                }
                if (compiledImports == null) {
                    compiledImports = new UniqueEList();
                }
                compiledImports.add(compiledImport);
                unitResolver.addUnit(importedUnitQName, compiledImport);
            }
            importsMonitor.done();
            monitor.subTask("");
            CSTAnalysisResult analysisResult = this.analyze(parseResult, source, unitResolver, options, monitor);
            if (options.isSourceLineNumbersEnabled()) {
                this.addSourceLineNumberInfo(parseResult.parser, analysisResult, source);
            }
            monitor.worked(1);
            this.checkForDupImports(allUnitImportsCS, env);
            env.close();
            CompiledUnit result = this.createCompiledUnit(source, env);
            result.fUnitCST = unitCS;
            if (compiledImports != null) {
                result.setImports(compiledImports);
            }
            this.fSource2Compiled.put(source.getURI(), result);
            CompiledUnit compiledUnit = result;
            return compiledUnit;
        }
        finally {
            this.fDependencyWalkPath.pop();
            monitor.done();
        }
    }

    private CompiledUnit getCompiledExeXMIUnit(UnitProxy source) {
        URI xmiURI = ExeXMISerializer.toXMIUnitURI(source.getURI());
        if (URIConverter.INSTANCE.exists(xmiURI, null)) {
            Long srcTStamp = (Long)URIConverter.INSTANCE.getAttributes(source.getURI(), null).get("timeStamp");
            Long binTStamp = (Long)URIConverter.INSTANCE.getAttributes(xmiURI, null).get("timeStamp");
            if (binTStamp == null || srcTStamp != null && binTStamp.equals(srcTStamp)) {
                return new CompiledUnit(this.fExeXMIResourceSet.getResource(xmiURI, true), this.fSource2Compiled);
            }
        }
        return null;
    }

    private CompiledUnit createCompiledUnit(UnitProxy unit, QvtOperationalFileEnv env) {
        Resource resource = env.getTypeResolver().getResource();
        resource.setURI(ExeXMISerializer.toXMIUnitURI(unit.getURI()));
        this.fExeXMIResourceSet.getResources().add((Object)resource);
        List<String> qualifiedName = QVTOCompiler.getQualifiedNameSegments(unit);
        return new CompiledUnit(qualifiedName, unit.getURI(), Collections.singletonList(env));
    }

    private static List<String> getQualifiedNameSegments(UnitProxy unit) {
        List<String> qualifiedName = null;
        String namespace = unit.getNamespace();
        if (namespace != null) {
            String[] segments = ResolverUtils.getNameSegments(namespace);
            qualifiedName = new ArrayList<String>(segments.length + 1);
            qualifiedName.addAll(Arrays.asList(segments));
            qualifiedName.add(unit.getName());
        } else {
            qualifiedName = Collections.singletonList(unit.getName());
        }
        return qualifiedName;
    }

    protected final EPackage.Registry getEPackageRegistry(URI context) {
        return CompilerUtils.getEPackageRegistry(context, this.fMetamodelRegistryProvider);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void cleanup() {
        EmfUtil.cleanupResourceSet((ResourceSet)this.getResourceSet());
    }

    private void addSourceLineNumberInfo(AbstractQVTParser parser, CSTAnalysisResult analysisResult, UnitProxy source) {
        URI sourceURI;
        AbstractLexer lexer = parser.getLexer();
        if (lexer != null && (sourceURI = source.getURI()) != null && analysisResult.moduleEnvs != null) {
            for (QvtOperationalModuleEnv moduleEnv : analysisResult.moduleEnvs) {
                ASTBindingHelper.createModuleSourceBinding((EObject)moduleEnv.getModuleContextType(), sourceURI, new BasicLineNumberProvider(lexer));
            }
        }
    }

    private static String getQualifiedName(ImportCS importCS) {
        if (importCS.getPathNameCS() != null) {
            return QvtOperationalParserUtil.getStringRepresentation(importCS.getPathNameCS(), NAMESPACE_SEP);
        }
        return null;
    }

    private CompiledUnit loadBlackboxUnit(UnitProxy unit) throws IOException {
        UnitContents.ModelContents contents = (UnitContents.ModelContents)unit.getContents();
        List<EObject> topElements = contents.loadElements(CompilerUtils.getEPackageRegistry(unit.getURI(), this.fMetamodelRegistryProvider));
        ArrayList<QvtOperationalModuleEnv> modelEnvs = new ArrayList<QvtOperationalModuleEnv>(topElements.size());
        for (EObject nextElement : topElements) {
            QvtOperationalModuleEnv nextEnv = ASTBindingHelper.getEnvironment(nextElement, QvtOperationalModuleEnv.class);
            if (nextEnv == null) continue;
            nextEnv.clearProblems();
            modelEnvs.add(nextEnv);
        }
        CompiledUnit compiledUnit = new CompiledUnit(QVTOCompiler.getQualifiedNameSegments(unit), unit.getURI(), modelEnvs);
        Diagnostic loadProblems = contents.getProblems();
        if (loadProblems != null) {
            compiledUnit.addProblem(new QvtMessage(loadProblems.getMessage()));
        }
        return compiledUnit;
    }

    private QvtCompilerOptions getDefaultOptions() {
        QvtCompilerOptions options = new QvtCompilerOptions();
        options.setGenerateCompletionData(false);
        return options;
    }

    private UnitProxy resolveImportedUnit(UnitProxy importingUnit, String unitQualifiedName) {
        String namespace;
        UnitResolver resolver = importingUnit.getResolver();
        UnitProxy unit = resolver.resolveUnit(unitQualifiedName);
        if (unit == null && (namespace = importingUnit.getNamespace()) != null && !unitQualifiedName.contains(NAMESPACE_SEP)) {
            unit = resolver.resolveUnit(String.valueOf(namespace) + NAMESPACE_SEP + unitQualifiedName);
        }
        if (unit == null && resolver instanceof LegacyResolverSupport) {
            LegacyResolverSupport legacyResolver = (LegacyResolverSupport)resolver;
            unit = legacyResolver.resolveUnit(importingUnit, unitQualifiedName);
        }
        return unit;
    }

    private void checkForDupImports(List<ImportCS> imports, QvtOperationalEnv env) {
        if (imports.size() < 2) {
            return;
        }
        HashSet<IToken> checkedImportTokens = new HashSet<IToken>(imports.size());
        HashSet<Object> checkedImports = new HashSet<Object>(imports.size());
        LinkedList<ImportCS> dupImports = new LinkedList<ImportCS>();
        for (ImportCS nextImportCS : imports) {
            if (nextImportCS.getAst() != null && checkedImports.contains(nextImportCS.getAst()) && !checkedImportTokens.contains(nextImportCS.getStartToken())) {
                dupImports.add(nextImportCS);
                continue;
            }
            checkedImports.add(nextImportCS.getAst());
            checkedImportTokens.add(nextImportCS.getStartToken());
        }
        for (ImportCS nextDupImport : dupImports) {
            PathNameCS problemCS = nextDupImport.getPathNameCS();
            env.reportWarning(NLS.bind(CompilerMessages.compilationUnitAlreadyImported, QvtOperationalParserUtil.getStringRepresentation(problemCS, NAMESPACE_SEP)), (CSTNode)problemCS);
        }
    }

    private static void reportCyclicImportError(ImportCS from, ImportCS to, QvtOperationalEnv env) {
        PathNameCS fromQNameCS = from.getPathNameCS();
        PathNameCS toQNameCS = to.getPathNameCS();
        String message = NLS.bind(CompilerMessages.cyclicImportError, QvtOperationalParserUtil.getStringRepresentation(fromQNameCS, NAMESPACE_SEP), QvtOperationalParserUtil.getStringRepresentation(toQNameCS, NAMESPACE_SEP));
        env.reportError(message, (CSTNode)toQNameCS);
    }

    static void clearITokens(CSTNode node) {
        node.setStartToken(null);
        node.setEndToken(null);
        TreeIterator it = node.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof CSTNode)) continue;
            CSTNode nextCST = (CSTNode)next;
            nextCST.setStartToken(null);
            nextCST.setEndToken(null);
        }
    }

    private DependencyPathElement findDependencyElement(UnitProxy source) {
        for (DependencyPathElement element : this.fDependencyWalkPath) {
            if (!source.equals(element.importer)) continue;
            return element;
        }
        return null;
    }

    private static IMetamodelRegistryProvider createMetamodelRegistryProvider(ResourceSet metamodelResourceSet) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            return CompilerUtils.Eclipse.createMetamodelRegistryProvider(metamodelResourceSet);
        }
        return new IMetamodelRegistryProvider(){

            public MetamodelRegistry getRegistry(IMetamodelRegistryProvider.IRepositoryContext context) {
                return new MetamodelRegistry((IMetamodelProvider)new EmfStandaloneMetamodelProvider());
            }
        };
    }

    private static IMetamodelRegistryProvider createMetamodelRegistryProvider(final EPackage.Registry packageRegistry, ResourceSet metamodelResourceSet) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            return CompilerUtils.Eclipse.createMetamodelRegistryProvider(packageRegistry, metamodelResourceSet);
        }
        return new IMetamodelRegistryProvider(){

            public MetamodelRegistry getRegistry(IMetamodelRegistryProvider.IRepositoryContext context) {
                return new MetamodelRegistry((IMetamodelProvider)new EmfStandaloneMetamodelProvider(packageRegistry));
            }
        };
    }

    private boolean isAborted(Monitor monitor) {
        return monitor.isCanceled();
    }

    protected static class CSTAnalysisResult {
        List<QvtOperationalModuleEnv> moduleEnvs;
        List<ModelType> modelTypes;

        protected CSTAnalysisResult() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CSTParseResult {
        public UnitCS unitCS;
        public QvtOperationalFileEnv env;
        public AbstractQVTParser parser;

        List<ImportCS> getImports() {
            if (this.unitCS != null) {
                return QvtOperationalParserUtil.getImports(this.unitCS);
            }
            return Collections.emptyList();
        }
    }

    private static class DependencyPathElement {
        final UnitProxy importer;
        ImportCS currentProcessedImport;
        QvtOperationalEnv importerEnv;

        public DependencyPathElement(UnitProxy importer) {
            this.importer = importer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnitResolverImpl
    implements ExternalUnitElementsProvider {
        private final Map<List<String>, CompiledUnit> qName2CU = new HashMap<List<String>, CompiledUnit>(5);
        private final UnitProxy source;

        private UnitResolverImpl(UnitProxy importer) {
            this.source = importer;
        }

        void addUnit(List<String> qualifiedName, CompiledUnit unit) {
            this.qName2CU.put(qualifiedName, unit);
        }

        @Override
        public URI getImporter() {
            return this.source.getURI();
        }

        @Override
        public List<QvtOperationalModuleEnv> getModules(List<String> importedUnitQualifiedName) {
            if (importedUnitQualifiedName == null) {
                return Collections.emptyList();
            }
            CompiledUnit compiledUnit = this.qName2CU.get(importedUnitQualifiedName);
            if (compiledUnit != null) {
                return compiledUnit.getModuleEnvironments();
            }
            return Collections.emptyList();
        }
    }
}

