/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Invocation2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceGroup;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;

public class InvocationAnalysis {
    protected final @NonNull RelationAnalysis invokingRelationAnalysis;
    protected final @NonNull RelationAnalysis invokedRelationAnalysis;
    protected final boolean isWhen;
    private final @NonNull Map<@NonNull VariableDeclaration, @NonNull Node> rootVariable2argumentNode = new HashMap<VariableDeclaration, Node>();

    public InvocationAnalysis(@NonNull RelationAnalysis invokingRelationAnalysis, @NonNull RelationAnalysis invokedRelationAnalysis, @NonNull RelationCallExp relationCallExp, boolean isWhen) {
        this.invokingRelationAnalysis = invokingRelationAnalysis;
        this.invokedRelationAnalysis = invokedRelationAnalysis;
        this.isWhen = isWhen;
    }

    public void add(@NonNull VariableDeclaration rootVariable, @NonNull Node argumentNode) {
        Node oldNode = this.rootVariable2argumentNode.put(rootVariable, argumentNode);
        assert (oldNode == null);
    }

    public @NonNull RelationAnalysis getInvokedRelationAnalysis() {
        return this.invokedRelationAnalysis;
    }

    public @NonNull RelationAnalysis getInvokingRelationAnalysis() {
        return this.invokingRelationAnalysis;
    }

    public boolean isWhen() {
        return this.isWhen;
    }

    public void synthesizeInvocationNodes(@NonNull Node invokingTraceNode) {
        VariableNode invokedNode;
        QVTrelationScheduleManager scheduleManager = this.invokedRelationAnalysis.getScheduleManager();
        QVTrelationNameGenerator nameGenerator = scheduleManager.getNameGenerator();
        Relation invokedRelation = this.invokedRelationAnalysis.getRule();
        String name = this.isWhen ? nameGenerator.createWhenInvocationPropertyName((Rule)invokedRelation) : nameGenerator.createWhereInvocationPropertyName((Rule)invokedRelation);
        TypedModel traceTypedModel = scheduleManager.getTraceTypedModel();
        Relation invokingRelation = this.invokingRelationAnalysis.getRule();
        RelationAnalysis2TraceGroup invokingRuleAnalysis2TraceGroup = this.invokingRelationAnalysis.getRuleAnalysis2TraceGroup();
        RelationAnalysis2TraceClass invokingRuleAnalysis2TraceClass = invokingRuleAnalysis2TraceGroup.getRuleAnalysis2TraceClass();
        RelationAnalysis2TraceGroup invokedRuleAnalysis2TraceGroup = this.invokedRelationAnalysis.getRuleAnalysis2TraceGroup();
        if (this.isWhen) {
            Element2MiddleProperty relation2globalSuccessProperty;
            RelationAnalysis2TraceGroup invokedBaseRelationAnalysis2TraceGroup = invokedRuleAnalysis2TraceGroup.getBaseRelationAnalysis2TraceGroup();
            RelationAnalysis2MiddleType invokedRelationAnalysis2InvocationInterface = invokedBaseRelationAnalysis2TraceGroup.getRuleAnalysis2InvocationInterface();
            Class invokedInvocationInterface = invokedRelationAnalysis2InvocationInterface.getMiddleClass();
            ClassDatum classDatum = scheduleManager.getClassDatum(traceTypedModel, invokedInvocationInterface);
            invokedNode = this.invokingRelationAnalysis.createPredicatedNode(name, classDatum, true);
            if (invokingRelation.isIsTopLevel()) {
                Invocation2TraceProperty invokingInvocation2TraceProperty = invokingRuleAnalysis2TraceClass.getInvocation2TraceProperty(this);
                this.invokingRelationAnalysis.createRealizedNavigationEdge(invokingTraceNode, invokingInvocation2TraceProperty.getTraceProperty(), (Node)invokedNode, false);
            }
            if ((relation2globalSuccessProperty = invokedRelationAnalysis2InvocationInterface.basicGetRelation2GlobalSuccessProperty()) != null) {
                Property globalSuccessProperty = relation2globalSuccessProperty.getTraceProperty();
                this.invokingRelationAnalysis.createPredicatedSuccess((Node)invokedNode, globalSuccessProperty, true);
            }
        } else {
            Class invokedInvocationClass = invokedRuleAnalysis2TraceGroup.getInvocationClass();
            ClassDatum classDatum = scheduleManager.getClassDatum(traceTypedModel, invokedInvocationClass);
            invokedNode = this.invokingRelationAnalysis.createRealizedNode(name, classDatum, true);
            Invocation2TraceProperty invokingInvocation2TraceProperty = invokingRuleAnalysis2TraceClass.getInvocation2TraceProperty(this);
            Property invocationProperty = invokingInvocation2TraceProperty.getTraceProperty();
            this.invokingRelationAnalysis.createRealizedNavigationEdge(invokingTraceNode, invocationProperty, (Node)invokedNode, null);
        }
        Relation baseInvokedRelation = QVTrelationUtil.getBaseRelation((Relation)this.invokedRelationAnalysis.getRule());
        RelationAnalysis baseInvokedRelationAnalysis = scheduleManager.getRuleAnalysis((Rule)baseInvokedRelation);
        RelationAnalysis2TraceGroup baseInvokedRelationAnalysis2TraceGroup = baseInvokedRelationAnalysis.getRuleAnalysis2TraceGroup();
        RelationAnalysis2MiddleType baseInvokedRuleAnalysis2MiddleType = QVTrelationUtil.hasOverrides((Relation)invokedRelation) ? baseInvokedRelationAnalysis2TraceGroup.getRuleAnalysis2DispatchClass() : (invokedRelation.isIsTopLevel() ? baseInvokedRelationAnalysis2TraceGroup.getRuleAnalysis2TraceInterface() : baseInvokedRelationAnalysis2TraceGroup.getRuleAnalysis2InvocationInterface());
        for (VariableDeclaration rootVariable : this.rootVariable2argumentNode.keySet()) {
            Node argumentNode = this.rootVariable2argumentNode.get(rootVariable);
            assert (argumentNode != null);
            Variable overriddenRootVariable = QVTrelationUtil.getOverriddenVariable((Relation)baseInvokedRelation, (VariableDeclaration)rootVariable);
            Property invocationProperty = baseInvokedRuleAnalysis2MiddleType.getTraceProperty((VariableDeclaration)overriddenRootVariable);
            this.invokingRelationAnalysis.createNavigationEdge((Node)invokedNode, invocationProperty, argumentNode, null);
        }
    }

    public @NonNull String toString() {
        return String.valueOf(this.invokingRelationAnalysis.getRule().getName()) + "==" + (this.isWhen ? "when" : "where") + "==>" + this.invokedRelationAnalysis.getRule().getName();
    }
}

