/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.launching;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.QVTcCompilerChain;
import org.eclipse.qvtd.debug.QVTiDebugPlugin;
import org.eclipse.qvtd.debug.core.QVTiDebugCore;
import org.eclipse.qvtd.debug.evaluator.BasicQVTcExecutor;
import org.eclipse.qvtd.debug.launching.QVTcLaunchConstants;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConfigurationDelegate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;

public class QVTcLaunchConfigurationDelegate
extends QVTiLaunchConfigurationDelegate
implements QVTcLaunchConstants {
    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String projectName = configuration.getAttribute("project", "");
        if (projectName == null) {
            throw QVTiDebugPlugin.newCoreExceptionError("No default project", null);
        }
        String txName = configuration.getAttribute("tx", null);
        if (txName == null) {
            throw QVTiDebugPlugin.newCoreExceptionError("No transformation to compile", null);
        }
        URI txURI = URI.createURI((String)txName);
        String outputName = configuration.getAttribute("direction", null);
        if (outputName == null) {
            throw QVTiDebugPlugin.newCoreExceptionError("No output direction for '" + txURI + "'", null);
        }
        Boolean interpreted = configuration.getAttribute("interpreted", true);
        QVTimperative qvt = QVTimperative.newInstance((ProjectManager)BasicProjectManager.CLASS_PATH, null);
        QVTiEnvironmentFactory environmentFactory = qvt.getEnvironmentFactory();
        QVTcCompilerChain compilerChain = new QVTcCompilerChain(environmentFactory, txURI, null);
        compilerChain.setOption("default", CompilerChain.SAVE_OPTIONS_KEY, (Object)XMIUtil.createSaveOptions());
        Map intermediatesMap = configuration.getAttribute("intermediates", EMPTY_MAP);
        String genmodelAttribute = configuration.getAttribute("genmodel", "");
        compilerChain.setOption("QVTu", CompilerChain.URI_KEY, (Object)URI.createURI((String)((String)intermediatesMap.get("QVTu")), (boolean)true));
        compilerChain.setOption("QVTm", CompilerChain.URI_KEY, (Object)URI.createURI((String)((String)intermediatesMap.get("QVTm")), (boolean)true));
        compilerChain.setOption("QVTp", CompilerChain.URI_KEY, (Object)URI.createURI((String)((String)intermediatesMap.get("QVTp")), (boolean)true));
        compilerChain.setOption("QVTs", CompilerChain.URI_KEY, (Object)URI.createURI((String)((String)intermediatesMap.get("QVTs")), (boolean)true));
        compilerChain.setOption("QVTi", CompilerChain.URI_KEY, (Object)URI.createURI((String)((String)intermediatesMap.get("QVTi")), (boolean)true));
        compilerChain.setOption("GenModel", CompilerChain.URI_KEY, (Object)URI.createURI((String)genmodelAttribute, (boolean)true));
        HashMap<@NonNull String, @Nullable String> genModelOptions = new HashMap<String, String>();
        genModelOptions.put("genModelBasePrefix", projectName);
        compilerChain.setOption("GenModel", CompilerChain.GENMODEL_OPTIONS_KEY, genModelOptions);
        try {
            if (interpreted.booleanValue()) {
                compilerChain.setOption("Java", CompilerChain.URI_KEY, null);
                compilerChain.setOption("Class", CompilerChain.URI_KEY, null);
                compilerChain.compile(outputName);
            } else {
                compilerChain.setOption("Java", CompilerChain.URI_KEY, (Object)URI.createURI((String)((String)intermediatesMap.get("Java")), (boolean)true));
                compilerChain.setOption("Class", CompilerChain.URI_KEY, (Object)URI.createURI((String)((String)intermediatesMap.get("Class")), (boolean)true));
                compilerChain.build(outputName, new String[]{genmodelAttribute});
            }
        }
        catch (Exception e) {
            throw QVTiDebugPlugin.newCoreExceptionError("Failed to compile transformation '" + txURI + "'", e);
        }
        return super.buildForLaunch(configuration, mode, monitor);
    }

    @Override
    protected @NonNull QVTiExecutor createExecutor(@NonNull QVTiEnvironmentFactory envFactory, @NonNull Transformation transformation) {
        return new BasicQVTcExecutor(envFactory, transformation);
    }

    @Override
    protected @NonNull QVTiDebugCore getDebugCore() {
        return QVTiDebugCore.INSTANCE;
    }

    @Override
    protected @NonNull URI getTransformationURI(ILaunchConfiguration configuration) throws CoreException {
        Map intermediatesMap = configuration.getAttribute("intermediates", EMPTY_MAP);
        String qvtiName = (String)intermediatesMap.get("QVTi");
        return URI.createURI((String)qvtiName, (boolean)true);
    }
}

