/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.palette.dialog;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PaletteUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPalettePreferences;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeSetConfigurationRegistry;
import org.eclipse.papyrus.toolsmiths.palette.Messages;
import org.eclipse.papyrus.toolsmiths.palette.PaletteConstants;
import org.eclipse.papyrus.toolsmiths.palette.dialog.AbstractPaletteConfigurationWizard;
import org.eclipse.papyrus.toolsmiths.palette.dialog.PaletteConfigurationContentPage;
import org.eclipse.papyrus.toolsmiths.palette.dialog.PaletteConfigurationInformationPage;
import org.eclipse.papyrus.toolsmiths.palette.utils.PaletteUtils;
import org.eclipse.ui.IEditorPart;

public class PaletteConfigurationWizard
extends AbstractPaletteConfigurationWizard {
    protected WizardPage contentPage;
    protected WizardPage infoPage;

    public PaletteConfigurationWizard(IEditorPart part, PapyrusPaletteService.ProviderDescriptor descriptor) {
        super(part, descriptor);
    }

    public PaletteConfigurationWizard(IEditorPart part) {
        this(part, null);
    }

    public void addPages() {
        super.addPages();
        this.infoPage = this.createPaletteInformationPage();
        this.contentPage = this.createPaletteContentPage();
        this.addPage((IWizardPage)this.infoPage);
        this.addPage((IWizardPage)this.contentPage);
    }

    protected WizardPage createPaletteContentPage() {
        PaletteConfigurationContentPage page = new PaletteConfigurationContentPage(this.editorPart, this.editingDomain);
        page.setTitle(Messages.PaletteConfigurationWizard_NewPaletteContentPageWizard_Title);
        page.setDescription(Messages.PaletteConfigurationWizard_NewPaletteContentPageWizard_Description);
        page.setPriority(this.priority);
        return page;
    }

    protected WizardPage createPaletteInformationPage() {
        PaletteConfigurationInformationPage page = new PaletteConfigurationInformationPage("", (PaletteConfiguration)this.paletteResource.getContents().get(0));
        if (PaletteConstants.PaletteModelContextEnum.New.equals((Object)this.paletteContext)) {
            page.setTitle(Messages.PaletteConfigurationWizard_NewPaletteInfoPageWizard_Title);
        } else {
            page.setTitle(Messages.PaletteConfigurationWizard_EditionPaletteInfoPageWizard_Tilte);
        }
        page.setDescription(Messages.PaletteConfigurationWizard_PaletteInfoPageWizard_Description);
        return page;
    }

    @Override
    protected void deployModels() {
        this.deployElementTypesModels();
        this.deployPaletteModel();
        PaletteUtil.getAvailableEntriesSet((IEditorPart)this.editorPart, (ProviderPriority)this.priority);
    }

    protected void deployPaletteModel() {
        PaletteConfiguration paletteModel = (PaletteConfiguration)this.paletteResource.getContents().get(0);
        String paletteId = paletteModel.getId();
        switch (this.paletteContext) {
            case New: {
                PapyrusPalettePreferences.addLocalExtendedPalette((String)paletteId, (String)paletteId, (ProviderPriority)this.priority, (String)PaletteUtils.getEditorIdValue(this.editorPart), new HashSet(paletteModel.getRequiredProfiles()));
                break;
            }
            case Local: {
                PapyrusPalettePreferences.deleteLocalExtendedPalette((String)this.descriptor.getContributionID());
                PapyrusPalettePreferences.addLocalExtendedPalette((String)paletteId, (String)paletteId, (ProviderPriority)this.priority, (String)PaletteUtils.getEditorIdValue(this.editorPart), new HashSet(paletteModel.getRequiredProfiles()));
                break;
            }
            case Plugin: {
                String path = PapyrusPalettePreferences.getPaletteRedefinition((String)this.descriptor.getContributionID());
                if (path == null) break;
                PapyrusPalettePreferences.registerLocalRedefinition((String)this.descriptor.getContributionID(), (String)path);
                break;
            }
            case Workspace: {
                String pathWS = this.paletteResource.getURI().toPlatformString(false);
                if (this.descriptor != null && !paletteId.equals(this.descriptor.getContributionID())) {
                    PapyrusPalettePreferences.deleteWorkspaceExtendedPalette((String)this.descriptor.getContributionID());
                }
                PapyrusPalettePreferences.addWorkspaceExtendedPalette((String)paletteId, (String)paletteId, (String)pathWS, (ProviderPriority)this.priority, (String)PaletteUtils.getEditorIdValue(this.editorPart), new HashSet(paletteModel.getRequiredProfiles()));
                break;
            }
        }
        if (this.editorPart instanceof DiagramEditorWithFlyOutPalette) {
            PapyrusPalettePreferences.changePaletteVisibility((String)paletteId, (IEditorPart)this.editorPart, (boolean)false);
            PapyrusPalettePreferences.changePaletteVisibility((String)paletteId, (IEditorPart)this.editorPart, (boolean)true);
        }
    }

    protected void deployElementTypesModels() {
        if (!this.elementTypeSemResource.getContents().isEmpty() && !this.elementTypeUIResource.getContents().isEmpty()) {
            ElementTypeSetConfigurationRegistry.getInstance().unload(this.getClientContext(), ((ElementTypeSetConfiguration)this.elementTypeSemResource.getContents().get(0)).getIdentifier());
            ElementTypeSetConfigurationRegistry.getInstance().unload(this.getClientContext(), ((ElementTypeSetConfiguration)this.elementTypeUIResource.getContents().get(0)).getIdentifier());
            ElementTypeSetConfigurationRegistry.getInstance().loadElementTypeSetConfiguration(this.getClientContext(), (ElementTypeSetConfiguration)this.elementTypeSemResource.getContents().get(0));
            ElementTypeSetConfigurationRegistry.getInstance().loadElementTypeSetConfiguration(this.getClientContext(), (ElementTypeSetConfiguration)this.elementTypeUIResource.getContents().get(0));
        }
    }

    @Override
    protected void saveResources() {
        PaletteConfiguration paletteModel = (PaletteConfiguration)this.paletteResource.getContents().get(0);
        String paletteId = paletteModel.getId();
        if (PaletteConstants.PaletteModelContextEnum.Local.equals((Object)this.paletteContext) && !paletteId.equals(this.descriptor.getContributionID())) {
            newPalettePath = this.paletteResource.getURI().toFileString().replace(this.descriptor.getContributionID(), paletteId);
            this.paletteResource.setURI(URI.createFileURI((String)newPalettePath));
            String newElementTypeUIResourcePath = this.elementTypeUIResource.getURI().toFileString().replace(this.descriptor.getContributionID(), paletteId);
            this.elementTypeUIResource.setURI(URI.createFileURI((String)newElementTypeUIResourcePath));
            String newElementTypeSemResourcePath = this.elementTypeSemResource.getURI().toFileString().replace(this.descriptor.getContributionID(), paletteId);
            this.elementTypeSemResource.setURI(URI.createFileURI((String)newElementTypeSemResourcePath));
        } else if (PaletteConstants.PaletteModelContextEnum.New.equals((Object)this.paletteContext)) {
            this.clearStringBuilder();
            this.stringBuilder.append(paletteId);
            this.stringBuilder.append(".");
            this.stringBuilder.append(PaletteConstants.PALETTECONFIGURATION_EXTENSION);
            newPalettePath = this.paletteResource.getURI().toFileString().replace(this.paletteResource.getURI().lastSegment().replace("%20", " "), this.stringBuilder.toString());
            this.paletteResource.setURI(URI.createFileURI((String)newPalettePath));
            this.clearStringBuilder();
            this.stringBuilder.append(paletteId);
            this.stringBuilder.append("_UI");
            this.stringBuilder.append(".");
            this.stringBuilder.append(PaletteConstants.ELEMENTTYPE_EXTENSION);
            String newElementTypeUIResourcePath = this.elementTypeUIResource.getURI().toFileString().replace(this.elementTypeUIResource.getURI().lastSegment().replace("%20", " "), this.stringBuilder.toString());
            this.elementTypeUIResource.setURI(URI.createFileURI((String)newElementTypeUIResourcePath));
            this.clearStringBuilder();
            this.stringBuilder.append(paletteId);
            this.stringBuilder.append("_Semantic");
            this.stringBuilder.append(".");
            this.stringBuilder.append(PaletteConstants.ELEMENTTYPE_EXTENSION);
            String newElementTypeSemResourcePath = this.elementTypeSemResource.getURI().toFileString().replace(this.elementTypeSemResource.getURI().lastSegment().replace("%20", " "), this.stringBuilder.toString());
            this.elementTypeSemResource.setURI(URI.createFileURI((String)newElementTypeSemResourcePath));
        }
        try {
            this.paletteResource.save(PaletteUtils.saveOptions);
            if (!((ElementTypeSetConfiguration)this.elementTypeUIResource.getContents().get(0)).getElementTypeConfigurations().isEmpty()) {
                this.elementTypeUIResource.save(PaletteUtils.saveOptions);
                this.elementTypeSemResource.save(PaletteUtils.saveOptions);
            } else {
                ElementTypeSetConfigurationRegistry.getInstance().unload(this.getClientContext(), ((ElementTypeSetConfiguration)this.elementTypeSemResource.getContents().get(0)).getIdentifier());
                ElementTypeSetConfigurationRegistry.getInstance().unload(this.getClientContext(), ((ElementTypeSetConfiguration)this.elementTypeUIResource.getContents().get(0)).getIdentifier());
                this.elementTypeUIResource.delete(Collections.EMPTY_MAP);
                this.elementTypeSemResource.delete(Collections.EMPTY_MAP);
            }
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected String getClientContext() {
        return "org.eclipse.papyrus.infra.services.edit.TypeContext";
    }
}

