/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.index;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexListener;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexProvider;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndex;
import org.eclipse.papyrus.uml.profile.Activator;

public class ProfileWorkspaceModelIndex {
    private WorkspaceModelIndex<String> index;
    private static final ProfileWorkspaceModelIndex INSTANCE = new ProfileWorkspaceModelIndex();
    String[] profileExtension = new String[]{"profile.uml"};
    private Set<URI> workspaceProfileURIs = new HashSet<URI>();

    private ProfileWorkspaceModelIndex() {
        this.index = new WorkspaceModelIndex("PapyrusWorkspaceProfiles", "org.eclipse.uml2.uml", this.indexer());
    }

    protected WorkspaceModelIndex.PersistentIndexHandler<String> indexer() {
        return new WorkspaceModelIndex.PersistentIndexHandler<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String index(IFile file) {
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                Set<URI> set = ProfileWorkspaceModelIndex.this.workspaceProfileURIs;
                synchronized (set) {
                    ProfileWorkspaceModelIndex.this.workspaceProfileURIs.add(uri);
                }
                return uri.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unindex(IFile file) {
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                Set<URI> set = ProfileWorkspaceModelIndex.this.workspaceProfileURIs;
                synchronized (set) {
                    ProfileWorkspaceModelIndex.this.workspaceProfileURIs.remove(uri);
                }
            }

            public boolean shouldIndex(IFile file) {
                return file.getName().contains(".profile.uml");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean load(IFile file, String index) {
                URI uri = URI.createPlatformResourceURI((String)index, (boolean)true);
                Set<URI> set = ProfileWorkspaceModelIndex.this.workspaceProfileURIs;
                synchronized (set) {
                    ProfileWorkspaceModelIndex.this.workspaceProfileURIs.add(uri);
                }
                return true;
            }
        };
    }

    public static ProfileWorkspaceModelIndex getInstance() {
        return INSTANCE;
    }

    public Collection<URI> getWorkspaceProfilesURIs() {
        Collection<Object> result = new HashSet<URI>();
        try {
            result = (Collection)this.index.afterIndex(() -> new HashSet<URI>(this.workspaceProfileURIs)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
        return result;
    }

    public void dispose() {
        this.index.dispose();
    }

    public WorkspaceModelIndex<String> getIndex() {
        return this.index;
    }

    public void addListener(IWorkspaceModelIndexListener listener) {
        this.index.addListener(listener);
    }

    public void removeListener(IWorkspaceModelIndexListener listener) {
        this.index.removeListener(listener);
    }

    public static final class IndexProvider
    implements IWorkspaceModelIndexProvider {
        public WorkspaceModelIndex<?> get() {
            return ProfileWorkspaceModelIndex.INSTANCE.index;
        }
    }
}

