/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.example.uml.comment.editor.sharedresource.factory;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.example.text.instance.papyrustextinstance.PapyrusTextInstance;
import org.eclipse.papyrus.example.uml.comment.editor.sharedresource.Activator;
import org.eclipse.papyrus.example.uml.comment.editor.sharedresource.editor.PapyrusCommentEditor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.AbstractEditorFactory;
import org.eclipse.papyrus.infra.ui.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;

public class CommentEditorFactory
extends AbstractEditorFactory {
    public CommentEditorFactory() {
        super(PapyrusCommentEditor.class, "CommentEditorSharedResource");
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        return new TextEditorModel(pageIdentifier, this.getServiceRegistry());
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        if (pageIdentifier instanceof PapyrusTextInstance) {
            return ((PapyrusTextInstance)pageIdentifier).getType().equals(this.getExpectedType());
        }
        return false;
    }

    class TextEditorModel
    implements IEditorModel {
        private ServicesRegistry servicesRegistry;
        private IEditorPart editor;
        private PapyrusTextInstance rawModel;

        public TextEditorModel(Object pageIdentifier, ServicesRegistry servicesRegistry) {
            this.rawModel = (PapyrusTextInstance)pageIdentifier;
            this.servicesRegistry = servicesRegistry;
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            try {
                this.editor = new PapyrusCommentEditor(this.servicesRegistry, this.rawModel);
                return this.editor;
            }
            catch (Exception e) {
                throw new PartInitException("Can't create TextEditor", (Throwable)e);
            }
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = CommentEditorFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)this.servicesRegistry.getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }

        public Object getRawModel() {
            return this.rawModel;
        }

        public Image getTabIcon() {
            ImageDescriptor imageDescriptor = CommentEditorFactory.this.getEditorDescriptor().getIcon();
            if (imageDescriptor == null) {
                return null;
            }
            return imageDescriptor.createImage();
        }

        public String getTabTitle() {
            return this.rawModel.getName();
        }

        public void dispose() {
        }
    }
}

