/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListLiteral
extends Expression {
    private static final Expression[] NO_EXPRESSION = new Expression[0];
    private final Expression[] elements;

    public ListLiteral(Expression[] contents) {
        this.elements = contents != null && contents.length > 0 ? contents : NO_EXPRESSION;
    }

    public Expression[] getElements() {
        return this.elements;
    }

    public List<Expression> getElementsAsList() {
        return Arrays.asList(this.elements);
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Expression[] params;
        ArrayList<Object> col = new ArrayList<Object>();
        Expression[] expressionArray = params = this.getElements();
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Expression param = expressionArray[n2];
            col.add(param.evaluate(ctx));
            ++n2;
        }
        return col;
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type t = null;
        Expression[] expressionArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            Expression element = expressionArray[n2];
            Type exprType = element.analyze(ctx, issues);
            if (exprType == null) {
                return null;
            }
            if (t == null || exprType.isAssignableFrom(t)) {
                t = exprType;
            }
            ++n2;
        }
        return ctx.getListType(t);
    }

    @Override
    protected String toStringInternal() {
        return "{" + this.expressionsToString() + "}";
    }

    private String expressionsToString() {
        String r = "";
        int i = 0;
        while (i < this.elements.length) {
            r = String.valueOf(r) + this.elements[i].toString();
            if (i + 1 < this.elements.length) {
                r = String.valueOf(r) + ",";
            }
            ++i;
        }
        return r;
    }
}

