/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.functions;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.xtend.backend.common.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DuplicateAwareFunctionCollection {
    private final Collection<Function> _allFunctions = new HashSet<Function>();

    public Function register(Function f) {
        Function result = null;
        for (Function candidate : this._allFunctions) {
            if (!DuplicateAwareFunctionCollection.haveSameSignature(f, candidate)) continue;
            this._allFunctions.remove(candidate);
            result = candidate;
            break;
        }
        this._allFunctions.add(f);
        return result;
    }

    public boolean contains(Function f) {
        for (Function candidate : this._allFunctions) {
            if (!DuplicateAwareFunctionCollection.haveSameSignature(f, candidate)) continue;
            return true;
        }
        return false;
    }

    public Collection<Function> getFunctions() {
        return this._allFunctions;
    }

    public static boolean haveSameSignature(Function f1, Function f2) {
        if (f1.getGuard() != null || f2.getGuard() != null) {
            return false;
        }
        return f1.getParameterTypes().equals(f2.getParameterTypes());
    }
}

