/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.model.Action;
import org.osgi.framework.Bundle;

public class HenshinColorMode {
    public static final Map<String, HenshinColorMode> REGISTRY;
    private static HenshinColorMode DEFAULT;
    public static final String BG_RULE = "BG_RULE";
    public static final String BG_UNIT = "BG_UNIT";
    public static final String BG_INVOCATION = "BG_INVOCATION";
    public static final String FG_RULE = "FG_RULE";
    public static final String FG_UNIT = "FG_UNIT";
    public static final String FG_INVOCATION = "FG_INVOCATION";
    public static final String BG_ACTION_PRESERVE = "BG_ACTION_PRESERVE";
    public static final String BG_ACTION_CREATE = "BG_ACTION_CREATE";
    public static final String BG_ACTION_DELETE = "BG_ACTION_DELETE";
    public static final String BG_ACTION_FORBID = "BG_ACTION_FORBID";
    public static final String BG_ACTION_REQUIRE = "BG_ACTION_REQUIRE";
    public static final String FG_ACTION_PRESERVE = "FG_ACTION_PRESERVE";
    public static final String FG_ACTION_CREATE = "FG_ACTION_CREATE";
    public static final String FG_ACTION_DELETE = "FG_ACTION_DELETE";
    public static final String FG_ACTION_FORBID = "FG_ACTION_FORBID";
    public static final String FG_ACTION_REQUIRE = "FG_ACTION_REQUIRE";
    private final Properties properties;
    private final String name;
    private final boolean useGradients;
    private final Map<String, Color> colors;

    static {
        String[] modes;
        REGISTRY = new LinkedHashMap<String, HenshinColorMode>(){
            private static final long serialVersionUID = 1L;

            @Override
            public HenshinColorMode get(Object v) {
                return (HenshinColorMode)super.get(String.valueOf(v).toLowerCase());
            }

            @Override
            public HenshinColorMode put(String v, HenshinColorMode mode) {
                return super.put(String.valueOf(v).toLowerCase(), mode);
            }
        };
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.henshin.edit");
        String[] stringArray = modes = new String[]{"default", "bw", "classic", "dark"};
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            String mode = stringArray[n2];
            try {
                InputStream in = FileLocator.openStream((Bundle)bundle, (IPath)new Path("colorModes/" + mode + ".properties"), (boolean)false);
                Properties properties = new Properties();
                properties.load(in);
                HenshinColorMode theMode = new HenshinColorMode(properties);
                REGISTRY.put(theMode.getName(), theMode);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++n2;
        }
    }

    public static HenshinColorMode getDefaultColorMode() {
        if (DEFAULT == null && (DEFAULT = REGISTRY.get("default")) == null && !REGISTRY.isEmpty()) {
            DEFAULT = REGISTRY.get(0);
        }
        return DEFAULT;
    }

    public HenshinColorMode(Properties properties) {
        this.properties = properties;
        this.colors = new HashMap<String, Color>();
        this.name = properties.getProperty("colorModeName");
        this.useGradients = Boolean.parseBoolean(properties.getProperty("useGradients"));
    }

    public Color getColor(String type) {
        Color color = this.colors.get(type);
        if (color != null) {
            return color;
        }
        String value = this.properties.getProperty(type);
        if (value == null) {
            return null;
        }
        String[] vals = value.split(",");
        if (vals.length != 3) {
            return null;
        }
        try {
            int red = Integer.parseInt(vals[0]);
            int green = Integer.parseInt(vals[1]);
            int blue = Integer.parseInt(vals[2]);
            color = new Color(red, green, blue);
            this.colors.put(type, color);
            return color;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Color getActionColor(Action action, boolean foreground) {
        if (action == null) {
            return null;
        }
        return this.getColor(HenshinColorMode.getActionColorKey(action, foreground));
    }

    public static String getActionColorKey(Action action, boolean foreground) {
        if (action == null) {
            return null;
        }
        return String.valueOf(foreground ? "FG_" : "BG_") + "ACTION_" + action.getType().toString().toUpperCase();
    }

    public String getName() {
        return this.name;
    }

    public boolean useGradients() {
        return this.useGradients;
    }

    public static class Color {
        public final int red;
        public final int green;
        public final int blue;

        public Color(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public int hashCode() {
            return this.red + this.green + this.blue;
        }

        public boolean equals(Object o) {
            if (o instanceof Color) {
                Color c = (Color)o;
                return c.red == this.red && c.green == this.green && c.blue == this.blue;
            }
            return false;
        }

        public URI toURI() {
            return URI.createURI((String)("color://rgb/" + this.red + "/" + this.green + "/" + this.blue));
        }
    }
}

