/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.Action;
import org.eclipse.emf.henshin.model.actions.ActionType;
import org.eclipse.emf.henshin.model.actions.internal.ActionACUtil;
import org.eclipse.emf.henshin.model.actions.internal.ActionHelper;
import org.eclipse.emf.henshin.model.actions.internal.MapEditor;
import org.eclipse.emf.henshin.model.actions.internal.MappingMapEditor;
import org.eclipse.emf.henshin.model.util.HenshinACUtil;
import org.eclipse.emf.henshin.model.util.HenshinMultiRuleUtil;

public abstract class GenericActionHelper<E extends EObject, C extends EObject>
implements ActionHelper<E, C> {
    @Override
    public Action getAction(E element) {
        Graph graph = this.getGraph(element);
        if (graph == null) {
            return null;
        }
        Rule rule = graph.getContainerRule();
        if (rule == null) {
            return null;
        }
        Rule kernel = rule.getKernelRule();
        boolean isAmalgamated = this.isAmalgamated(element);
        String[] amalgamationParams = this.getAmalgamationParameters(element, rule);
        if (kernel != null && !isAmalgamated) {
            return null;
        }
        if (graph == rule.getLhs()) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            EObject image = (EObject)editor.getOpposite(element);
            if (image != null) {
                return new Action(ActionType.PRESERVE, isAmalgamated, amalgamationParams);
            }
            return new Action(ActionType.DELETE, isAmalgamated, amalgamationParams);
        }
        if (graph == rule.getRhs()) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            EObject origin = (EObject)editor.getOpposite(element);
            if (origin == null) {
                return new Action(ActionType.CREATE, isAmalgamated, amalgamationParams);
            }
        } else if (graph.eContainer() instanceof NestedCondition) {
            MapEditor<E> editor;
            EObject origin;
            NestedCondition nc = (NestedCondition)graph.eContainer();
            ActionType type = null;
            if (HenshinACUtil.isAC(nc, true)) {
                type = ActionType.REQUIRE;
            } else if (HenshinACUtil.isAC(nc, false)) {
                type = ActionType.FORBID;
            }
            if (type != null && (origin = (EObject)(editor = this.getMapEditor(graph)).getOpposite(element)) == null) {
                if ("default".equals(graph.getName())) {
                    return new Action(type, new String[0]);
                }
                return new Action(type, graph.getName());
            }
        }
        return null;
    }

    @Override
    public void setAction(E element, Action action) {
        Rule kernelRule;
        Rule newMulti;
        MappingMapEditor mappingEditor;
        NestedCondition ac;
        Action current = this.getAction(element);
        if (current == null) {
            throw new IllegalArgumentException();
        }
        if (action.equals(current)) {
            return;
        }
        Graph graph = this.getGraph(element);
        Rule rule = graph.getContainerRule();
        if (current.getType() == ActionType.PRESERVE) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            EObject image = (EObject)editor.getOpposite(element);
            if (action.getType() == ActionType.DELETE) {
                editor.remove(image);
            } else if (action.getType() == ActionType.CREATE) {
                editor.replace(image);
            } else if (action.getType() == ActionType.REQUIRE || action.getType() == ActionType.FORBID) {
                editor.remove(image);
                NestedCondition ac2 = ActionACUtil.getOrCreateAC(action, rule);
                editor = this.getMapEditor(ac2.getConclusion());
                editor.move(element);
            }
        } else if (current.getType() == ActionType.CREATE) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            if (action.getType() != ActionType.CREATE) {
                editor.move(element);
            }
            if (action.getType() == ActionType.PRESERVE) {
                editor.copy(element);
            } else if (action.getType() == ActionType.REQUIRE || action.getType() == ActionType.FORBID) {
                ac = ActionACUtil.getOrCreateAC(action, rule);
                editor = this.getMapEditor(ac.getConclusion());
                editor.move(element);
            }
        } else if (current.getType() == ActionType.DELETE) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            if (action.getType() == ActionType.PRESERVE) {
                editor.copy(element);
            } else if (action.getType() == ActionType.CREATE) {
                editor.move(element);
            } else if (action.getType() == ActionType.REQUIRE || action.getType() == ActionType.FORBID) {
                ac = ActionACUtil.getOrCreateAC(action, rule);
                editor = this.getMapEditor(ac.getConclusion());
                editor.move(element);
            }
        } else if (current.getType() == ActionType.REQUIRE || current.getType() == ActionType.FORBID) {
            ac = (NestedCondition)graph.eContainer();
            MapEditor<E> editor = this.getMapEditor(ac.getConclusion());
            editor.move(element);
            if (action.getType() == ActionType.PRESERVE) {
                editor = this.getMapEditor(rule.getRhs());
                editor.copy(element);
            } else if (action.getType() == ActionType.CREATE) {
                editor = this.getMapEditor(rule.getRhs());
                editor.move(element);
            } else if (action.getType() == ActionType.REQUIRE || action.getType() == ActionType.FORBID) {
                NestedCondition newAc = ActionACUtil.getOrCreateAC(action, rule);
                editor = this.getMapEditor(newAc.getConclusion());
                editor.move(element);
            }
            if (HenshinACUtil.isTrivialAC(ac)) {
                HenshinACUtil.removeAC(rule, ac);
            }
        }
        if (current.isAmalgamated() != action.isAmalgamated()) {
            Rule kernel;
            Rule multi;
            if (action.isAmalgamated()) {
                multi = this.getOrCreateMultiRule(rule, action.getArguments());
                kernel = rule;
            } else {
                kernel = rule.getKernelRule();
                multi = rule;
            }
            this.sanitizeMultiRule(multi);
            if (action.getType() == ActionType.CREATE) {
                this.getMapEditor(kernel.getRhs(), multi.getRhs(), (List<Mapping>)multi.getMultiMappings()).move(element);
            } else if (action.getType() == ActionType.DELETE) {
                this.getMapEditor(kernel.getLhs(), multi.getLhs(), (List<Mapping>)multi.getMultiMappings()).move(element);
            } else if (action.getType() == ActionType.PRESERVE) {
                mappingEditor = new MappingMapEditor(kernel, multi, (List<Mapping>)multi.getMultiMappings());
                mappingEditor.moveMappedElement(element);
            }
            HenshinMultiRuleUtil.removeTrivialMultiRules(kernel);
        }
        if (current.isAmalgamated() && action.isAmalgamated() && (newMulti = this.getOrCreateMultiRule(kernelRule = rule.getKernelRule(), action.getArguments())) != rule) {
            this.sanitizeMultiRule(newMulti);
            if (action.getType() == ActionType.CREATE) {
                this.getMapEditor(rule.getRhs(), newMulti.getRhs(), null).move(element);
            } else if (action.getType() == ActionType.DELETE) {
                this.getMapEditor(rule.getLhs(), newMulti.getLhs(), null).move(element);
            } else if (action.getType() == ActionType.PRESERVE) {
                mappingEditor = new MappingMapEditor(rule, newMulti, null);
                mappingEditor.moveMappedElement(element);
            }
            HenshinMultiRuleUtil.removeTrivialMultiRules(kernelRule);
        }
    }

    private void sanitizeMultiRule(Rule multi) {
        Rule kernelRule = multi.getKernelRule();
        MappingMapEditor mappingEditor = new MappingMapEditor(kernelRule, multi, (List<Mapping>)multi.getMultiMappings());
        mappingEditor.ensureCompleteness();
    }

    protected Graph getGraph(E e) {
        EObject current = e.eContainer();
        while (current != null) {
            if (current instanceof Graph) {
                return (Graph)current;
            }
            current = current.eContainer();
        }
        return null;
    }

    protected abstract MapEditor<E> getMapEditor(Graph var1);

    protected abstract MapEditor<E> getMapEditor(Graph var1, Graph var2, List<Mapping> var3);

    protected List<E> filterElementsByAction(List<E> elements, Action action) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject element : elements) {
            Action current = this.getAction((E)element);
            if (current == null || action != null && !action.equals(current)) continue;
            result.add(element);
        }
        return result;
    }

    private boolean isAmalgamated(E element) {
        GraphElement elem;
        if (element instanceof Attribute) {
            elem = ((Attribute)element).getNode();
        } else if (element instanceof GraphElement) {
            elem = (GraphElement)element;
        } else {
            return false;
        }
        Graph graph = elem.getGraph();
        if (elem.getGraph() == null) {
            return false;
        }
        Rule rule = graph.getContainerRule();
        if (rule == null || rule.getKernelRule() == null) {
            return false;
        }
        return rule.getOriginInKernelRule(elem) == null;
    }

    private String[] getAmalgamationParameters(E element, Rule multiRule) {
        if (!this.isAmalgamated(element)) {
            return new String[0];
        }
        String name = multiRule.getName();
        if (name == null || name.length() == 0) {
            return new String[0];
        }
        return new String[]{name};
    }

    private Rule getOrCreateMultiRule(Rule kernel, String[] actionArguments) {
        Rule multiRule;
        String name = null;
        if (actionArguments.length > 0 && actionArguments[0].trim().length() > 0) {
            name = actionArguments[0].trim();
        }
        if ((multiRule = kernel.getMultiRuleByName(name)) == null) {
            multiRule = HenshinFactory.eINSTANCE.createRule();
            multiRule.setName(name);
            if (name == null) {
                kernel.getMultiRules().add(0, (Object)multiRule);
            } else {
                kernel.getMultiRules().add((Object)multiRule);
            }
        }
        return multiRule;
    }
}

