/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.tuples;

import java.util.ArrayList;
import org.eclipse.emf.henshin.statespace.tuples.Tuple;

public class TupleList
extends ArrayList<Tuple> {
    private static final long serialVersionUID = -3815199168758095254L;

    public TupleList() {
    }

    public TupleList(int initialCapacity) {
        super(initialCapacity);
    }

    public int width() {
        if (this.isEmpty()) {
            return -1;
        }
        return ((Tuple)this.get(0)).width();
    }

    public boolean startsWith(TupleList list) {
        if (this.width() != list.width() || this.size() > list.size()) {
            return false;
        }
        int size = list.size();
        int i = 0;
        while (i < size) {
            if (!((Tuple)this.get(i)).equals(list.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public TupleList getMinMax() {
        if (this.isEmpty()) {
            return null;
        }
        Tuple mins = (Tuple)((Tuple)this.get(0)).clone();
        Tuple maxs = (Tuple)((Tuple)this.get(0)).clone();
        int width = mins.width();
        for (Tuple t : this) {
            int i = 0;
            while (i < width) {
                if (mins.data[i] > t.data[i]) {
                    mins.data[i] = t.data[i];
                }
                if (maxs.data[i] < t.data[i]) {
                    maxs.data[i] = t.data[i];
                }
                ++i;
            }
        }
        TupleList minmax = new TupleList();
        minmax.add(mins);
        minmax.add(maxs);
        return minmax;
    }

    public void simplifyColumns() {
        if (this.isEmpty()) {
            return;
        }
        int width = this.width();
        int size = this.size();
        int j = 0;
        while (j < width) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            int i = 0;
            while (i < size) {
                Integer val = ((Tuple)this.get((int)i)).data[j];
                if (!values.contains(val)) {
                    values.add(val);
                }
                ++i;
            }
            i = 0;
            while (i < size) {
                Tuple tuple = (Tuple)this.get(i);
                tuple.data[j] = values.indexOf(tuple.data[j]);
                ++i;
            }
            ++j;
        }
    }

    public void revertAll() {
        for (Tuple tuple : this) {
            tuple.revert();
        }
    }

    public int removeConstantColumns() {
        if (this.isEmpty()) {
            return 0;
        }
        Tuple first = (Tuple)this.get(0);
        int width = this.width();
        int size = this.size();
        boolean[] remove = new boolean[width];
        int removeCount = width;
        int j = 0;
        while (j < width) {
            remove[j] = true;
            int d = first.data[j];
            int i = 1;
            while (i < size) {
                if (((Tuple)this.get((int)i)).data[j] != d) {
                    remove[j] = false;
                    --removeCount;
                    break;
                }
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < width) {
            if (!remove[j]) {
                int k = j + 1;
                while (k < width) {
                    boolean doRemove = true;
                    int d = first.data[j] - first.data[k];
                    int i = 1;
                    while (i < size) {
                        int e = ((Tuple)this.get((int)i)).data[j] - ((Tuple)this.get((int)i)).data[k];
                        if (e != d) {
                            doRemove = false;
                            break;
                        }
                        ++i;
                    }
                    if (doRemove) {
                        remove[j] = true;
                        ++removeCount;
                        break;
                    }
                    ++k;
                }
            }
            ++j;
        }
        if (removeCount > 0) {
            int newSize = width - removeCount;
            int i = 0;
            while (i < size) {
                Tuple t = (Tuple)this.get(i);
                int[] newData = new int[newSize];
                int k = 0;
                int j2 = 0;
                while (j2 < width) {
                    if (!remove[j2]) {
                        newData[k++] = t.data[j2];
                    }
                    ++j2;
                }
                t.data = newData;
                ++i;
            }
        }
        return removeCount;
    }

    @Override
    public String toString() {
        String s = "";
        for (Tuple t : this) {
            s = String.valueOf(s) + t + "\n";
        }
        return s;
    }

    @Override
    public Object clone() {
        TupleList clone = new TupleList(this.size());
        for (Tuple tuple : this) {
            clone.add((Tuple)tuple.clone());
        }
        return clone;
    }
}

