/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.hashcodes;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.statespace.EqualityHelper;

class LocalHashCodeHelper {
    LocalHashCodeHelper() {
    }

    static int hashCode(EObject object, int objectId, EqualityHelper equalityHelper) {
        EClass eclass = object.eClass();
        String uri = eclass.getEPackage().getNsURI();
        int hashCode = uri != null ? uri.hashCode() : 1;
        hashCode = hashCode * 23 + eclass.getClassifierID();
        hashCode = hashCode * 29 + objectId;
        for (EStructuralFeature feature : eclass.getEAllStructuralFeatures()) {
            int value = 0;
            if (feature.isMany()) {
                EList list = (EList)object.eGet(feature);
                if (feature instanceof EReference) {
                    value = list.size();
                } else if (feature instanceof EAttribute) {
                    value = equalityHelper.getIgnoredAttributes().contains((Object)feature) ? 0 : list.hashCode();
                }
            } else {
                Object single = object.eGet(feature);
                if (single == null) {
                    value = 0;
                } else if (feature instanceof EReference) {
                    value = 1;
                } else if (feature instanceof EAttribute) {
                    value = equalityHelper.getIgnoredAttributes().contains((Object)feature) ? 0 : single.hashCode();
                }
            }
            hashCode = hashCode * 31 + value;
        }
        return hashCode;
    }
}

