/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.framework.junit.internal;

import java.lang.reflect.Constructor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.EcoreWeightProvider;
import org.eclipse.emf.compare.match.eobject.EditionDistance;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.framework.NotifierTuple;
import org.eclipse.emf.compare.tests.framework.junit.annotation.DiffTest;
import org.eclipse.emf.compare.tests.framework.junit.internal.ResultStatement;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class DiffStatement
extends Statement {
    private final Object testObject;
    private final ResultStatement<NotifierTuple> tupleStatement;
    private final FrameworkMethod test;

    public DiffStatement(Object testObject, ResultStatement<NotifierTuple> tupleStatement, FrameworkMethod test) {
        this.testObject = testObject;
        this.tupleStatement = tupleStatement;
        this.test = test;
    }

    public void evaluate() throws Throwable {
        this.tupleStatement.evaluate();
        NotifierTuple tuple = this.tupleStatement.getResult();
        DiffTest annotation = (DiffTest)this.test.getAnnotation(DiffTest.class);
        IComparisonScope scope = DiffStatement.createComparisonScope(tuple, annotation);
        IMatchEngine matchEngine = DiffStatement.createMatchEngine(annotation);
        IDiffEngine diffEngine = DiffStatement.createDiffEngine(annotation);
        Comparison comparison = matchEngine.match(scope, (Monitor)new BasicMonitor());
        diffEngine.diff(comparison, (Monitor)new BasicMonitor());
        this.test.invokeExplosively(this.testObject, new Object[]{scope, comparison});
    }

    private static IMatchEngine createMatchEngine(DiffTest annotation) {
        Class<? extends IMatchEngine> engineClass = annotation.matchEngine();
        IMatchEngine engine = null;
        try {
            engine = engineClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
        if (engine == null) {
            ProximityEObjectMatcher contentMatcher = new ProximityEObjectMatcher((ProximityEObjectMatcher.DistanceFunction)EditionDistance.builder().weightProvider((WeightProvider)new EcoreWeightProvider()).build());
            IdentifierEObjectMatcher matcher = new IdentifierEObjectMatcher((IEObjectMatcher)contentMatcher);
            engine = new DefaultMatchEngine((IEObjectMatcher)matcher, (IComparisonFactory)new DefaultComparisonFactory((IEqualityHelperFactory)new DefaultEqualityHelperFactory()));
        }
        return engine;
    }

    private static IDiffEngine createDiffEngine(DiffTest annotation) {
        Class<? extends IDiffEngine> engineClass = annotation.diffEngine();
        IDiffEngine engine = null;
        try {
            engine = engineClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
        if (engine == null) {
            engine = new DefaultDiffEngine((IDiffProcessor)new DiffBuilder());
        }
        return engine;
    }

    private static IComparisonScope createComparisonScope(NotifierTuple tuple, DiffTest annotation) {
        Class<? extends IComparisonScope> scopeClass = annotation.scope();
        DefaultComparisonScope scope = null;
        try {
            Constructor<? extends IComparisonScope> constructor = scopeClass.getConstructor(Notifier.class, Notifier.class, Notifier.class);
            scope = constructor.newInstance(tuple.getLeft(), tuple.getRight(), tuple.getOrigin());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (scope == null) {
            scope = new DefaultComparisonScope(tuple.getLeft(), tuple.getRight(), tuple.getOrigin());
        }
        return scope;
    }
}

