/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.edit;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.provider.CompareItemProviderAdapterFactory;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.edit.data.ResourceScopeProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.junit.Before;

public class AbstractTestCompareItemProviderAdapter {
    protected CompareItemProviderAdapterFactory compareItemProviderAdapterFactory;

    @Before
    public void before() throws IOException {
        this.compareItemProviderAdapterFactory = new CompareItemProviderAdapterFactorySpec();
    }

    protected static Comparison getComparison(ResourceScopeProvider scopeProvider) throws IOException {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)scopeProvider.getLeft(), (Notifier)scopeProvider.getRight(), (Notifier)scopeProvider.getOrigin());
        return EMFCompare.builder().build().compare((IComparisonScope)scope);
    }

    protected Match getMatchWithFeatureValue(Collection<?> c, String featureName, Object value) {
        Iterable matches = Iterables.filter(c, Match.class);
        Predicate<Match> predicate = this.hasFeatureValue(featureName, value);
        return (Match)Iterables.find((Iterable)matches, predicate);
    }

    protected ReferenceChange getReferenceChangeWithFeatureValue(Collection<?> c, final String featureName, final Object value) {
        Iterable matches = Iterables.filter(c, ReferenceChange.class);
        Predicate<ReferenceChange> predicate = new Predicate<ReferenceChange>(){

            public boolean apply(ReferenceChange referenceChange) {
                EObject referenceChangeValue = referenceChange.getValue();
                if (referenceChangeValue != null) {
                    return Objects.equal((Object)AbstractTestCompareItemProviderAdapter.this.eGet(referenceChangeValue, featureName), (Object)value);
                }
                return false;
            }
        };
        return (ReferenceChange)Iterables.find((Iterable)matches, (Predicate)predicate);
    }

    protected Predicate<Match> hasFeatureValue(final String featureName, final Object value) {
        Predicate<Match> predicate = new Predicate<Match>(){

            public boolean apply(Match match) {
                EObject left = match.getLeft();
                EObject right = match.getRight();
                EObject origin = match.getOrigin();
                boolean ret = left != null ? Objects.equal((Object)value, (Object)AbstractTestCompareItemProviderAdapter.this.eGet(left, featureName)) : (right != null ? Objects.equal((Object)value, (Object)AbstractTestCompareItemProviderAdapter.this.eGet(right, featureName)) : (origin != null ? Objects.equal((Object)value, (Object)AbstractTestCompareItemProviderAdapter.this.eGet(origin, featureName)) : false));
                return ret;
            }
        };
        return predicate;
    }

    protected Object eGet(EObject eObject, String featureName) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(featureName);
        return eObject.eGet(eStructuralFeature);
    }

    protected List<Notifier> eAllChildren(Notifier notifier) {
        ArrayList ret = Lists.newArrayList();
        ITreeItemContentProvider contentProvider = this.adaptAsITreeItemContentProvider(notifier);
        Iterable children = Iterables.filter((Iterable)contentProvider.getChildren((Object)notifier), Notifier.class);
        for (Notifier child : children) {
            ret.add(child);
            ret.addAll(this.eAllChildren(child));
        }
        return ret;
    }

    protected ITreeItemContentProvider adaptAsITreeItemContentProvider(Notifier notifier) {
        ITreeItemContentProvider contentProvider = (ITreeItemContentProvider)this.compareItemProviderAdapterFactory.adapt(notifier, ITreeItemContentProvider.class);
        return contentProvider;
    }
}

