/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.e4;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.emf.compare.ide.ui.e4.E4PendingUpdateAdapter;
import org.eclipse.emf.compare.ide.ui.internal.treecontentmanager.EMFCompareDeferredTreeContentManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.UIJob;

public class E4DeferredTreeContentManager
extends DeferredTreeContentManager
implements EMFCompareDeferredTreeContentManager {
    private final AbstractTreeViewer treeViewer;
    private ListenerList updateCompleteListenerList;

    public E4DeferredTreeContentManager(AbstractTreeViewer treeViewer) {
        super(treeViewer);
        this.treeViewer = treeViewer;
    }

    protected PendingUpdateAdapter createPendingUpdateAdapter() {
        return new E4PendingUpdateAdapter();
    }

    protected void addChildren(final Object parent, final Object[] children, IProgressMonitor monitor) {
        UIJob updateJob = new UIJob(Display.getDefault(), ProgressMessages.DeferredTreeContentManager_AddingChildren){

            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                if (E4DeferredTreeContentManager.this.treeViewer.getControl().isDisposed() || updateMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                E4DeferredTreeContentManager.this.treeViewer.add(parent, children);
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    protected void runClearPlaceholderJob(PendingUpdateAdapter placeholder) {
        final E4PendingUpdateAdapter e4Placeholder = (E4PendingUpdateAdapter)placeholder;
        if (e4Placeholder.isRemoved()) {
            return;
        }
        UIJob clearJob = new UIJob(Display.getDefault(), ProgressMessages.DeferredTreeContentManager_ClearJob){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!e4Placeholder.isRemoved()) {
                    Control control = E4DeferredTreeContentManager.this.treeViewer.getControl();
                    if (control.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    E4DeferredTreeContentManager.this.treeViewer.remove((Object)e4Placeholder);
                    e4Placeholder.setRemoved(true);
                }
                return Status.OK_STATUS;
            }
        };
        clearJob.setSystem(true);
        if (this.updateCompleteListenerList != null) {
            Object[] listeners = this.updateCompleteListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                clearJob.addJobChangeListener((IJobChangeListener)listeners[i]);
                ++i;
            }
        }
        clearJob.schedule();
    }

    public void addUpdateCompleteListener(IJobChangeListener listener) {
        if (listener == null && this.updateCompleteListenerList != null) {
            Object[] listeners = this.updateCompleteListenerList.getListeners();
            if (listeners.length == 1) {
                this.removeUpdateCompleteListener((IJobChangeListener)listeners[0]);
            }
        } else {
            if (this.updateCompleteListenerList == null) {
                this.updateCompleteListenerList = new ListenerList();
            }
            this.updateCompleteListenerList.add((Object)listener);
        }
    }

    public void removeUpdateCompleteListener(IJobChangeListener listener) {
        if (this.updateCompleteListenerList != null) {
            this.updateCompleteListenerList.remove((Object)listener);
        }
    }
}

