/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.match;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.MatchOfContainmentReferenceChangeAdapter;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.match.MatchOfContainmentReferenceChangeProcessor;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.match.data.MatchOfContainmentReferenceChangeAdapterTestData;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class MatchOfContainmentReferenceChangeAdapterTest {
    private static MatchOfContainmentReferenceChangeAdapterTestData inputData = new MatchOfContainmentReferenceChangeAdapterTestData();

    @Test
    public void test2wayAddNewStringTypedEReference() throws IOException {
        Resource leftResource = inputData.getLeft();
        Resource rightResource = inputData.getRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftResource, (Notifier)rightResource, null);
        EMFCompare.Builder comparisonBuilder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(comparisonBuilder);
        Comparison comparison = comparisonBuilder.build().compare((IComparisonScope)scope);
        new MatchOfContainmentReferenceChangeProcessor().execute(comparison);
        for (Match match : comparison.getMatches()) {
            Adapter adapter = EcoreUtil.getAdapter((List)match.eAdapters(), MatchOfContainmentReferenceChangeAdapter.class);
            Assert.assertNull((Object)adapter);
            for (Match subMatch : match.getAllSubmatches()) {
                adapter = EcoreUtil.getAdapter((List)subMatch.eAdapters(), MatchOfContainmentReferenceChangeAdapter.class);
                EObject left = subMatch.getLeft();
                if (left instanceof EStructuralFeature && ((EStructuralFeature)left).getName().equals("title")) {
                    Assert.assertNotNull((Object)adapter);
                    continue;
                }
                Assert.assertNull((Object)adapter);
            }
        }
    }
}

