/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diagram.internal.CompareDiagramConfiguration;
import org.eclipse.emf.compare.diagram.internal.CompareDiagramUIMessages;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.diagram.internal.factories.DiagramExtensionFactoryRegistry;
import org.eclipse.emf.compare.internal.postprocessor.factories.IChangeFactory;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;

public class CompareDiagramPostProcessor
implements IPostProcessor {
    private Set<IChangeFactory> diagramExtensionFactories;
    private CompareDiagramConfiguration configuration;

    public void setConfiguration(CompareDiagramConfiguration configuration) {
        this.configuration = configuration;
    }

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
        Map<Class<? extends Diff>, IChangeFactory> mapDiagramExtensionFactories = DiagramExtensionFactoryRegistry.createExtensionFactories(this.configuration);
        this.diagramExtensionFactories = new LinkedHashSet<IChangeFactory>(mapDiagramExtensionFactories.values());
        EList differences = comparison.getDifferences();
        int diffCount = differences.size();
        int i = 0;
        while (i < diffCount) {
            this.applyManagedTypes((Diff)differences.get(i));
            this.reportProgress(monitor, "CompareDiagramPostProcessor.monitor.applyManagedTypes", i + 1, diffCount);
            ++i;
        }
        differences = comparison.getDifferences();
        diffCount = differences.size();
        i = 0;
        while (i < diffCount) {
            Class classDiffElement;
            IChangeFactory diffFactory;
            Diff diff = (Diff)differences.get(i);
            if (diff instanceof DiagramDiff && (diffFactory = mapDiagramExtensionFactories.get(classDiffElement = diff.eClass().getInstanceClass())) != null) {
                diffFactory.fillRequiredDifferences(comparison, diff);
            }
            this.reportProgress(monitor, "CompareDiagramPostProcessor.monitor.fillRequiredDifferences", i + 1, diffCount);
            ++i;
        }
    }

    private void reportProgress(Monitor monitor, String msgKey, int currentDiffIndex, int diffCount) {
        if (currentDiffIndex % 100 == 1) {
            monitor.subTask(CompareDiagramUIMessages.getString(msgKey, currentDiffIndex, diffCount));
            if (monitor.isCanceled()) {
                throw new ComparisonCanceledException();
            }
        }
    }

    private void applyManagedTypes(Diff element) {
        for (IChangeFactory factory : this.diagramExtensionFactories) {
            if (!factory.handles(element)) continue;
            Diff extension = factory.create(element);
            Match match = factory.getParentMatch(element);
            match.getDifferences().add((Object)extension);
        }
    }
}

