/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.tests.framework.RuntimeTestRunner;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.Compare;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMergeOptionAware;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=RuntimeTestRunner.class)
public class CascadingFilterRefinementTest {
    private static final boolean MERGE_RIGHT_TO_LEFT = true;
    private static final Map<IMergeOptionAware, Object> CACHED_SUBDIFF_OPTIONS = Maps.newHashMap();
    private static final IMerger.Registry MERGER_REGISTRY = EMFCompareRCPPlugin.getDefault().getMergerRegistry();

    public void enableCascadingFilter() {
        this.setCascadingFilter(true);
    }

    public void disableCascadingFilter() {
        this.setCascadingFilter(false);
    }

    public void setCascadingFilter(boolean enabled) {
        for (IMergeOptionAware merger : Iterables.filter((Iterable)MERGER_REGISTRY.getMergers(null), IMergeOptionAware.class)) {
            Map mergeOptions = merger.getMergeOptions();
            Object previousValue = mergeOptions.get("subDiffAwareOption");
            CACHED_SUBDIFF_OPTIONS.put(merger, previousValue);
            mergeOptions.put("subDiffAwareOption", enabled);
        }
    }

    public void restoreCascadingFilter() {
        for (Map.Entry<IMergeOptionAware, Object> entry : CACHED_SUBDIFF_OPTIONS.entrySet()) {
            IMergeOptionAware merger = entry.getKey();
            merger.getMergeOptions().put("subDiffAwareOption", entry.getValue());
        }
    }

    @Compare(left="data/filter/cascading/left.uml", right="data/filter/cascading/right.uml", ancestor="data/filter/cascading/ancestor.uml")
    public void testRefinement_CascadingFilterEnabled(Comparison comparison) {
        try {
            EList differences = comparison.getDifferences();
            EList conflicts = comparison.getConflicts();
            Assert.assertTrue((boolean)Iterables.any((Iterable)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.REAL})));
            Assert.assertTrue((boolean)Iterables.all((Iterable)differences, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
            this.enableCascadingFilter();
            this.verifyRefinement((List<Diff>)differences, true);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    @Compare(left="data/filter/cascading/left.uml", right="data/filter/cascading/right.uml", ancestor="data/filter/cascading/ancestor.uml")
    public void testRefinement_CascadingFilterDisabled(Comparison comparison) {
        try {
            EList differences = comparison.getDifferences();
            EList conflicts = comparison.getConflicts();
            Assert.assertTrue((boolean)Iterables.any((Iterable)conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.REAL})));
            Assert.assertTrue((boolean)Iterables.all((Iterable)differences, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
            this.disableCascadingFilter();
            this.verifyRefinement((List<Diff>)differences, true);
        }
        finally {
            this.restoreCascadingFilter();
        }
    }

    public void verifyRefinement(List<Diff> differences, boolean mergeRightToLeft) {
        for (Diff diff : differences) {
            DiffRelationshipComputer computer = new DiffRelationshipComputer(MERGER_REGISTRY);
            Set resultingMerges = computer.getAllResultingMerges(diff, mergeRightToLeft);
            Assert.assertTrue((String)"Not all refined diffs are in resulting merges.", (boolean)resultingMerges.containsAll((Collection<?>)diff.getRefines()));
            Assert.assertTrue((String)"Not all refining diffs are in resulting merges.", (boolean)resultingMerges.containsAll((Collection<?>)diff.getRefinedBy()));
        }
    }
}

