/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.graph.IGraphView;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.compare.ide.ui.internal.logical.StreamAccessorStorage;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class ThreadedModelResolverGraphTest {
    private static String LEFT = "left";
    private static String RIGHT = "right";
    private static String SEP = File.separator;
    private static String URI_SEP = "/";
    private static String PLATFORM_RESOURCE = "platform:" + URI_SEP + "resource";

    private IGraphView<URI> initGraph(String projectName) throws IOException, CoreException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.compare.ide.ui.tests");
        URL entry = bundle.getEntry("src" + SEP + "org" + SEP + "eclipse" + SEP + "emf" + SEP + "compare" + SEP + "ide" + SEP + "ui" + SEP + "tests" + SEP + "structuremergeviewer" + SEP + "notloadedfragment" + SEP + "data" + SEP + projectName + SEP + ".project");
        URL fileURL = FileLocator.toFileURL((URL)entry);
        IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(fileURL.getPath()));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
        if (!project.exists()) {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        IFile leftFile = project.getFile((IPath)new Path("left" + SEP + "R1.ecore"));
        IFile rightFile = project.getFile((IPath)new Path("right" + SEP + "R1.ecore"));
        StorageTypedElement left = new StorageTypedElement((IStorage)leftFile, leftFile.getFullPath().toOSString());
        StorageTypedElement right = new StorageTypedElement((IStorage)rightFile, rightFile.getFullPath().toOSString());
        IFile leftStorage = PlatformElementUtil.findFile((ITypedElement)left);
        if (leftStorage == null) {
            leftStorage = StreamAccessorStorage.fromTypedElement((ITypedElement)left);
        }
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)leftStorage);
        Assert.assertTrue((boolean)(resolver instanceof ThreadedModelResolver));
        ComparisonScopeBuilder scopeBuilder = new ComparisonScopeBuilder(resolver, (IModelMinimizer)EMFCompareIDEUIPlugin.getDefault().getModelMinimizerRegistry().getCompoundMinimizer(), null);
        scopeBuilder.build((ITypedElement)left, (ITypedElement)right, null, (IProgressMonitor)new NullProgressMonitor());
        return ((ThreadedModelResolver)resolver).getGraphView();
    }

    @Test
    public void testCase0_GetParentData() throws IOException, CoreException {
        String projectName = "case0";
        IGraphView<URI> graph = this.initGraph(projectName);
        String leftPath = String.valueOf(projectName) + URI_SEP + LEFT + URI_SEP;
        URI parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + URI_SEP + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        String rightPath = String.valueOf(projectName) + URI_SEP + RIGHT + URI_SEP;
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
    }

    @Test
    public void testCase1_GetParentData() throws IOException, CoreException {
        String projectName = "case1";
        IGraphView<URI> graph = this.initGraph(projectName);
        String leftPath = String.valueOf(projectName) + URI_SEP + LEFT + URI_SEP;
        URI parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R2.ecore#_B"), (Object)parentData.toString());
        String rightPath = String.valueOf(projectName) + URI_SEP + RIGHT + URI_SEP;
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R2.ecore#_B"), (Object)parentData.toString());
    }

    @Test
    public void testCase2_GetParentData() throws IOException, CoreException {
        String projectName = "case2";
        IGraphView<URI> graph = this.initGraph(projectName);
        String leftPath = String.valueOf(projectName) + URI_SEP + LEFT + URI_SEP;
        URI parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R2.ecore#_B"), (Object)parentData.toString());
        String rightPath = String.valueOf(projectName) + URI_SEP + RIGHT + URI_SEP;
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R2.ecore#_B"), (Object)parentData.toString());
    }

    @Test
    public void testCase3_GetParentData() throws IOException, CoreException {
        String projectName = "case3";
        IGraphView<URI> graph = this.initGraph(projectName);
        String leftPath = String.valueOf(projectName) + URI_SEP + LEFT + URI_SEP;
        URI parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R2.ecore#_B"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R4.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R3.ecore#_D"), (Object)parentData.toString());
        String rightPath = String.valueOf(projectName) + URI_SEP + RIGHT + URI_SEP;
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R2.ecore#_B"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R4.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R3.ecore#_D"), (Object)parentData.toString());
    }

    @Test
    public void testCase4_GetParentData() throws IOException, CoreException {
        String projectName = "case4";
        IGraphView<URI> graph = this.initGraph(projectName);
        String leftPath = String.valueOf(projectName) + URI_SEP + LEFT + URI_SEP;
        URI parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        String rightPath = String.valueOf(projectName) + URI_SEP + RIGHT + URI_SEP;
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
    }

    @Test
    public void testCase5_GetParentData() throws IOException, CoreException {
        String projectName = "case5";
        IGraphView<URI> graph = this.initGraph(projectName);
        String leftPath = String.valueOf(projectName) + URI_SEP + LEFT + URI_SEP;
        URI parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R4.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R2.ecore#_B"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R5.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R3.ecore#_C"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R6.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R4.ecore#_D"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R7.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R5.ecore#_E"), (Object)parentData.toString());
        String rightPath = String.valueOf(projectName) + URI_SEP + RIGHT + URI_SEP;
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R4.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R2.ecore#_B"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R5.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R3.ecore#_C"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R6.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R4.ecore#_D"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R7.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R5.ecore#_E"), (Object)parentData.toString());
    }

    @Test
    public void testCase6_GetParentData() throws IOException, CoreException {
        String projectName = "case6";
        IGraphView<URI> graph = this.initGraph(projectName);
        String leftPath = String.valueOf(projectName) + URI_SEP + LEFT + URI_SEP;
        URI parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R4.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R2.ecore#_B"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R5.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R4.ecore#_D"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R6.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R4.ecore#_D"), (Object)parentData.toString());
        String rightPath = String.valueOf(projectName) + URI_SEP + RIGHT + URI_SEP;
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R4.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R2.ecore#_B"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R5.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R4.ecore#_D"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R6.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R4.ecore#_D"), (Object)parentData.toString());
    }

    @Test
    public void testCase7_GetParentData() throws IOException, CoreException {
        String projectName = "case7";
        IGraphView<URI> graph = this.initGraph(projectName);
        String leftPath = String.valueOf(projectName) + URI_SEP + LEFT + URI_SEP;
        URI parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R4.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R2.ecore#_B"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R5.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R4.ecore#_D"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(leftPath) + "R6.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + leftPath + "R4.ecore#_D"), (Object)parentData.toString());
        String rightPath = String.valueOf(projectName) + URI_SEP + RIGHT + URI_SEP;
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R1.ecore"), (boolean)false));
        Assert.assertNull((Object)parentData);
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R2.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R3.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R1.ecore#_A"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R4.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R2.ecore#_B"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R5.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R4.ecore#_D"), (Object)parentData.toString());
        parentData = (URI)graph.getParentData((Object)URI.createPlatformResourceURI((String)(String.valueOf(rightPath) + "R6.ecore"), (boolean)false));
        Assert.assertEquals((Object)(String.valueOf(PLATFORM_RESOURCE) + URI_SEP + rightPath + "R4.ecore#_D"), (Object)parentData.toString());
    }
}

