/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import com.google.common.eventbus.EventBus;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyLocalResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.LocalMonitoredProxyCreationListener;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceDependencyFoundEvent;
import org.eclipse.emf.compare.ide.ui.tests.logical.resolver.AbstractMonitoredProxyCreationListenerTest;
import org.eclipse.emf.ecore.EObject;
import org.junit.Test;
import org.mockito.Mockito;

public class LocalMonitoredProxyCreationListenerTest
extends AbstractMonitoredProxyCreationListenerTest {
    LocalMonitoredProxyCreationListener sut;

    @Test
    public void testCorrectProxy() {
        this.prepareTest("platform:/resource/to", CrossReferenceResolutionScope.WORKSPACE);
        this.sut = new LocalMonitoredProxyCreationListener(this.monitor, this.eventBus, this.localResolver, this.diagnostic);
        this.sut.proxyCreated(this.source, this.eObject, this.feature, (EObject)this.proxy, 3);
        ((EventBus)Mockito.verify((Object)this.eventBus)).post((Object)new ResourceDependencyFoundEvent(this.from, this.to, this.eObject, this.feature));
        ((IResourceDependencyLocalResolver)Mockito.verify((Object)this.localResolver)).demandResolve(this.synchronizedResourceSet, this.to, this.diagnostic, this.monitor);
    }

    @Test
    public void testNonPlatformResource() {
        this.prepareTest("nonplatform:/resource/to", CrossReferenceResolutionScope.WORKSPACE);
        this.sut = new LocalMonitoredProxyCreationListener(this.monitor, this.eventBus, this.localResolver, this.diagnostic);
        this.sut.proxyCreated(this.source, this.eObject, this.feature, (EObject)this.proxy, 3);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.eventBus, this.localResolver});
    }

    @Test
    public void testNonAbsolutePlatformResource() {
        this.prepareTest("platform:relative/file", CrossReferenceResolutionScope.WORKSPACE);
        this.sut = new LocalMonitoredProxyCreationListener(this.monitor, this.eventBus, this.localResolver, this.diagnostic);
        this.sut.proxyCreated(this.source, this.eObject, this.feature, (EObject)this.proxy, 3);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.eventBus, this.localResolver});
    }

    @Test
    public void testWrongResolutionScope() {
        this.prepareTest("platform:/resource/to", CrossReferenceResolutionScope.SELF);
        this.sut = new LocalMonitoredProxyCreationListener(this.monitor, this.eventBus, this.localResolver, this.diagnostic);
        this.sut.proxyCreated(this.source, this.eObject, this.feature, (EObject)this.proxy, 3);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.eventBus, this.localResolver});
    }
}

