/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.graph.IGraphView;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.ide.ui.tests.CompareTestCase;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.junit.Assert;
import org.junit.Test;

public class GraphResolutionTest
extends CompareTestCase {
    private IFile leftR1;
    private IFile leftR2;
    private IFile leftR3;
    private IFile leftR4;
    private IFile rightR1;
    private IFile rightR2;
    private IFile rightR3;
    private IFile rightR4;
    private IFile originR1;
    private IFile originR2;
    private IFile originR3;
    private IFile originR4;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.leftR1 = this.project.createFile("left/R1.ecore", this.getClass().getResource("data/left/R1.ecore").openStream());
        this.leftR2 = this.project.createFile("left/R2.ecore", this.getClass().getResource("data/left/R2.ecore").openStream());
        this.leftR3 = this.project.createFile("left/R3.ecore", this.getClass().getResource("data/left/R3.ecore").openStream());
        this.leftR4 = this.project.createFile("left/R4.ecore", this.getClass().getResource("data/left/R4.ecore").openStream());
        this.rightR1 = this.project.createFile("right/R1.ecore", this.getClass().getResource("data/right/R1.ecore").openStream());
        this.rightR2 = this.project.createFile("right/R2.ecore", this.getClass().getResource("data/right/R2.ecore").openStream());
        this.rightR3 = this.project.createFile("right/R3.ecore", this.getClass().getResource("data/right/R3.ecore").openStream());
        this.rightR4 = this.project.createFile("right/R4.ecore", this.getClass().getResource("data/right/R4.ecore").openStream());
        this.originR1 = this.project.createFile("origin/R1.ecore", this.getClass().getResource("data/origin/R1.ecore").openStream());
        this.originR2 = this.project.createFile("origin/R2.ecore", this.getClass().getResource("data/origin/R2.ecore").openStream());
        this.originR3 = this.project.createFile("origin/R3.ecore", this.getClass().getResource("data/origin/R3.ecore").openStream());
        this.originR4 = this.project.createFile("origin/R4.ecore", this.getClass().getResource("data/origin/R4.ecore").openStream());
    }

    @Test
    public void testComparison() throws Exception {
        StorageTypedElement leftTE = new StorageTypedElement((IStorage)this.leftR1, this.leftR1.getFullPath().toOSString());
        StorageTypedElement rightTE = new StorageTypedElement((IStorage)this.rightR1, this.rightR1.getFullPath().toOSString());
        StorageTypedElement originTE = new StorageTypedElement((IStorage)this.originR1, this.originR1.getFullPath().toOSString());
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)this.leftR1);
        Assert.assertTrue((boolean)(resolver instanceof ThreadedModelResolver));
        ComparisonScopeBuilder scopeBuilder = new ComparisonScopeBuilder(resolver, (IModelMinimizer)EMFCompareIDEUIPlugin.getDefault().getModelMinimizerRegistry().getCompoundMinimizer(), null);
        IComparisonScope scope = scopeBuilder.build((ITypedElement)leftTE, (ITypedElement)rightTE, (ITypedElement)originTE, (IProgressMonitor)new NullProgressMonitor());
        Comparison comparison = EMFCompare.builder().build().compare(scope);
        IGraphView graph = ((ThreadedModelResolver)resolver).getGraphView();
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.leftR4)).contains((Object)this.getURI(this.leftR3)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.leftR3)).contains((Object)this.getURI(this.leftR2)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.leftR2)).contains((Object)this.getURI(this.leftR1)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.leftR1)).isEmpty());
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.rightR4)).contains((Object)this.getURI(this.rightR3)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.rightR3)).contains((Object)this.getURI(this.rightR2)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.rightR2)).contains((Object)this.getURI(this.rightR1)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.rightR1)).isEmpty());
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.originR4)).contains((Object)this.getURI(this.originR3)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.originR3)).contains((Object)this.getURI(this.originR2)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.originR2)).contains((Object)this.getURI(this.originR1)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.originR1)).isEmpty());
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.leftR1), (Object)this.getURI(this.leftR2)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.leftR2), (Object)this.getURI(this.leftR3)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.leftR3), (Object)this.getURI(this.leftR4)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.rightR1), (Object)this.getURI(this.rightR2)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.rightR2), (Object)this.getURI(this.rightR3)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.rightR3), (Object)this.getURI(this.rightR4)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.originR1), (Object)this.getURI(this.originR2)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.originR2), (Object)this.getURI(this.originR3)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.originR3), (Object)this.getURI(this.originR4)));
    }

    @Test
    public void testModelResolver() throws Exception {
        ThreadedModelResolver resolver = new ThreadedModelResolver();
        resolver.setGraph((IGraph)new Graph());
        resolver.initialize();
        resolver.resolveLocalModels((IResource)this.leftR1, (IResource)this.rightR1, (IResource)this.originR1, (IProgressMonitor)new NullProgressMonitor());
        IGraphView graph = resolver.getGraphView();
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.leftR4)).contains((Object)this.getURI(this.leftR3)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.leftR3)).contains((Object)this.getURI(this.leftR2)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.leftR2)).contains((Object)this.getURI(this.leftR1)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.leftR1)).isEmpty());
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.rightR4)).contains((Object)this.getURI(this.rightR3)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.rightR3)).contains((Object)this.getURI(this.rightR2)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.rightR2)).contains((Object)this.getURI(this.rightR1)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.rightR1)).isEmpty());
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.originR4)).contains((Object)this.getURI(this.originR3)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.originR3)).contains((Object)this.getURI(this.originR2)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.originR2)).contains((Object)this.getURI(this.originR1)));
        Assert.assertTrue((boolean)graph.getDirectParents((Object)this.getURI(this.originR1)).isEmpty());
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.leftR1), (Object)this.getURI(this.leftR2)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.leftR2), (Object)this.getURI(this.leftR3)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.leftR3), (Object)this.getURI(this.leftR4)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.rightR1), (Object)this.getURI(this.rightR2)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.rightR2), (Object)this.getURI(this.rightR3)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.rightR3), (Object)this.getURI(this.rightR4)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.originR1), (Object)this.getURI(this.originR2)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.originR2), (Object)this.getURI(this.originR3)));
        Assert.assertTrue((boolean)graph.hasChild((Object)this.getURI(this.originR3), (Object)this.getURI(this.originR4)));
    }

    private URI getURI(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString().substring(1), (boolean)true);
    }
}

