/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.modelprovider;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFModelProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.tests.CompareTestCase;
import org.eclipse.emf.compare.ide.ui.tests.workspace.TestProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class EMFModelProviderTest
extends CompareTestCase {
    private static final String TEST_DATA_PATH = "src/org/eclipse/emf/compare/ide/ui/tests/logical/modelprovider/data/";
    private static final String TEST_BUNDLE = "org.eclipse.emf.compare.ide.ui.tests";
    private static final String PROJECT_NAME_1 = "project1";
    private static final String PROJECT_NAME_2 = "project2";
    private static final String PROJECT_NAME_3 = "project3";

    @AfterClass
    public static void setDefaultResolutionScope() {
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        store.setToDefault("org.eclipse.emf.compare.ide.ui.preference.resolutionScope");
    }

    @AfterClass
    public static void deleteProjects() throws CoreException {
        EMFModelProviderTest.deleteProject(PROJECT_NAME_1);
        EMFModelProviderTest.deleteProject(PROJECT_NAME_2);
        EMFModelProviderTest.deleteProject(PROJECT_NAME_3);
    }

    private static void deleteProject(String name) throws CoreException {
        IProject project = new TestProject(name).getProject();
        project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private void setResolutionScope(String preference) {
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.emf.compare.ide.ui.preference.resolutionScope", preference);
    }

    private IFile[] createProjectFilesCase1() throws CoreException, IOException, URISyntaxException {
        IProject project1 = new TestProject(PROJECT_NAME_1).getProject();
        IProject project2 = new TestProject(PROJECT_NAME_2).getProject();
        IProject project3 = new TestProject(PROJECT_NAME_3).getProject();
        IFile file1 = this.addToProject(project1, "case1/file1.ecore", "");
        IFile file2 = this.addToProject(project2, "case1/file2.ecore", "");
        IFile file3 = this.addToProject(project3, "case1/file3.ecore", "");
        return new IFile[]{file1, file2, file3};
    }

    private IFile[] createProjectFilesCase2() throws CoreException, IOException, URISyntaxException {
        IProject project1 = new TestProject(PROJECT_NAME_1).getProject();
        IProject project2 = new TestProject(PROJECT_NAME_2).getProject();
        IProject project3 = new TestProject(PROJECT_NAME_3).getProject();
        IFile file1 = this.addToProject(project1, "case2/file1.ecore", "");
        IFile file2 = this.addToProject(project2, "case2/file2.ecore", "");
        IFile file3 = this.addToProject(project3, "case2/file3.ecore", "");
        return new IFile[]{file1, file2, file3};
    }

    private IFile[] createProjectFilesCase3() throws CoreException, IOException, URISyntaxException {
        IProject project1 = new TestProject(PROJECT_NAME_1).getProject();
        IFile file1 = this.addToProject(project1, "case3/file1.ecore", "");
        IFile file2 = this.addToProject(project1, "case3/file2.ecore", "/a/");
        IFile file3 = this.addToProject(project1, "case3/file3.ecore", "/a/");
        return new IFile[]{file1, file2, file3};
    }

    @Test
    public void testResourceMappingCase1_Outgoing() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING.toString());
        IFile[] files = this.createProjectFilesCase1();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)3L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)1L, (long)combinedResourceMappings.length);
    }

    @Test
    public void testResourceMappingCase1_Container() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.CONTAINER.toString());
        IFile[] files = this.createProjectFilesCase1();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)3L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)3L, (long)combinedResourceMappings.length);
    }

    @Test
    public void testResourceMappingCase1_Project() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.PROJECT.toString());
        IFile[] files = this.createProjectFilesCase1();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)3L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)3L, (long)combinedResourceMappings.length);
    }

    @Test
    public void testResourceMappingCase1_Workspace() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE.toString());
        IFile[] files = this.createProjectFilesCase1();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)1L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)1L, (long)combinedResourceMappings.length);
    }

    @Test
    public void testResourceMappingCase2_Outgoing() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING.toString());
        IFile[] files = this.createProjectFilesCase2();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)2L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)1L, (long)combinedResourceMappings.length);
    }

    @Test
    public void testResourceMappingCase2_Container() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.CONTAINER.toString());
        IFile[] files = this.createProjectFilesCase2();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)3L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)3L, (long)combinedResourceMappings.length);
    }

    @Test
    public void testResourceMappingCase2_Project() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.PROJECT.toString());
        IFile[] files = this.createProjectFilesCase2();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)3L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)3L, (long)combinedResourceMappings.length);
    }

    @Test
    public void testResourceMappingCase2_Workspace() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE.toString());
        IFile[] files = this.createProjectFilesCase2();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)1L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)1L, (long)combinedResourceMappings.length);
    }

    @Test
    public void testResourceMappingCase3_Outgoing() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING.toString());
        IFile[] files = this.createProjectFilesCase3();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)3L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)1L, (long)combinedResourceMappings.length);
    }

    @Test
    public void testResourceMappingCase3_Container() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.CONTAINER.toString());
        IFile[] files = this.createProjectFilesCase3();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)2L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)1L, (long)combinedResourceMappings.length);
    }

    @Test
    public void testResourceMappingCase3_Project() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.PROJECT.toString());
        IFile[] files = this.createProjectFilesCase3();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)1L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)1L, (long)combinedResourceMappings.length);
    }

    @Test
    public void testResourceMappingCase3_Workspace() throws CoreException, IOException, URISyntaxException {
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE.toString());
        IFile[] files = this.createProjectFilesCase3();
        ResourceMapping[] singleResourceMappings = this.collectSingleResourceMappings(files);
        Assert.assertEquals((long)1L, (long)singleResourceMappings.length);
        ResourceMapping[] combinedResourceMappings = this.getCombinedResourceMappings(files);
        Assert.assertEquals((long)1L, (long)combinedResourceMappings.length);
    }

    private ResourceMapping[] collectSingleResourceMappings(IFile ... files) throws CoreException {
        EMFModelProvider emfModelProvider = this.getEMFModelProvider();
        HashSet<ResourceMapping> mappings = new HashSet<ResourceMapping>();
        int i = 0;
        while (i < files.length) {
            IFile resource = files[i];
            ResourceMapping[] resourceMappings = emfModelProvider.getMappings((IResource)resource, (ResourceMappingContext)new StubContext(), (IProgressMonitor)new NullProgressMonitor());
            if (resourceMappings.length > 0) {
                mappings.addAll(Arrays.asList(resourceMappings));
            }
            ++i;
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }

    private ResourceMapping[] getCombinedResourceMappings(IFile ... files) throws CoreException {
        EMFModelProvider emfModelProvider = this.getEMFModelProvider();
        return emfModelProvider.getMappings((IResource[])files, (ResourceMappingContext)new StubContext(), (IProgressMonitor)new NullProgressMonitor());
    }

    private EMFModelProvider getEMFModelProvider() throws CoreException {
        IModelProviderDescriptor[] descriptors;
        IModelProviderDescriptor[] iModelProviderDescriptorArray = descriptors = ModelProvider.getModelProviderDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor descriptor = iModelProviderDescriptorArray[n2];
            if (descriptor.getModelProvider() instanceof EMFModelProvider) {
                return (EMFModelProvider)descriptor.getModelProvider();
            }
            ++n2;
        }
        return null;
    }

    private IFile addToProject(IProject iProject, String filePath, String destinationPath) throws IOException, URISyntaxException, CoreException {
        Bundle bundle = Platform.getBundle((String)TEST_BUNDLE);
        URI fileUri = this.getFileUri(bundle.getEntry(TEST_DATA_PATH + filePath));
        File file = this.project.getOrCreateFile(iProject, String.valueOf(destinationPath) + fileUri.lastSegment());
        EMFModelProviderTest.copyFile(this.toFile(fileUri), file);
        return this.project.getIFile(iProject, file);
    }

    private URI getFileUri(URL bundleUrl) throws IOException {
        URL fileLocation = FileLocator.toFileURL((URL)bundleUrl);
        return URI.createFileURI((String)fileLocation.getPath());
    }

    private File toFile(URI fileUri) throws URISyntaxException {
        return new File(fileUri.toFileString());
    }

    private class StubContext
    extends RemoteResourceMappingContext {
        private StubContext() {
        }

        public IStorage fetchBaseContents(IFile file, IProgressMonitor monitor) throws CoreException {
            return null;
        }

        public IResource[] fetchMembers(IContainer container, IProgressMonitor monitor) throws CoreException {
            return new IResource[0];
        }

        public IStorage fetchRemoteContents(IFile file, IProgressMonitor monitor) throws CoreException {
            return null;
        }

        public IProject[] getProjects() {
            return ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }

        public boolean hasLocalChange(IResource resource, IProgressMonitor monitor) throws CoreException {
            return true;
        }

        public boolean hasRemoteChange(IResource resource, IProgressMonitor monitor) throws CoreException {
            return true;
        }

        public boolean isThreeWay() {
            return false;
        }

        public void refresh(ResourceTraversal[] traversals, int flags, IProgressMonitor monitor) throws CoreException {
        }
    }
}

