/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.rcp.ui.tests.groups;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.nodes.Node;
import org.eclipse.emf.compare.tests.nodes.NodeSingleValueAttribute;
import org.eclipse.emf.compare.tests.nodes.NodesFactory;
import org.eclipse.emf.compare.tests.nodes.util.NodesResourceFactoryImpl;
import org.eclipse.emf.compare.uml2.rcp.ui.tests.groups.NotifierScopeProvider;
import org.eclipse.emf.compare.uml2.tests.edit.provider.StereotypedElementItemProviderTestUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.tree.TreePackage;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractDifferenceOrderTest {
    private Comparison comparison;
    private ECrossReferenceAdapter crossReferenceAdapter;
    private AdapterFactoryItemDelegator itemDelegator;
    protected EventBus eventBus;
    private Predicate<EObject> viewerFilterPredicate;
    private StructureMergeViewerFilter filter;

    @Before
    public void before() throws IOException {
        ArrayList factories = Lists.newArrayList();
        factories.addAll(this.getAdaptersFactory());
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory((Collection)factories);
        this.itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        this.comparison = this.getComparison(this.getInput());
        this.crossReferenceAdapter = new ECrossReferenceAdapter(){

            protected boolean isIncluded(EReference eReference) {
                return eReference == TreePackage.Literals.TREE_NODE__DATA;
            }
        };
        this.filter = new StructureMergeViewerFilter(new EventBus());
        this.viewerFilterPredicate = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                AdapterImpl adapter = new AdapterImpl();
                adapter.setTarget((Notifier)input);
                return AbstractDifferenceOrderTest.this.filter.select(null, null, (Object)adapter);
            }
        };
    }

    protected void compareTree(Resource expectedResult, List<? extends TreeNode> actualTrees, boolean testIcons) {
        ArrayList nonFilteredActualRoot = Lists.newArrayList((Iterable)Collections2.filter(actualTrees, this.viewerFilterPredicate));
        EList expectedContent = expectedResult.getContents();
        Assert.assertEquals((long)expectedContent.size(), (long)nonFilteredActualRoot.size());
        int i = 0;
        while (i < expectedContent.size()) {
            Node expectedRootNode = (Node)expectedContent.get(i);
            TreeNode actualRoot = (TreeNode)nonFilteredActualRoot.get(i);
            TreeIterator expectedIterator = expectedRootNode.eAllContents();
            UnmodifiableIterator realIterator = Iterators.filter((Iterator)actualRoot.eAllContents(), this.viewerFilterPredicate);
            this.compareTree((TreeIterator<EObject>)expectedIterator, (Iterator<EObject>)realIterator, testIcons);
            ++i;
        }
    }

    private void compareTree(TreeIterator<EObject> expectedIterator, Iterator<EObject> realIterator, boolean testIcons) {
        while (expectedIterator.hasNext()) {
            Node expectedElement = (Node)expectedIterator.next();
            Assert.assertTrue((String)("No match for element " + expectedElement.getName()), (boolean)realIterator.hasNext());
            EObject actualElem = realIterator.next();
            Assert.assertEquals((String)this.getErrorMessage(actualElem), (Object)expectedElement.getName(), (Object)this.itemDelegator.getText((Object)actualElem));
            if (testIcons) {
                Assert.assertTrue((boolean)(expectedElement instanceof NodeSingleValueAttribute));
                List actualIcons = StereotypedElementItemProviderTestUtil.getIconsLocation((Object)this.itemDelegator.getImage((Object)actualElem));
                Assert.assertEquals((String)("Wrong icon on " + expectedElement.getName()), (Object)((NodeSingleValueAttribute)expectedElement).getSingleValuedAttribute(), (Object)Joiner.on((char)',').join((Iterable)actualIcons));
            }
            if (expectedElement.eContainer() == null) continue;
            EList expectedChildren = expectedElement.getContainmentRef1();
            Assert.assertEquals((String)("Incorrect children for " + this.getFullPath(actualElem)), (long)expectedChildren.size(), (long)Collections2.filter((Collection)((TreeNode)actualElem).getChildren(), this.viewerFilterPredicate).size());
        }
    }

    protected abstract List<AdapterFactory> getAdaptersFactory();

    protected abstract NotifierScopeProvider getInput();

    protected Comparison getComparison() {
        return this.comparison;
    }

    private Comparison getComparison(NotifierScopeProvider scopeProvider) throws IOException {
        DefaultComparisonScope scope = new DefaultComparisonScope(scopeProvider.getLeft(), scopeProvider.getRight(), scopeProvider.getOrigin());
        EMFCompare.Builder builder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(builder);
        return builder.build().compare((IComparisonScope)scope);
    }

    protected ECrossReferenceAdapter getCrossReferenceAdapter() {
        return this.crossReferenceAdapter;
    }

    private String getErrorMessage(EObject actual) {
        StringBuilder message = new StringBuilder();
        message.append("Content error on \"").append(this.getFullPath(actual)).append("\"");
        return message.toString();
    }

    protected StructureMergeViewerFilter getFilter() {
        return this.filter;
    }

    private String getFullPath(EObject eObject) {
        String result;
        if (eObject != null) {
            ArrayList<String> ancestors = new ArrayList<String>();
            ancestors.add(this.itemDelegator.getText((Object)eObject));
            EObject eContainer = eObject.eContainer();
            while (eContainer != null) {
                ancestors.add(this.itemDelegator.getText((Object)eContainer));
                eContainer = eContainer.eContainer();
            }
            result = Joiner.on((String)"::").join((Iterable)Lists.reverse(ancestors));
        } else {
            result = null;
        }
        return result;
    }

    protected IPostProcessor.Descriptor.Registry<?> getPostProcessorRegistry() {
        return null;
    }

    protected AdapterFactoryItemDelegator getItemDelegator() {
        return this.itemDelegator;
    }

    protected final TestWriterHelper createTestHelper() {
        return new TestWriterHelper();
    }

    protected final class TestWriterHelper {
        private TestWriterHelper() {
        }

        public void createExpectedModel(String fileLocation, List<? extends TreeNode> roots, boolean fillIcon) {
            URI fileURI = URI.createFileURI((String)fileLocation);
            NodesResourceFactoryImpl resourceFactory = new NodesResourceFactoryImpl();
            Resource res = resourceFactory.createResource(fileURI);
            this.fillTree(res, roots, fillIcon);
            try {
                res.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private Node createNode(TreeNode n, boolean saveIcon) {
            Object newNode = null;
            if (AbstractDifferenceOrderTest.this.viewerFilterPredicate.apply((Object)n)) {
                newNode = saveIcon ? NodesFactory.eINSTANCE.createNodeSingleValueAttribute() : NodesFactory.eINSTANCE.createNode();
                newNode.setName(AbstractDifferenceOrderTest.this.itemDelegator.getText((Object)n));
                for (TreeNode child : n.getChildren()) {
                    Node createNode = this.createNode(child, saveIcon);
                    if (createNode == null) continue;
                    newNode.getContainmentRef1().add((Object)createNode);
                }
                if (saveIcon) {
                    Object icon = AbstractDifferenceOrderTest.this.itemDelegator.getImage((Object)n);
                    newNode.setSingleValuedAttribute(Joiner.on((char)',').join((Iterable)StereotypedElementItemProviderTestUtil.getIconsLocation((Object)icon)));
                }
            }
            return newNode;
        }

        private void fillTree(Resource resource, List<? extends TreeNode> roots, boolean fillIcon) {
            for (TreeNode treeNode : roots) {
                Node createNode = this.createNode(treeNode, fillIcon);
                if (createNode == null) continue;
                resource.getContents().add((Object)createNode);
            }
        }
    }
}

