/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;

public class CachingDiffRelationshipComputer
extends DiffRelationshipComputer {
    protected Map<Diff, Set<Diff>> directMergeDependenciesR2L = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> directMergeDependenciesL2R = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> directResultingMergesR2L = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> directResultingMergesL2R = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> directResultingRejectionsR2L = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> directResultingRejectionsL2R = new ConcurrentHashMap<Diff, Set<Diff>>();

    public CachingDiffRelationshipComputer(IMerger.Registry registry) {
        this(registry, IMergeCriterion.NONE);
    }

    public CachingDiffRelationshipComputer(IMerger.Registry registry, IMergeCriterion criterion) {
        super(registry, criterion);
    }

    @Override
    public void setMergerRegistry(IMerger.Registry mergerRegistry) {
        if (this.getMergerRegistry() != mergerRegistry) {
            super.setMergerRegistry(mergerRegistry);
            this.invalidate();
        }
    }

    @Override
    public void setMergeCriterion(IMergeCriterion mergeCriterion) {
        if (this.getMergeCriterion() != mergeCriterion) {
            super.setMergeCriterion(mergeCriterion);
            this.invalidate();
        }
    }

    protected void setCachedDirectMergeDependencies(Diff diff, boolean mergeRightToLeft, Set<Diff> directMergeDependencies) {
        if (mergeRightToLeft) {
            this.directMergeDependenciesR2L.put(diff, directMergeDependencies);
        } else {
            this.directMergeDependenciesL2R.put(diff, directMergeDependencies);
        }
    }

    protected Set<Diff> getCachedDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        if (mergeRightToLeft) {
            return this.directMergeDependenciesR2L.get(diff);
        }
        return this.directMergeDependenciesL2R.get(diff);
    }

    protected Set<Diff> computeDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        return super.getDirectMergeDependencies(diff, mergeRightToLeft);
    }

    @Override
    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        Set<Diff> directMergeDependencies = this.getCachedDirectMergeDependencies(diff, mergeRightToLeft);
        if (directMergeDependencies == null) {
            directMergeDependencies = this.computeDirectMergeDependencies(diff, mergeRightToLeft);
            this.setCachedDirectMergeDependencies(diff, mergeRightToLeft, this.asEmptySet(directMergeDependencies));
        }
        return directMergeDependencies;
    }

    protected void setCachedDirectResultingMerges(Diff diff, boolean mergeRightToLeft, Set<Diff> directResultingMerges) {
        if (mergeRightToLeft) {
            this.directResultingMergesR2L.put(diff, directResultingMerges);
        } else {
            this.directResultingMergesL2R.put(diff, directResultingMerges);
        }
    }

    protected Set<Diff> getCachedDirectResultingMerges(Diff diff, boolean mergeRightToLeft) {
        if (mergeRightToLeft) {
            return this.directResultingMergesR2L.get(diff);
        }
        return this.directResultingMergesL2R.get(diff);
    }

    protected Set<Diff> computeDirectResultingMerges(Diff diff, boolean mergeRightToLeft) {
        return super.getDirectResultingMerges(diff, mergeRightToLeft);
    }

    @Override
    public Set<Diff> getDirectResultingMerges(Diff diff, boolean mergeRightToLeft) {
        Set<Diff> directResultingMerges = this.getCachedDirectResultingMerges(diff, mergeRightToLeft);
        if (directResultingMerges == null) {
            directResultingMerges = this.computeDirectResultingMerges(diff, mergeRightToLeft);
            this.setCachedDirectResultingMerges(diff, mergeRightToLeft, this.asEmptySet(directResultingMerges));
        }
        return directResultingMerges;
    }

    protected void setCachedDirectResultingRejections(Diff diff, boolean mergeRightToLeft, Set<Diff> directResultingRejections) {
        if (mergeRightToLeft) {
            this.directResultingRejectionsR2L.put(diff, directResultingRejections);
        } else {
            this.directResultingRejectionsL2R.put(diff, directResultingRejections);
        }
    }

    protected Set<Diff> getCachedDirectResultingRejections(Diff diff, boolean mergeRightToLeft) {
        if (mergeRightToLeft) {
            return this.directResultingRejectionsR2L.get(diff);
        }
        return this.directResultingRejectionsL2R.get(diff);
    }

    protected Set<Diff> computeDirectResultingRejections(Diff diff, boolean mergeRightToLeft) {
        return super.getDirectResultingRejections(diff, mergeRightToLeft);
    }

    @Override
    public Set<Diff> getDirectResultingRejections(Diff diff, boolean mergeRightToLeft) {
        Set<Diff> directResultingRejections = this.getCachedDirectResultingRejections(diff, mergeRightToLeft);
        if (directResultingRejections == null) {
            directResultingRejections = this.computeDirectResultingRejections(diff, mergeRightToLeft);
            this.setCachedDirectResultingRejections(diff, mergeRightToLeft, this.asEmptySet(directResultingRejections));
        }
        return directResultingRejections;
    }

    private Set<Diff> asEmptySet(Set<Diff> diffs) {
        if (diffs.isEmpty()) {
            return Collections.emptySet();
        }
        return diffs;
    }

    public void computeCache(Diff diff) {
        IMerger2 merger = this.getMerger(diff);
        if (merger != null) {
            this.directMergeDependenciesR2L.put(diff, this.asEmptySet(merger.getDirectMergeDependencies(diff, true)));
            this.directMergeDependenciesL2R.put(diff, this.asEmptySet(merger.getDirectMergeDependencies(diff, false)));
            this.directResultingRejectionsR2L.put(diff, this.asEmptySet(merger.getDirectResultingRejections(diff, true)));
            this.directResultingRejectionsL2R.put(diff, this.asEmptySet(merger.getDirectResultingRejections(diff, false)));
            this.directResultingMergesR2L.put(diff, this.asEmptySet(merger.getDirectResultingMerges(diff, true)));
            this.directResultingMergesL2R.put(diff, this.asEmptySet(merger.getDirectResultingMerges(diff, false)));
        }
    }

    public void invalidate() {
        this.directMergeDependenciesR2L.clear();
        this.directMergeDependenciesL2R.clear();
        this.directResultingRejectionsR2L.clear();
        this.directResultingRejectionsL2R.clear();
        this.directResultingMergesR2L.clear();
        this.directResultingMergesL2R.clear();
    }
}

