/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.diff;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.fullcomparison.data.identifier.IdentifierMatchInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class ComparisonUtilTest {
    @Test
    public void testSubDiffs() throws IOException {
        IdentifierMatchInputData inputData = new IdentifierMatchInputData();
        Resource left = inputData.getExtlibraryLeft();
        Resource origin = inputData.getExtlibraryOrigin();
        Resource right = inputData.getExtlibraryRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Predicate leftPeriodical = Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.referenceValueMatch((String)"eClassifiers", (String)"extlibrary.Periodical", (boolean)true)});
        Diff leftPeriodicalDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)leftPeriodical);
        boolean leftToRight = false;
        Iterable subDiffs = (Iterable)ComparisonUtil.getSubDiffs((boolean)leftToRight).apply((Object)leftPeriodicalDiff);
        Assert.assertEquals((long)7L, (long)Iterables.size((Iterable)subDiffs));
        leftToRight = true;
        subDiffs = (Iterable)ComparisonUtil.getSubDiffs((boolean)leftToRight).apply((Object)leftPeriodicalDiff);
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)subDiffs));
        Predicate leftMagazine = Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"eClassifiers", (String)"extlibrary.Magazine", (boolean)true)});
        Diff leftMagazineDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)leftMagazine);
        leftToRight = false;
        subDiffs = (Iterable)ComparisonUtil.getSubDiffs((boolean)leftToRight).apply((Object)leftMagazineDiff);
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)subDiffs));
        leftToRight = true;
        subDiffs = (Iterable)ComparisonUtil.getSubDiffs((boolean)leftToRight).apply((Object)leftMagazineDiff);
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)subDiffs));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        differences = comparison.getDifferences();
        Predicate leftPeriodical3Way = Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.referenceValueMatch((String)"eClassifiers", (String)"extlibrary.Periodical", (boolean)true)});
        Diff leftPeriodicalDiff3Way = (Diff)Iterators.find(differences.iterator(), (Predicate)leftPeriodical3Way);
        leftToRight = false;
        subDiffs = (Iterable)ComparisonUtil.getSubDiffs((boolean)leftToRight).apply((Object)leftPeriodicalDiff3Way);
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)subDiffs));
        leftToRight = true;
        subDiffs = (Iterable)ComparisonUtil.getSubDiffs((boolean)leftToRight).apply((Object)leftPeriodicalDiff3Way);
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)subDiffs));
        Predicate leftMagazine3Way = Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"eClassifiers", (String)"extlibrary.Magazine", (boolean)true)});
        Diff leftMagazineDiff3Way = (Diff)Iterators.find(differences.iterator(), (Predicate)leftMagazine3Way);
        leftToRight = false;
        subDiffs = (Iterable)ComparisonUtil.getSubDiffs((boolean)leftToRight).apply((Object)leftMagazineDiff3Way);
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)subDiffs));
        leftToRight = true;
        subDiffs = (Iterable)ComparisonUtil.getSubDiffs((boolean)leftToRight).apply((Object)leftMagazineDiff3Way);
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)subDiffs));
    }
}

