/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.dependency;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.uml2.internal.DirectedRelationshipChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.dependency.data.DependencyInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddAbstractionTest
extends AbstractUMLTest {
    private DependencyInputData input = new DependencyInputData();

    @BeforeClass
    public static void setupClass() {
        AddAbstractionTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        AddAbstractionTest.resetRegistries();
    }

    @Test
    public void testA20UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testA21UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testA20UseCase3way() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testA21UseCase3way() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate addAbstractionDescription = null;
        Predicate addRefClass1InAbstractionDescription = null;
        Predicate addRefClass0InAbstractionDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addAbstractionDescription = EMFComparePredicates.removed((String)"model.Abstraction0");
            addRefClass1InAbstractionDescription = EMFComparePredicates.removedFromReference((String)"model.Abstraction0", (String)"client", (String)"model.Class1");
            addRefClass0InAbstractionDescription = EMFComparePredicates.removedFromReference((String)"model.Abstraction0", (String)"supplier", (String)"model.Class0");
        } else {
            addAbstractionDescription = EMFComparePredicates.added((String)"model.Abstraction0");
            addRefClass1InAbstractionDescription = EMFComparePredicates.addedToReference((String)"model.Abstraction0", (String)"client", (String)"model.Class1");
            addRefClass0InAbstractionDescription = EMFComparePredicates.addedToReference((String)"model.Abstraction0", (String)"supplier", (String)"model.Class0");
        }
        Diff addAbstraction = (Diff)Iterators.find(differences.iterator(), (Predicate)addAbstractionDescription);
        Diff addRefClass1InAbstraction = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefClass1InAbstractionDescription);
        Diff addRefClass0InAbstraction = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefClass0InAbstractionDescription);
        Assert.assertNotNull((Object)addAbstraction);
        Assert.assertNotNull((Object)addRefClass1InAbstraction);
        Assert.assertNotNull((Object)addRefClass0InAbstraction);
        Assert.assertEquals((long)1L, (long)AddAbstractionTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(DirectedRelationshipChange.class)));
        Diff addUMLDependency = null;
        addUMLDependency = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(DirectedRelationshipChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))) : (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(DirectedRelationshipChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        Assert.assertNotNull((Object)addUMLDependency);
        Assert.assertEquals((long)3L, (long)addUMLDependency.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLDependency.getRefinedBy().contains((Object)addRefClass1InAbstraction));
        Assert.assertTrue((boolean)addUMLDependency.getRefinedBy().contains((Object)addRefClass0InAbstraction));
        Assert.assertTrue((boolean)addUMLDependency.getRefinedBy().contains((Object)addAbstraction));
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)1L, (long)addRefClass1InAbstraction.getRequires().size());
            Assert.assertTrue((boolean)addRefClass1InAbstraction.getRequires().contains((Object)addAbstraction));
            Assert.assertEquals((long)1L, (long)addRefClass0InAbstraction.getRequires().size());
            Assert.assertTrue((boolean)addRefClass0InAbstraction.getRequires().contains((Object)addAbstraction));
            Assert.assertEquals((long)0L, (long)addAbstraction.getRequires().size());
            Assert.assertEquals((long)0L, (long)addUMLDependency.getRequires().size());
        } else {
            Assert.assertEquals((long)0L, (long)addRefClass1InAbstraction.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefClass0InAbstraction.getRequires().size());
            Assert.assertEquals((long)2L, (long)addAbstraction.getRequires().size());
            Assert.assertTrue((boolean)addAbstraction.getRequires().contains((Object)addRefClass1InAbstraction));
            Assert.assertTrue((boolean)addAbstraction.getRequires().contains((Object)addRefClass0InAbstraction));
            Assert.assertEquals((long)0L, (long)addUMLDependency.getRequires().size());
        }
        Assert.assertEquals((long)0L, (long)comparison.getEquivalences().size());
        Assert.assertNull((Object)addRefClass1InAbstraction.getEquivalence());
        this.testIntersections(comparison);
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

