/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.compiler.URIUnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;

public abstract class UnitResolverFactory {
    protected abstract boolean accepts(URI var1);

    protected abstract UnitResolver getResolver(URI var1);

    protected abstract String getQualifiedName(URI var1);

    private UnitProxy findUnit(URI uri) {
        String qualifiedName = this.getQualifiedName(uri);
        if (qualifiedName == null) {
            return null;
        }
        UnitResolver resolver = this.getResolver(uri);
        return resolver != null ? resolver.resolveUnit(qualifiedName) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Registry {
        public static final Registry INSTANCE = EMFPlugin.IS_ECLIPSE_RUNNING ? new EclipseRegistry() : new BasicRegistry();

        public UnitProxy getUnit(URI var1);

        public List<UnitProxy> findAllUnits(URI var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class BasicRegistry
        implements Registry {
            private final List<UnitResolverFactory> fFactories;

            BasicRegistry() {
                this(Collections.emptyList());
            }

            BasicRegistry(List<UnitResolverFactory> factories) {
                assert (factories != null);
                factories = new ArrayList<UnitResolverFactory>(factories);
                factories.add(new URIUnitResolverFactory());
                this.fFactories = factories;
            }

            UnitResolverFactory getFactory(URI uri) {
                for (UnitResolverFactory nextFactory : this.fFactories) {
                    if (!nextFactory.accepts(uri)) continue;
                    return nextFactory;
                }
                return null;
            }

            @Override
            public UnitProxy getUnit(URI uri) {
                UnitResolverFactory factory = this.getFactory(uri);
                if (factory != null) {
                    return factory.findUnit(uri);
                }
                return null;
            }

            @Override
            public List<UnitProxy> findAllUnits(URI uri) {
                UnitResolverFactory factory = this.getFactory(uri);
                if (factory == null) {
                    return Collections.emptyList();
                }
                UnitResolver resolver = factory.getResolver(uri);
                if (!(resolver instanceof UnitProvider)) {
                    return Collections.emptyList();
                }
                final ArrayList<UnitProxy> result = new ArrayList<UnitProxy>();
                UnitProvider.UnitVisitor visitor = new UnitProvider.UnitVisitor(){

                    public boolean visitUnit(UnitProxy unit) {
                        result.add(unit);
                        return true;
                    }
                };
                ((UnitProvider)((Object)resolver)).accept(visitor, null, 2, true);
                return result;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class EclipseRegistry
        extends BasicRegistry {
            private static final String POINT_ID = "org.eclipse.m2m.qvt.oml.unitResolverFactory";
            private static final String CLASS_ATTR = "class";

            public EclipseRegistry() {
                super(EclipseRegistry.readFactories());
            }

            private static List<UnitResolverFactory> readFactories() {
                IExtensionRegistry pluginRegistry;
                IExtensionPoint extensionPoint;
                ArrayList<UnitResolverFactory> factoryEntries = new ArrayList<UnitResolverFactory>();
                if (EMFPlugin.IS_ECLIPSE_RUNNING && (extensionPoint = (pluginRegistry = Platform.getExtensionRegistry()).getExtensionPoint(POINT_ID)) != null) {
                    IExtension[] allExtensions;
                    IExtension[] iExtensionArray = allExtensions = extensionPoint.getExtensions();
                    int n = allExtensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension nextExtension = iExtensionArray[n2];
                        IConfigurationElement[] elements = nextExtension.getConfigurationElements();
                        Object factoryObj = null;
                        try {
                            factoryObj = elements[0].createExecutableExtension(CLASS_ATTR);
                            if (factoryObj instanceof UnitResolverFactory) {
                                factoryEntries.add((UnitResolverFactory)factoryObj);
                            }
                        }
                        catch (CoreException e) {
                            QvtPlugin.getDefault().log(e.getStatus());
                        }
                        ++n2;
                    }
                }
                return factoryEntries;
            }
        }
    }
}

