/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SimpleGroup;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class Boundary
implements Nameable {
    protected final @NonNull SimpleGroup sourceGroup;
    protected final @NonNull Edge edge;
    protected final @NonNull SimpleGroup targetGroup;
    protected final @NonNull String name;

    public Boundary(@NonNull SimpleGroup sourceGroup, @NonNull Edge edge, @NonNull SimpleGroup targetGroup) {
        this.sourceGroup = sourceGroup;
        this.edge = edge;
        this.targetGroup = targetGroup;
        this.name = String.valueOf(sourceGroup.getName()) + "==>" + edge.getName() + "==>" + targetGroup.getName();
    }

    public @NonNull Edge getEdge() {
        return this.edge;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull SimpleGroup getSourceGroup() {
        return this.sourceGroup;
    }

    public @NonNull SimpleGroup getTargetGroup() {
        return this.targetGroup;
    }

    public boolean isReverseNavigable() {
        if (!(this.edge instanceof NavigationEdge)) {
            return false;
        }
        Property forwardProperty = QVTscheduleUtil.getReferredProperty((NavigationEdge)((NavigationEdge)this.edge));
        Property reverseProperty = forwardProperty.getOpposite();
        if (reverseProperty == null) {
            return false;
        }
        return !reverseProperty.isIsImplicit();
    }

    public @NonNull String toString() {
        return this.name;
    }
}

