/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtcore.tests;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.xtext.qvtbase.tests.ModelNormalizer;
import org.eclipse.qvtd.xtext.qvtcore.tests.upper2lower.simplegraph.SimplegraphPackage;

public class Upper2LowerNormalizer
implements ModelNormalizer {
    public static final @NonNull Upper2LowerNormalizer INSTANCE = new Upper2LowerNormalizer();

    public @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull XtextTestCase.Normalizer> normalize(@NonNull Resource resource) {
        EObject eRoot = (EObject)resource.getContents().get(0);
        EPackage ePackage = eRoot.eClass().getEPackage();
        EClass graphClass = (EClass)ePackage.getEClassifier(SimplegraphPackage.Literals.GRAPH.getName());
        assert (graphClass != null);
        EClass elementClass = (EClass)ePackage.getEClassifier(SimplegraphPackage.Literals.ELEMENT.getName());
        assert (elementClass != null);
        EClass edgeClass = (EClass)ePackage.getEClassifier(SimplegraphPackage.Literals.EDGE.getName());
        assert (edgeClass != null);
        EClass nodeClass = (EClass)ePackage.getEClassifier(SimplegraphPackage.Literals.NODE.getName());
        assert (nodeClass != null);
        EReference graphElements = (EReference)graphClass.getEStructuralFeature(SimplegraphPackage.Literals.GRAPH__ELEMENT.getName());
        assert (graphElements != null);
        EAttribute nodeLabel = (EAttribute)nodeClass.getEStructuralFeature(SimplegraphPackage.Literals.NODE__LABEL.getName());
        assert (nodeLabel != null);
        EReference nodeIncoming = (EReference)nodeClass.getEStructuralFeature(SimplegraphPackage.Literals.NODE__INCOMING.getName());
        assert (nodeIncoming != null);
        EReference nodeOutgoing = (EReference)nodeClass.getEStructuralFeature(SimplegraphPackage.Literals.NODE__OUTGOING.getName());
        assert (nodeOutgoing != null);
        EReference edgeSource = (EReference)edgeClass.getEStructuralFeature(SimplegraphPackage.Literals.EDGE__SOURCE.getName());
        assert (edgeSource != null);
        EReference edgeTarget = (EReference)edgeClass.getEStructuralFeature(SimplegraphPackage.Literals.EDGE__TARGET.getName());
        assert (edgeTarget != null);
        ElementComparator elementComparator = new ElementComparator(edgeClass, edgeSource, edgeTarget, nodeLabel);
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull XtextTestCase.Normalizer> normalizers = new ArrayList<XtextTestCase.Normalizer>();
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            EClass eClass = eObject.eClass();
            if (graphClass.isSuperTypeOf(eClass)) {
                normalizers.add(new GraphNormalizer(eObject, graphElements, elementComparator));
            }
            if (!nodeClass.isSuperTypeOf(eClass)) continue;
            normalizers.add(new NodeNormalizer(eObject, nodeIncoming, nodeOutgoing, elementComparator));
        }
        for (XtextTestCase.Normalizer normalizer : normalizers) {
            normalizer.normalize();
        }
        return normalizers;
    }

    protected static class ElementComparator
    implements Comparator<EObject> {
        private final @NonNull EClass edgeClass;
        private final @NonNull EReference edgeSource;
        private final @NonNull EReference edgeTarget;
        private final @NonNull EAttribute nodeLabel;

        public ElementComparator(@NonNull EClass edgeClass, @NonNull EReference edgeSource, @NonNull EReference edgeTarget, @NonNull EAttribute nodeLabel) {
            this.edgeClass = edgeClass;
            this.edgeSource = edgeSource;
            this.edgeTarget = edgeTarget;
            this.nodeLabel = nodeLabel;
        }

        @Override
        public int compare(EObject o1, EObject o2) {
            String n2;
            String n1;
            if (this.edgeClass.isInstance((Object)o1)) {
                if (!this.edgeClass.isInstance((Object)o2)) {
                    return 1;
                }
                n1 = (String)((EObject)o1.eGet((EStructuralFeature)this.edgeSource)).eGet((EStructuralFeature)this.nodeLabel);
                if (ClassUtil.safeEquals((Object)n1, (Object)(n2 = (String)((EObject)o2.eGet((EStructuralFeature)this.edgeSource)).eGet((EStructuralFeature)this.nodeLabel)))) {
                    n1 = (String)((EObject)o1.eGet((EStructuralFeature)this.edgeTarget)).eGet((EStructuralFeature)this.nodeLabel);
                    n2 = (String)((EObject)o2.eGet((EStructuralFeature)this.edgeTarget)).eGet((EStructuralFeature)this.nodeLabel);
                }
            } else {
                if (this.edgeClass.isInstance((Object)o2)) {
                    return -1;
                }
                n1 = (String)o1.eGet((EStructuralFeature)this.nodeLabel);
                n2 = (String)o2.eGet((EStructuralFeature)this.nodeLabel);
            }
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }

    protected class GraphNormalizer
    implements XtextTestCase.Normalizer {
        protected final @NonNull EObject graph;
        protected final @NonNull EReference graphElements;
        protected final @NonNull ElementComparator elementComparator;

        public GraphNormalizer(@NonNull EObject graph, @NonNull EReference graphElements, ElementComparator elementComparator) {
            this.graph = graph;
            this.graphElements = graphElements;
            this.elementComparator = elementComparator;
        }

        public void denormalize() {
            throw new UnsupportedOperationException();
        }

        public void normalize() {
            EList elements = (EList)this.graph.eGet((EStructuralFeature)this.graphElements);
            ECollections.sort((EList)elements, (Comparator)this.elementComparator);
        }
    }

    protected class NodeNormalizer
    implements XtextTestCase.Normalizer {
        protected final @NonNull EObject node;
        protected final @NonNull EReference incoming;
        protected final @NonNull EReference outgoing;
        protected final @NonNull ElementComparator elementComparator;

        public NodeNormalizer(@NonNull EObject node, @NonNull EReference incoming, @NonNull EReference outgoing, ElementComparator elementComparator) {
            this.node = node;
            this.incoming = incoming;
            this.outgoing = outgoing;
            this.elementComparator = elementComparator;
        }

        public void denormalize() {
            throw new UnsupportedOperationException();
        }

        public void normalize() {
            EList incomingEdges = (EList)this.node.eGet((EStructuralFeature)this.incoming);
            ECollections.sort((EList)incomingEdges, (Comparator)this.elementComparator);
            EList outgoingEdges = (EList)this.node.eGet((EStructuralFeature)this.outgoing);
            ECollections.sort((EList)outgoingEdges, (Comparator)this.elementComparator);
        }
    }
}

