/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.DatumConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Scheduler;

public class Region2Depth {
    private @NonNull Map<@NonNull Region, @Nullable Integer> region2depth = new HashMap<Region, Integer>();
    private @NonNull Map<@NonNull Region, @NonNull List<@NonNull Region>> region2parents = new HashMap<Region, List<Region>>();
    private @NonNull Map<@NonNull Region, @NonNull List<@NonNull Region>> region2children = new HashMap<Region, List<Region>>();
    private @NonNull Map<@NonNull Region, @NonNull Set<@NonNull Region>> region2properAncestors = new HashMap<Region, Set<Region>>();

    public void addRegion(@NonNull Region region) {
        this.region2children.clear();
        this.region2depth.clear();
        this.region2parents.clear();
        Scheduler.REGION_DEPTH.println(String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(System.identityHashCode(this)) + " <reset> : " + region.getName());
    }

    public @Nullable Region getCommonRegion(@NonNull Region firstRegion, @NonNull Region secondRegion) {
        Region thisRegion = firstRegion;
        Region thatRegion = secondRegion;
        while (thisRegion != thatRegion) {
            int thatDepth;
            int thisDepth = this.getRegionDepth(thisRegion);
            if (thisDepth > (thatDepth = this.getRegionDepth(thatRegion))) {
                if ((thisRegion = this.getMinimumDepthParentRegion(thisRegion)) != null) continue;
                return null;
            }
            if (thatDepth > thisDepth) {
                if ((thatRegion = this.getMinimumDepthParentRegion(thatRegion)) != null) continue;
                return null;
            }
            thisRegion = this.getMinimumDepthParentRegion(thisRegion);
            thatRegion = this.getMinimumDepthParentRegion(thatRegion);
            if (thisRegion != null && thatRegion != null) continue;
            return null;
        }
        return thisRegion;
    }

    public @Nullable Region getMinimumDepthParentRegion(@NonNull Region childRegion) {
        Region minimumDepthParentRegion = null;
        int minimumDepth = Integer.MAX_VALUE;
        for (Region parentRegion : this.getParentRegions(childRegion)) {
            int parentDepth = this.getRegionDepth(parentRegion);
            if (minimumDepthParentRegion != null && parentDepth >= minimumDepth) continue;
            minimumDepthParentRegion = parentRegion;
            minimumDepth = parentDepth;
        }
        return minimumDepthParentRegion;
    }

    public @NonNull Iterable<@NonNull Region> getParentRegions(@NonNull Region childRegion) {
        ScheduledRegion childInvokingRegion = childRegion.getInvokingRegion();
        int childInvokingRegionDepth = childInvokingRegion != null ? this.getRegionDepth(childInvokingRegion) : 0;
        List<@NonNull Region> parentRegions = this.region2parents.get(childRegion);
        if (parentRegions == null) {
            parentRegions = new ArrayList<Region>();
            for (DatumConnection datumConnection : childRegion.getIncomingPassedConnections()) {
                for (Node source : datumConnection.getSourceNodes()) {
                    Region parentRegion;
                    Region sourceRegion = source.getRegion();
                    ScheduledRegion sourceInvokingRegion = sourceRegion.getInvokingRegion();
                    int sourceInvokingRegionDepth = sourceInvokingRegion != null ? this.getRegionDepth(sourceInvokingRegion) : 0;
                    Region region = parentRegion = sourceInvokingRegionDepth < childInvokingRegionDepth ? childInvokingRegion : sourceRegion;
                    if (parentRegion == null || parentRegions.contains(parentRegion)) continue;
                    parentRegions.add(parentRegion);
                }
            }
            if (parentRegions.isEmpty() && childInvokingRegion != null) {
                parentRegions.add(childInvokingRegion);
            }
            this.region2parents.put(childRegion, parentRegions);
        }
        return parentRegions;
    }

    protected @NonNull Set<@NonNull Region> getProperAncestorRegions(@NonNull Region childRegion) {
        Set<@NonNull Region> properAncestorRegions = this.region2properAncestors.get(childRegion);
        if (properAncestorRegions == null) {
            properAncestorRegions = new HashSet<Region>();
            int childDepth = this.getRegionDepth(childRegion);
            for (Region parentRegion : this.getParentRegions(childRegion)) {
                int parentDepth = this.getRegionDepth(parentRegion);
                if (parentDepth >= childDepth) continue;
                properAncestorRegions.add(parentRegion);
                properAncestorRegions.addAll(this.getProperAncestorRegions(parentRegion));
            }
            this.region2properAncestors.put(childRegion, properAncestorRegions);
        }
        return properAncestorRegions;
    }

    public int getRegionDepth(@NonNull Region region) {
        Integer depth = this.region2depth.get(region);
        if (depth == null) {
            if (this.region2depth.containsKey(region)) {
                Scheduler.REGION_DEPTH.println(String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(System.identityHashCode(this)) + " <loop> : " + region.getName());
                return 0;
            }
            this.region2depth.put(region, null);
            depth = 0;
            Iterable<@NonNull Region> parentRegions = this.getParentRegions(region);
            for (Region callingRegion : parentRegions) {
                int callingDepth = this.getRegionDepth(callingRegion);
                if (callingDepth < depth) continue;
                depth = callingDepth + 1;
            }
            this.region2depth.put(region, depth);
            Scheduler.REGION_DEPTH.println(String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(System.identityHashCode(this)) + " " + depth + " : " + region.getName());
        }
        return depth;
    }

    public <E extends Edge> @NonNull Iterable<@NonNull E> getSortedEdges(@NonNull Iterable<@NonNull E> edges) {
        HashMap<@NonNull K, @NonNull V> node2edge = new HashMap();
        ArrayList<@NonNull E> orderedNodes = new ArrayList();
        ArrayList<@NonNull Edge> orderedEdges = new ArrayList<Edge>();
        for (Node orderedNode : orderedNodes) {
            @Nullable Edge edge = (Edge)node2edge.get(orderedNode);
            assert (edge != null);
            orderedEdges.add(edge);
        }
        assert (orderedEdges.size() == node2edge.size());
        return orderedEdges;
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<Region, Integer> entry : this.region2depth.entrySet()) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(entry.getValue() + " : " + entry.getKey().getName());
        }
        return s.toString();
    }
}

