/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleMappingRegion;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.schedule.ClassDatum;

public class ClassDatumAnalysis {
    protected final @NonNull SchedulerConstants schedulerConstants;
    protected final @NonNull ClassDatum classDatum;
    protected final @NonNull CompleteClass completeClass;
    protected final @NonNull DomainUsage domainUsage;
    private List<@NonNull Property> multiOpposites = null;
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull Node>> introducer2assignmentNodes = new HashMap<Region, List<Node>>();
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull Node>> consumer2predicateNodes = new HashMap<Region, List<Node>>();
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull Node>> producer2assignmentNodes = new HashMap<Region, List<Node>>();
    private List<@NonNull ClassDatumAnalysis> superClassDatumAnalyses = null;

    public ClassDatumAnalysis(@NonNull SchedulerConstants schedulerConstants, @NonNull ClassDatum classDatum) {
        this.schedulerConstants = schedulerConstants;
        this.classDatum = classDatum;
        this.domainUsage = schedulerConstants.getDomainUsage((Element)ClassUtil.nonNullState((Object)classDatum.getTypedModel()));
        Class type = classDatum.getType();
        assert (type != null);
        this.completeClass = schedulerConstants.getEnvironmentFactory().getCompleteModel().getCompleteClass((Type)type);
    }

    public void addConsumption(@NonNull Region consumer, @NonNull Node consumingNode) {
        List<@NonNull Node> predicateNodes = this.consumer2predicateNodes.get(consumer);
        if (predicateNodes == null) {
            predicateNodes = new ArrayList<Node>();
            this.consumer2predicateNodes.put(consumer, predicateNodes);
        }
        if (!predicateNodes.contains(consumingNode)) {
            predicateNodes.add(consumingNode);
        }
    }

    public void addIntroduction(@NonNull Region introducer, @NonNull Node introducingNode) {
        List<@NonNull Node> assignmentNodes = this.introducer2assignmentNodes.get(introducer);
        if (assignmentNodes == null) {
            assignmentNodes = new ArrayList<Node>();
            this.introducer2assignmentNodes.put(introducer, assignmentNodes);
        }
        assert (!assignmentNodes.contains(introducingNode));
        assignmentNodes.add(introducingNode);
    }

    public void addProduction(@NonNull SimpleMappingRegion producer, @NonNull Node producingNode) {
        List<@NonNull Node> assignmentNodes = this.producer2assignmentNodes.get(producer);
        if (assignmentNodes == null) {
            assignmentNodes = new ArrayList<Node>();
            this.producer2assignmentNodes.put(producer, assignmentNodes);
        }
        if (!assignmentNodes.contains(producingNode)) {
            assignmentNodes.add(producingNode);
        }
    }

    public @NonNull ClassDatum getClassDatum() {
        return this.classDatum;
    }

    public @NonNull CompleteClass getCompleteClass() {
        return this.completeClass;
    }

    public @NonNull Iterable<Node> getConsumingNodes() {
        return Iterables.concat(this.consumer2predicateNodes.values());
    }

    public @NonNull Set<@NonNull Region> getConsumingRegions() {
        return this.consumer2predicateNodes.keySet();
    }

    public @NonNull DomainUsage getDomainUsage() {
        return this.domainUsage;
    }

    public @Nullable List<Property> getMultiOpposites() {
        List<@NonNull Property> multiOpposites2 = this.multiOpposites;
        if (multiOpposites2 == null) {
            EnvironmentFactory environmentFactory = this.schedulerConstants.getEnvironmentFactory();
            Class asClass = this.classDatum.getType();
            assert (asClass != null);
            CompleteClass completeClass = environmentFactory.getCompleteModel().getCompleteClass((Type)asClass);
            for (Property property : completeClass.getProperties(null)) {
                Type childrenType;
                Property oppositeProperty = property.getOpposite();
                if (oppositeProperty == null || !oppositeProperty.isIsMany() || oppositeProperty.isIsDerived() || !((childrenType = oppositeProperty.getType()) instanceof CollectionType)) continue;
                Type childType = ((CollectionType)childrenType).getElementType();
                assert (childType != null);
                StandardLibrary standardLibrary = environmentFactory.getStandardLibrary();
                if (!asClass.conformsTo(standardLibrary, childType)) continue;
                if (multiOpposites2 == null) {
                    this.multiOpposites = multiOpposites2 = new ArrayList<Property>();
                }
                multiOpposites2.add(oppositeProperty);
            }
            if (multiOpposites2 != null) {
                Collections.sort(multiOpposites2, MultiOppositeComparator.INSTANCE);
            }
        }
        return multiOpposites2;
    }

    public @NonNull Iterable<Node> getProducingNodes() {
        return Iterables.concat(this.consumer2predicateNodes.values());
    }

    public @NonNull Set<Region> getProducingRegions() {
        return this.producer2assignmentNodes.keySet();
    }

    public @Nullable Node getSingleProducer() {
        Iterator<List<Node>> values = this.producer2assignmentNodes.values().iterator();
        if (!values.hasNext()) {
            return null;
        }
        List<Node> firstProductions = values.next();
        return !values.hasNext() && firstProductions.size() == 1 ? firstProductions.get(0) : null;
    }

    public @NonNull Iterable<@NonNull ClassDatumAnalysis> getSuperClassDatumAnalyses() {
        List<@NonNull ClassDatumAnalysis> superClassDatumAnalyses2 = this.superClassDatumAnalyses;
        if (superClassDatumAnalyses2 == null) {
            this.superClassDatumAnalyses = superClassDatumAnalyses2 = new ArrayList<ClassDatumAnalysis>();
            for (CompleteClass completeSuperClass : this.completeClass.getSuperCompleteClasses()) {
                superClassDatumAnalyses2.add(this.schedulerConstants.getClassDatumAnalysis(completeSuperClass.getPrimaryClass(), (TypedModel)ClassUtil.nonNullState((Object)this.domainUsage.getTypedModel((Element)this.completeClass))));
            }
        }
        return superClassDatumAnalyses2;
    }

    public @NonNull TypedModel getTypedModel() {
        return (TypedModel)ClassUtil.nonNullState((Object)this.classDatum.getTypedModel());
    }

    public boolean hasNoProducers() {
        return this.producer2assignmentNodes.size() == 0;
    }

    public String toString() {
        return this.classDatum.toString();
    }

    protected static final class MultiOppositeComparator
    implements Comparator<Property> {
        public static final Comparator<@NonNull ? super Property> INSTANCE = new MultiOppositeComparator();

        protected MultiOppositeComparator() {
        }

        @Override
        public int compare(@NonNull Property o1, @NonNull Property o2) {
            boolean c2;
            boolean c1 = o1.isIsComposite();
            if (c1 != (c2 = o1.isIsComposite())) {
                return Boolean.compare(c1, c2);
            }
            return ClassUtil.safeCompareTo((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    }
}

