/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.compiler;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFReferenceModel;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Metamodel;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.compiler.EmftvmCompilerPlugin;
import org.eclipse.m2m.atl.emftvm.impl.resource.EMFTVMResourceFactoryImpl;
import org.eclipse.m2m.atl.emftvm.util.ClassModuleResolver;
import org.eclipse.m2m.atl.emftvm.util.DefaultModuleResolverFactory;
import org.eclipse.m2m.atl.emftvm.util.ExecEnvPool;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.ModuleNotFoundException;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolver;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolverFactory;
import org.eclipse.m2m.atl.emftvm.util.VMException;
import org.eclipse.m2m.atl.engine.ProblemConverter;
import org.eclipse.m2m.atl.engine.compiler.AtlStandaloneCompiler;
import org.eclipse.m2m.atl.engine.compiler.CompileTimeError;
import org.eclipse.m2m.atl.engine.parser.AtlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlToEmftvmCompiler
implements AtlStandaloneCompiler {
    protected final ResourceSet rs = new ResourceSetImpl();
    protected final Metamodel pbmm = EmftvmFactory.eINSTANCE.createMetamodel();
    protected final ExecEnvPool atlWfrPool = new ExecEnvPool();
    protected final ExecEnvPool atlToEmftvmPool = new ExecEnvPool();
    protected final ExecEnvPool inlineCodeblocksPool = new ExecEnvPool();

    public AtlToEmftvmCompiler() {
        this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emftvm", new EMFTVMResourceFactoryImpl());
        Metamodel atlmm = EmftvmFactory.eINSTANCE.createMetamodel();
        atlmm.setResource(((EMFReferenceModel)AtlParser.getDefault().getAtlMetamodel()).getResource());
        this.pbmm.setResource(((EMFReferenceModel)AtlParser.getDefault().getProblemMetamodel()).getResource());
        ModuleResolverFactory mrf = this.createModuleResolverFactory();
        this.atlWfrPool.setModuleResolverFactory(mrf);
        this.atlWfrPool.registerMetaModel("ATL", atlmm);
        this.atlWfrPool.registerMetaModel("Problem", this.pbmm);
        this.atlWfrPool.loadModule("ATLWFR");
        this.atlToEmftvmPool.setModuleResolverFactory(mrf);
        this.atlToEmftvmPool.registerMetaModel("ATL", atlmm);
        this.atlToEmftvmPool.registerMetaModel("Problem", this.pbmm);
        this.atlToEmftvmPool.loadModule("ATLtoEMFTVM");
        this.inlineCodeblocksPool.setModuleResolverFactory(mrf);
        this.inlineCodeblocksPool.registerMetaModel("Problem", this.pbmm);
        this.inlineCodeblocksPool.loadModule("InlineCodeblocks");
    }

    protected ModuleResolverFactory createModuleResolverFactory() {
        Object moduleResolverFactory = new DefaultModuleResolverFactory("platform:/plugin/org.eclipse.m2m.atl.emftvm.compiler/transformations/");
        try {
            moduleResolverFactory.createModuleResolver().resolveModule("ATLWFR");
        }
        catch (ModuleNotFoundException e) {
            moduleResolverFactory = new ModuleResolverFactory(){

                public ModuleResolver createModuleResolver() {
                    return new ClassModuleResolver(this.getClass()){

                        public Module resolveModule(String module) throws ModuleNotFoundException {
                            return super.resolveModule("/transformations/" + module);
                        }
                    };
                }
            };
        }
        return moduleResolverFactory;
    }

    public final CompileTimeError[] compile(InputStream in, String outputFileName) {
        return this.compile(new InputStreamReader(in), outputFileName);
    }

    public EObject[] compileWithProblemModel(InputStream in, String outputFileName) {
        return this.compileWithProblemModel((Reader)new InputStreamReader(in), outputFileName);
    }

    public EObject[] compileWithProblemModel(InputStream in, OutputStream outputStream) {
        return this.compileWithProblemModel((Reader)new InputStreamReader(in), outputStream);
    }

    public CompileTimeError[] compile(Reader in, String outputFileName) {
        EObject[] eObjects = this.compileWithProblemModel(in, outputFileName);
        CompileTimeError[] result = new CompileTimeError[eObjects.length];
        int i = 0;
        while (i < eObjects.length) {
            result[i] = ProblemConverter.convertProblem((EObject)eObjects[i]);
            ++i;
        }
        return result;
    }

    public EObject[] compileWithProblemModel(Reader in, String outputFileName) {
        EObject[] result = new EObject[]{};
        try {
            String emftvmOutputFileName = String.valueOf(outputFileName.substring(0, outputFileName.lastIndexOf(46))) + ".emftvm";
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(emftvmOutputFileName));
            try {
                result = this.compileWithProblemModel(in, (OutputStream)outputStream);
            }
            finally {
                ((OutputStream)outputStream).close();
            }
        }
        catch (IOException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            EmftvmCompilerPlugin.log(e);
        }
        return result;
    }

    public EObject[] compileWithProblemModel(Reader in, OutputStream outputStream) {
        ArrayList<EObject> pbs = new ArrayList<EObject>();
        try {
            IModel[] parsed = AtlParser.getDefault().inject(in, null);
            IModel atlmodel = parsed[0];
            IModel problems = parsed[1];
            if (this.getProblems(problems, pbs) == 0) {
                EObject[] cpbs;
                EObject[] eObjectArray = cpbs = this.compileWithProblemModel(atlmodel, outputStream);
                int n = cpbs.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject cpb = eObjectArray[n2];
                    pbs.add(cpb);
                    ++n2;
                }
            }
        }
        catch (ATLCoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            EmftvmCompilerPlugin.log(e);
        }
        return pbs.toArray(new EObject[pbs.size()]);
    }

    public EObject[] compileWithProblemModel(IModel atlModel, OutputStream outputStream) {
        ArrayList<EObject> pbs;
        block9: {
            pbs = new ArrayList<EObject>();
            Model atlm = EmftvmFactory.eINSTANCE.createModel();
            atlm.setResource(((EMFModel)atlModel).getResource());
            Resource pr = this.rs.createResource(URI.createFileURI((String)"problems.xmi"));
            Model pbm = EmftvmFactory.eINSTANCE.createModel();
            pbm.setResource(pr);
            Resource r = this.rs.createResource(URI.createFileURI((String)"out.emftvm"), "org.eclipse.m2m.atl.emftvm");
            Model emftvmm = EmftvmFactory.eINSTANCE.createModel();
            emftvmm.setResource(r);
            ExecEnv atlWfrEnv = this.atlWfrPool.getExecEnv();
            ExecEnv atlToEmftvmEnv = this.atlToEmftvmPool.getExecEnv();
            ExecEnv inlineCodeblocksEnv = this.inlineCodeblocksPool.getExecEnv();
            try {
                atlWfrEnv.registerInputModel("IN", atlm);
                atlWfrEnv.registerOutputModel("OUT", pbm);
                atlWfrEnv.run(null);
                if (this.getProblems(pbm, pbs) == 0) {
                    atlToEmftvmEnv.registerInputModel("IN", atlm);
                    atlToEmftvmEnv.registerOutputModel("OUT", emftvmm);
                    atlToEmftvmEnv.registerOutputModel("PBS", pbm);
                    atlToEmftvmEnv.run(null);
                    if (this.getProblems(pbm, pbs) == 0) {
                        inlineCodeblocksEnv.registerInOutModel("IN", emftvmm);
                        inlineCodeblocksEnv.run(null);
                        r.save(outputStream, Collections.emptyMap());
                    }
                }
            }
            catch (VMException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                EmftvmCompilerPlugin.log(e);
                this.atlWfrPool.returnExecEnv(atlWfrEnv);
                this.atlToEmftvmPool.returnExecEnv(atlToEmftvmEnv);
                this.inlineCodeblocksPool.returnExecEnv(inlineCodeblocksEnv);
                this.rs.getResources().remove((Object)pr);
                this.rs.getResources().remove((Object)r);
                break block9;
            }
            catch (IOException e) {
                try {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                    EmftvmCompilerPlugin.log(e);
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.atlWfrPool.returnExecEnv(atlWfrEnv);
                    this.atlToEmftvmPool.returnExecEnv(atlToEmftvmEnv);
                    this.inlineCodeblocksPool.returnExecEnv(inlineCodeblocksEnv);
                    this.rs.getResources().remove((Object)pr);
                    this.rs.getResources().remove((Object)r);
                }
            }
            this.atlWfrPool.returnExecEnv(atlWfrEnv);
            this.atlToEmftvmPool.returnExecEnv(atlToEmftvmEnv);
            this.inlineCodeblocksPool.returnExecEnv(inlineCodeblocksEnv);
            this.rs.getResources().remove((Object)pr);
            this.rs.getResources().remove((Object)r);
        }
        return pbs.toArray(new EObject[pbs.size()]);
    }

    public EObject[] compileWithProblemModel(IModel atlModel, String outputFileName) {
        EObject[] eObjectArray;
        String emftvmOutputFileName = String.valueOf(outputFileName.substring(0, outputFileName.lastIndexOf(46))) + ".emftvm";
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(emftvmOutputFileName));
        try {
            eObjectArray = this.compileWithProblemModel(atlModel, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            try {
                ((OutputStream)outputStream).close();
                throw throwable;
            }
            catch (IOException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                EmftvmCompilerPlugin.log(e);
                return new EObject[0];
            }
        }
        ((OutputStream)outputStream).close();
        return eObjectArray;
    }

    protected int getProblems(IModel problems, Collection<EObject> pbElements) {
        Set pbs = problems.getElementsByType(problems.getReferenceModel().getMetaElementByName("Problem"));
        int nbErrors = 0;
        if (pbs != null) {
            for (EObject pb : pbs) {
                EStructuralFeature severityFeature = pb.eClass().getEStructuralFeature("severity");
                if (severityFeature == null || !"error".equals(((Enumerator)pb.eGet(severityFeature)).getName())) continue;
                ++nbErrors;
            }
            pbElements.addAll(pbs);
        }
        return nbErrors;
    }

    protected int getProblems(Model problems, Collection<EObject> pbElements) {
        LazyList pbs = problems.allInstancesOf((EClass)this.pbmm.findType("Problem"));
        int nbErrors = 0;
        if (pbs != null) {
            for (EObject pb : pbs) {
                EStructuralFeature severityFeature = pb.eClass().getEStructuralFeature("severity");
                if (severityFeature == null || !"error".equals(((Enumerator)pb.eGet(severityFeature)).getName())) continue;
                ++nbErrors;
            }
            pbElements.addAll((Collection<EObject>)pbs);
        }
        return nbErrors;
    }
}

