/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.lsp4jakarta.commons.ClasspathKind;

public class JDTJakartaUtils {
    private static final Logger LOGGER = Logger.getLogger(JDTJakartaUtils.class.getName());
    public static final String JAKARTA_RS_GET = "jakarta.ws.rs.GET";

    public static String getProjectURI(IJavaProject project) {
        return JDTJakartaUtils.getProjectURI(project.getProject());
    }

    public static String getProjectURI(IProject project) {
        return project.getLocation().toOSString();
    }

    public static ClasspathKind getClasspathKind(IResource resource, IJavaProject javaProject) {
        IClasspathEntry[] classpath;
        IPath exactPath;
        IPath path = exactPath = resource.getFullPath();
        int resourceType = resource.getType();
        if (resourceType != 2) {
            // empty if block
        }
        try {
            classpath = ((JavaProject)javaProject).getResolvedClasspath();
        }
        catch (JavaModelException javaModelException) {
            return ClasspathKind.NONE;
        }
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            IPath entryPath = entry.getPath();
            if (entryPath.equals((Object)exactPath)) {
                return JDTJakartaUtils.getClasspathKind(entry);
            }
            if (entryPath.isAbsolute() && entryPath.equals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation().append(exactPath))) {
                return JDTJakartaUtils.getClasspathKind(entry);
            }
            if (entryPath.isPrefixOf(path)) {
                return JDTJakartaUtils.getClasspathKind(entry);
            }
            ++i;
        }
        return ClasspathKind.NONE;
    }

    public static boolean hasNature(IProject project, String natureId) {
        try {
            return project != null && project.hasNature(natureId);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static ClasspathKind getClasspathKind(IClasspathEntry entry) {
        return entry.isTest() ? ClasspathKind.TEST : ClasspathKind.SRC;
    }

    public static boolean isJakartaProject(IJavaProject javaProject) {
        try {
            return javaProject.findType(JAKARTA_RS_GET) != null;
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.INFO, "Current Java project is not a Jakarta project", e);
            return false;
        }
    }

    public static IJavaProject[] getJavaProjects() {
        return (IJavaProject[])Stream.of(JDTJakartaUtils.getAllProjects()).filter(JDTJakartaUtils::isJavaProject).map(p -> JavaCore.create((IProject)p)).filter(p -> p != null).toArray(IJavaProject[]::new);
    }

    private static IProject[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    private static boolean isJavaProject(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

