/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.utils;

import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class OtherFileStore
extends FileStore {
    private final URI location;

    public OtherFileStore(URI location) {
        this.location = location;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return FileStore.EMPTY_STRING_ARRAY;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        FileInfo result = new FileInfo();
        result.setDirectory(false);
        result.setExists(true);
        result.setLastModified(1L);
        return result;
    }

    public IFileStore getChild(String name) {
        return EFS.getNullFileSystem().getStore(new Path(name).makeAbsolute());
    }

    public void delete(int options, IProgressMonitor monitor) {
    }

    public String getName() {
        return "other";
    }

    public IFileStore getParent() {
        return null;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public URI toURI() {
        return this.location;
    }
}

