/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.energy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.SingleWeightFunctionDouble;
import org.eclipse.lsat.common.ludus.backend.games.StrategyVector;
import org.eclipse.lsat.common.ludus.backend.games.algorithms.DoubleFunctions;
import org.eclipse.lsat.common.ludus.backend.games.algorithms.GraphChecks;
import org.eclipse.lsat.common.ludus.backend.games.energy.solvers.SEPM;
import org.eclipse.lsat.common.ludus.backend.games.energy.solvers.ValueIterationDouble;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.energy.RatioGameEnergy;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.energy.EGDoubleImplJGraphT;

public class RatioGameValueIterationDouble {
    private RatioGameValueIterationDouble() {
    }

    public static <V, E> Map<V, Double> solve(RatioGameEnergy<V, E, Double> game) {
        return RatioGameValueIterationDouble.solve(game, 1.0E-4);
    }

    public static <V, E> Map<V, Double> solve(RatioGameEnergy<V, E, Double> game, Double epsilon) {
        HashMap vertexMap = new HashMap();
        Double w = (Double)game.getMaxAbsValue();
        Double minusW = 0.0;
        StrategyVector strategy = new StrategyVector();
        if (GraphChecks.checkEachNodeHasSuccessor(game)) {
            RatioGameValueIterationDouble.findValues(game, minusW, w, vertexMap, strategy, epsilon);
            return vertexMap;
        }
        System.out.println("Input game graph is not valid. Not every vertex has a successor.");
        return null;
    }

    private static <V, E> void findValues(RatioGameEnergy<V, E, Double> game, Double lowerBound, Double upperBound, Map<V, Double> valueMap, StrategyVector<V, E> strategy, Double epsilon) {
        double middle = (lowerBound + upperBound) / 2.0;
        if (DoubleFunctions.equalTo(upperBound, lowerBound, epsilon)) {
            for (Object v2 : game.getVertices()) {
                valueMap.put((Double)v2, middle);
            }
        } else {
            SingleWeightFunctionDouble<E> wf1 = RatioGameValueIterationDouble.convertToSingleWeightFunction(game, 1.0, -middle);
            EGDoubleImplJGraphT game1 = new EGDoubleImplJGraphT(game, wf1);
            SEPM f1 = ValueIterationDouble.getProgressMeasure(game1);
            HashSet vLeftHalve = new HashSet();
            game.getVertices().stream().filter(v -> ((Double)f1.getValue(v)).equals(ValueIterationDouble.TOP)).forEach(vLeftHalve::add);
            HashSet vRightHalve = new HashSet();
            game.getVertices().stream().filter(v -> !((Double)f1.getValue(v)).equals(ValueIterationDouble.TOP)).forEach(vRightHalve::add);
            RatioGameEnergy<V, E, Double> subGameSmallerVertices = game.getSubGraph(vLeftHalve);
            RatioGameEnergy<V, E, Double> subGameLargerVertices = game.getSubGraph(vRightHalve);
            RatioGameValueIterationDouble.findValues(subGameSmallerVertices, lowerBound, middle, valueMap, strategy, epsilon);
            RatioGameValueIterationDouble.findValues(subGameLargerVertices, middle, upperBound, valueMap, strategy, epsilon);
        }
    }

    private static <V, E> SingleWeightFunctionDouble<E> convertToSingleWeightFunction(RatioGameEnergy<V, E, Double> game, double constant_a, double constant_b) {
        SingleWeightFunctionDouble newFunction = new SingleWeightFunctionDouble();
        for (Object edge : game.getEdges()) {
            double weight = constant_a * (Double)game.getWeight1(edge) + constant_b * (Double)game.getWeight2(edge);
            newFunction.addWeight(edge, weight);
        }
        return newFunction;
    }
}

