/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteConnectionException;
import org.eclipse.linuxtools.profiling.launch.RemoteMessages;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;

public class RemoteConnection {
    private IRemoteFileProxy rmtFileProxy;

    public RemoteConnection(URI uri) throws RemoteConnectionException {
        try {
            RemoteProxyManager rmtProxyMgr = RemoteProxyManager.getInstance();
            this.rmtFileProxy = rmtProxyMgr.getFileProxy(uri);
        }
        catch (CoreException e) {
            throw new RemoteConnectionException(RemoteMessages.RemoteConnection_failed, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileFromRemoteHost(String remotePath, String localPath, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        try {
            IFileSystem localFS = EFS.getLocalFileSystem();
            IFileStore localFile = localFS.getStore(Path.fromOSString((String)localPath));
            IFileStore rmtFile = this.rmtFileProxy.getResource(remotePath);
            rmtFile.copy(localFile, 2, (IProgressMonitor)progress);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void upload(IPath localPath, IPath remotePath, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            this.copyFileToRemoteHost(localPath.toOSString(), remotePath.toOSString(), monitor);
        }
        catch (CoreException e) {
            throw new RemoteConnectionException(e.getLocalizedMessage(), e);
        }
    }

    public void createFolder(IPath remoteFolderPath, IProgressMonitor monitor) throws RemoteConnectionException {
        IFileStore remoteFolder = this.rmtFileProxy.getResource(remoteFolderPath.toString());
        try {
            remoteFolder.mkdir(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RemoteConnectionException(e.getLocalizedMessage(), e);
        }
    }

    public static String[] getLines(String buffer) {
        int numLines = 0;
        for (char c : buffer.toCharArray()) {
            if (c != '\n') continue;
            ++numLines;
        }
        String[] lines = new String[numLines];
        int line = 0;
        int startOfString = 0;
        for (int endOfString = 0; endOfString < buffer.length(); ++endOfString) {
            if (buffer.charAt(endOfString) != '\n') continue;
            lines[line++] = new String(buffer.toCharArray(), startOfString, endOfString - startOfString);
            startOfString = endOfString + 1;
        }
        return lines;
    }

    public void delete(IPath remotePath, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            IFileStore remoteFile = this.rmtFileProxy.getResource(remotePath.toString());
            remoteFile.delete(0, monitor);
        }
        catch (CoreException e) {
            throw new RemoteConnectionException(e.getLocalizedMessage(), e);
        }
    }

    public void download(IPath remotePath, IPath localPath, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            this.copyFileFromRemoteHost(remotePath.toString(), localPath.toString(), monitor);
        }
        catch (CoreException e) {
            throw new RemoteConnectionException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileToRemoteHost(String localPath, String remotePath, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        try {
            IFileSystem localFS = EFS.getLocalFileSystem();
            IFileStore localFile = localFS.getStore(Path.fromOSString((String)localPath));
            IFileStore rmtFile = this.rmtFileProxy.getResource(remotePath);
            localFile.copy(rmtFile, 2, (IProgressMonitor)progress);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public IRemoteFileProxy getRmtFileProxy() {
        return this.rmtFileProxy;
    }
}

