/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.mandas.docker.client.LogMessage;
import org.mandas.docker.client.LogReader;
import org.mandas.docker.client.LogStream;

class DefaultLogStream
implements LogStream {
    private final LogReader reader;
    private LogMessage next;

    private DefaultLogStream(InputStream stream) {
        this(new LogReader(stream));
    }

    DefaultLogStream(LogReader reader) {
        this.reader = reader;
    }

    static DefaultLogStream create(InputStream stream) {
        return new DefaultLogStream(stream);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        try {
            this.next = this.reader.nextMessage();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.next != null;
    }

    @Override
    public LogMessage next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        LogMessage value = this.next;
        this.next = null;
        return value;
    }

    @Override
    public String readFully() {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.hasNext()) {
            stringBuilder.append(StandardCharsets.UTF_8.decode(this.next().content()));
        }
        return stringBuilder.toString();
    }

    @Override
    public void attach(OutputStream stdout, OutputStream stderr) throws IOException {
        while (this.hasNext()) {
            LogMessage message = this.next();
            ByteBuffer content = message.content();
            switch (message.stream()) {
                case STDOUT: {
                    DefaultLogStream.writeAndFlush(content, stdout);
                    break;
                }
                case STDERR: {
                    DefaultLogStream.writeAndFlush(content, stderr);
                    break;
                }
            }
        }
    }

    private static void writeAndFlush(ByteBuffer buffer, OutputStream outputStream) throws IOException {
        if (buffer.hasArray()) {
            outputStream.write(buffer.array(), buffer.position(), buffer.remaining());
        } else {
            while (buffer.hasRemaining()) {
                int size = Math.min(buffer.remaining(), 8192);
                byte[] chunk = new byte[size];
                buffer.get(chunk);
                outputStream.write(chunk);
            }
        }
        outputStream.flush();
    }
}

