/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.capabilities.CompletionResolveSupportProperty;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.CompletionItemResolveSupportCapabilities;
import org.eclipse.lsp4j.CompletionList;
import org.junit.jupiter.api.Test;

public class XMLCompletionApplyBasedOnXMLSourceTest {
    @Test
    public void inEmptyText() throws BadLocationException {
        String xml = "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  | \r\n</foo>";
        CompletionList list = XMLCompletionApplyBasedOnXMLSourceTest.testCompletionSnippetSupportFor(xml, 2, XMLAssert.c("bar", XMLAssert.te(3, 2, 3, 2, "<bar>$1</bar>$0"), Collections.emptyList(), "bar"), XMLAssert.c("baz", XMLAssert.te(3, 2, 3, 2, "<baz>$1</baz>$0"), Collections.emptyList(), "baz"));
        CompletionItem barItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "bar");
        XMLAssert.testCompletionApply(xml, barItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <bar>$1</bar>$0 \r\n</foo>");
        CompletionItem bazItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "baz");
        XMLAssert.testCompletionApply(xml, bazItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <baz>$1</baz>$0 \r\n</foo>");
    }

    @Test
    public void inText() throws BadLocationException {
        String xml = "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  f| \r\n</foo>";
        CompletionList list = XMLCompletionApplyBasedOnXMLSourceTest.testCompletionSnippetSupportFor(xml, 2, XMLAssert.c("bar", XMLAssert.te(3, 2, 3, 3, "<bar>$1</bar>$0"), Collections.emptyList(), "bar"), XMLAssert.c("baz", XMLAssert.te(3, 2, 3, 3, "<baz>$1</baz>$0"), Collections.emptyList(), "baz"));
        CompletionItem barItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "bar");
        XMLAssert.testCompletionApply(xml, barItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <bar>$1</bar>$0 \r\n</foo>");
        CompletionItem bazItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "baz");
        XMLAssert.testCompletionApply(xml, bazItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <baz>$1</baz>$0 \r\n</foo>");
    }

    @Test
    public void inTextWithOrphanEndTag() throws BadLocationException {
        String xml = "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  f|</buz> \r\n</foo>";
        CompletionList list = XMLCompletionApplyBasedOnXMLSourceTest.testCompletionSnippetSupportFor(xml, 2, XMLAssert.c("bar", XMLAssert.te(3, 2, 3, 3, "<bar$0>"), Arrays.asList(XMLAssert.te(3, 5, 3, 8, "bar")), "bar"), XMLAssert.c("baz", XMLAssert.te(3, 2, 3, 3, "<baz$0>"), Arrays.asList(XMLAssert.te(3, 5, 3, 8, "baz")), "baz"));
        CompletionItem barItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "bar");
        XMLAssert.testCompletionApply(xml, barItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <bar$0></bar> \r\n</foo>");
        CompletionItem bazItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "baz");
        XMLAssert.testCompletionApply(xml, bazItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <baz$0></baz> \r\n</foo>");
    }

    @Test
    public void inEmptyTextWithOrphanEndTag() throws BadLocationException {
        String xml = "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  |</buz> \r\n</foo>";
        CompletionList list = XMLCompletionApplyBasedOnXMLSourceTest.testCompletionSnippetSupportFor(xml, 2, XMLAssert.c("bar", XMLAssert.te(3, 2, 3, 2, "<bar$0>"), Arrays.asList(XMLAssert.te(3, 4, 3, 7, "bar")), "bar"), XMLAssert.c("baz", XMLAssert.te(3, 2, 3, 2, "<baz$0>"), Arrays.asList(XMLAssert.te(3, 4, 3, 7, "baz")), "baz"));
        CompletionItem barItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "bar");
        XMLAssert.testCompletionApply(xml, barItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <bar$0></bar> \r\n</foo>");
        CompletionItem bazItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "baz");
        XMLAssert.testCompletionApply(xml, bazItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <baz$0></baz> \r\n</foo>");
    }

    @Test
    public void inElementWithNoTag() throws BadLocationException {
        String xml = "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <| \r\n</foo>";
        CompletionList list = XMLCompletionApplyBasedOnXMLSourceTest.testCompletionSnippetSupportFor(xml, 2, XMLAssert.c("bar", XMLAssert.te(3, 2, 3, 3, "<bar>$1</bar>$0"), Collections.emptyList(), "<bar"), XMLAssert.c("baz", XMLAssert.te(3, 2, 3, 3, "<baz>$1</baz>$0"), Collections.emptyList(), "<baz"));
        CompletionItem barItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "bar");
        XMLAssert.testCompletionApply(xml, barItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <bar>$1</bar>$0 \r\n</foo>");
        CompletionItem bazItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "baz");
        XMLAssert.testCompletionApply(xml, bazItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <baz>$1</baz>$0 \r\n</foo>");
    }

    @Test
    public void inElement() throws BadLocationException {
        String xml = "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <f| \r\n</foo>";
        CompletionList list = XMLCompletionApplyBasedOnXMLSourceTest.testCompletionSnippetSupportFor(xml, 2, XMLAssert.c("bar", XMLAssert.te(3, 2, 3, 4, "<bar>$1</bar>$0"), Collections.emptyList(), "<bar"), XMLAssert.c("baz", XMLAssert.te(3, 2, 3, 4, "<baz>$1</baz>$0"), Collections.emptyList(), "<baz"));
        CompletionItem barItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "bar");
        XMLAssert.testCompletionApply(xml, barItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <bar>$1</bar>$0 \r\n</foo>");
        CompletionItem bazItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "baz");
        XMLAssert.testCompletionApply(xml, bazItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <baz>$1</baz>$0 \r\n</foo>");
    }

    @Test
    public void inElementWithOrphanEndTag() throws BadLocationException {
        String xml = "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <f|</buz> \r\n</foo>";
        CompletionList list = XMLCompletionApplyBasedOnXMLSourceTest.testCompletionSnippetSupportFor(xml, 2, XMLAssert.c("bar", XMLAssert.te(3, 3, 3, 4, "bar$0>"), Arrays.asList(XMLAssert.te(3, 6, 3, 9, "bar")), "<bar"), XMLAssert.c("baz", XMLAssert.te(3, 3, 3, 4, "baz$0>"), Arrays.asList(XMLAssert.te(3, 6, 3, 9, "baz")), "<baz"));
        CompletionItem barItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "bar");
        XMLAssert.testCompletionApply(xml, barItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <bar$0></bar> \r\n</foo>");
        CompletionItem bazItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "baz");
        XMLAssert.testCompletionApply(xml, bazItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <baz$0></baz> \r\n</foo>");
    }

    @Test
    public void inElementWithOrphanEndTagAndResolveSupport() throws BadLocationException {
        XMLLanguageService ls = new XMLLanguageService();
        SharedSettings sharedSettings = XMLCompletionApplyBasedOnXMLSourceTest.createSettings(true);
        String xml = "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <f|</buz> \r\n</foo>";
        CompletionList list = XMLCompletionApplyBasedOnXMLSourceTest.testCompletionSnippetSupportFor(ls, xml, 2, sharedSettings, XMLAssert.c("bar", XMLAssert.te(3, 3, 3, 4, "bar$0>"), Collections.emptyList(), "<bar"), XMLAssert.c("baz", XMLAssert.te(3, 3, 3, 4, "baz$0>"), Collections.emptyList(), "<baz"));
        CompletionItem barItem = XMLCompletionApplyBasedOnXMLSourceTest.findItemByLabel(list.getItems(), "bar");
        XMLAssert.testCompletionApply(xml, barItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <bar$0></buz> \r\n</foo>");
        Object xmlWithoutCursor = xml;
        int offset = ((String)xmlWithoutCursor).indexOf(124);
        xmlWithoutCursor = ((String)xmlWithoutCursor).substring(0, offset) + ((String)xmlWithoutCursor).substring(offset + 1);
        DOMDocument document = DOMParser.getInstance().parse((String)xmlWithoutCursor, "test.xml", null);
        barItem = ls.resolveCompletionItem(barItem, document, sharedSettings, () -> {});
        XMLAssert.testCompletionApply(xml, barItem, "<foo>\r\n  <bar>a</bar>\r\n  <baz>a</baz>\r\n  <bar$0></bar> \r\n</foo>");
    }

    private static CompletionList testCompletionSnippetSupportFor(String xml, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        return XMLCompletionApplyBasedOnXMLSourceTest.testCompletionSnippetSupportFor(new XMLLanguageService(), xml, expectedCount, XMLCompletionApplyBasedOnXMLSourceTest.createSettings(false), expectedItems);
    }

    private static CompletionList testCompletionSnippetSupportFor(XMLLanguageService ls, String xml, Integer expectedCount, SharedSettings sharedSettings, CompletionItem ... expectedItems) throws BadLocationException {
        return XMLAssert.testCompletionFor(ls, xml, null, null, null, null, sharedSettings, expectedItems);
    }

    private static SharedSettings createSettings(boolean resolveSupport) {
        CompletionCapabilities completionCapabilities = new CompletionCapabilities();
        CompletionItemCapabilities completionItem = new CompletionItemCapabilities(Boolean.valueOf(true));
        completionItem.setDocumentationFormat(Arrays.asList("markdown"));
        if (resolveSupport) {
            CompletionItemResolveSupportCapabilities resolveSupportCapabilities = new CompletionItemResolveSupportCapabilities(Arrays.asList(CompletionResolveSupportProperty.documentation.name(), CompletionResolveSupportProperty.additionalTextEdits.name()));
            completionItem.setResolveSupport(resolveSupportCapabilities);
        }
        completionCapabilities.setCompletionItem(completionItem);
        SharedSettings sharedSettings = new SharedSettings();
        sharedSettings.getCompletionSettings().setCapabilities(completionCapabilities);
        return sharedSettings;
    }

    private static CompletionItem findItemByLabel(List<CompletionItem> items, String label) {
        for (CompletionItem item : items) {
            if (!label.equals(item.getLabel())) continue;
            return item;
        }
        return null;
    }
}

