/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.uriresolver;

import java.io.IOException;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLCatalogResolver;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class LSPXMLCatalogResolver
extends XMLCatalogResolver {
    public LSPXMLCatalogResolver(String[] catalogs) {
        super(catalogs);
    }

    public String resolveIdentifier(String namespaceURI, String publicId, String systemId, String baseURI) {
        String resolvedId = null;
        try {
            if (namespaceURI != null && (resolvedId = this.resolveURI(namespaceURI)) != null) {
                return resolvedId;
            }
            if (!this.getUseLiteralSystemId() && baseURI != null) {
                try {
                    URI uri = new URI(new URI(baseURI), systemId);
                    systemId = uri.toString();
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
            }
            if (resolvedId == null) {
                if (publicId != null && systemId != null) {
                    resolvedId = this.resolvePublic(publicId, systemId);
                } else if (systemId != null) {
                    resolvedId = this.resolveSystem(systemId);
                } else if (publicId != null) {
                    return this.resolvePublic(publicId, null);
                }
                if (resolvedId == null && systemId != null) {
                    resolvedId = this.resolveURI(systemId);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resolvedId;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String resolvedId = this.resolveIdentifier(null, publicId, systemId, null);
        if (resolvedId != null) {
            InputSource source = new InputSource(resolvedId);
            source.setPublicId(publicId);
            return source;
        }
        return null;
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        String resolvedId = this.resolveIdentifier(null, publicId, systemId, baseURI);
        if (resolvedId != null) {
            InputSource source = new InputSource(resolvedId);
            source.setPublicId(publicId);
            return source;
        }
        return null;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        String resolvedId = this.resolveIdentifier(namespaceURI, publicId, systemId, baseURI);
        if (resolvedId != null) {
            return new DOMInputImpl(publicId, resolvedId, baseURI);
        }
        return null;
    }

    public String resolveIdentifier(XMLResourceIdentifier resourceIdentifier) throws IOException, XNIException {
        if (LSPXMLCatalogResolver.isXSDIncludeWithNamespace(resourceIdentifier)) {
            return resourceIdentifier.getExpandedSystemId();
        }
        String publicId = resourceIdentifier.getPublicId();
        String namespaceURI = resourceIdentifier.getNamespace();
        String systemId = this.getUseLiteralSystemId() ? resourceIdentifier.getLiteralSystemId() : resourceIdentifier.getExpandedSystemId();
        String baseURI = resourceIdentifier.getBaseSystemId();
        return this.resolveIdentifier(namespaceURI, publicId, systemId, baseURI);
    }

    private static boolean isXSDIncludeWithNamespace(XMLResourceIdentifier resourceIdentifier) {
        String namespaceURI = resourceIdentifier.getNamespace();
        if (resourceIdentifier != null && resourceIdentifier instanceof XSDDescription && namespaceURI != null && resourceIdentifier.getLiteralSystemId() != null && !resourceIdentifier.getLiteralSystemId().contains(":")) {
            XSDDescription description = (XSDDescription)resourceIdentifier;
            short contextType = description.getContextType();
            return contextType == 0;
        }
        return false;
    }
}

