/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.helper.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.model.business.internal.helper.ContentHelper;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.helper.extension.ExtensionManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Aspect;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdiagram.DiagramSet;

public class DoremiDiagramElementHelper {
    public static List<DiagramDescription> getAvailableDoremiDiagramFor(EObject anyModelElement) {
        ArrayList<DiagramDescription> result = new ArrayList<DiagramDescription>();
        List<DiagramDescription> taDiagram = DoremiDiagramElementHelper.getTargetApplicationDoremiDiagramFor(anyModelElement);
        List<DiagramDescription> importedDiagram = DoremiDiagramElementHelper.getImportedDoremiDiagramFor(anyModelElement);
        if (!taDiagram.isEmpty()) {
            result.addAll(taDiagram);
        }
        if (!importedDiagram.isEmpty()) {
            result.addAll(importedDiagram);
        }
        return result;
    }

    public static List<DiagramDescription> getTargetApplicationDoremiDiagramFor(EObject anyModelElement) {
        List<String> diagramFilter;
        ArrayList<DiagramDescription> result = new ArrayList<DiagramDescription>();
        if (anyModelElement != null && (diagramFilter = ExtensionManager.getDiagramFilters(anyModelElement)) != null && !diagramFilter.isEmpty()) {
            for (String dFilter : diagramFilter) {
                Set vpset = ViewpointSelection.getViewpoints((String)dFilter);
                for (org.eclipse.sirius.viewpoint.description.Viewpoint viewpoint : vpset) {
                    for (RepresentationDescription iRepresentationDescription : viewpoint.getOwnedRepresentations()) {
                        if (!(iRepresentationDescription instanceof DiagramDescription)) continue;
                        result.add((DiagramDescription)iRepresentationDescription);
                    }
                }
            }
        }
        return result;
    }

    public static List<DiagramDescription> getImportedDoremiDiagramFor(EObject anyModelElement) {
        ArrayList<DiagramDescription> result = new ArrayList<DiagramDescription>();
        Viewpoint viewpoint = (Viewpoint)EcoreUtil.getRootContainer((EObject)anyModelElement);
        for (Aspect aspect : viewpoint.getVP_Aspects()) {
            if (!(aspect instanceof DiagramSet)) continue;
            EList groups = ((DiagramSet)aspect).getAdditionalExternalGroup();
            for (Group group : groups) {
                List<DiagramDescription> diagrams = DoremiDiagramElementHelper.getDiagrams(group);
                if (diagrams.isEmpty()) continue;
                result.addAll(diagrams);
            }
        }
        return result;
    }

    public static List<ContainerMapping> getAvailableContainerMappingsFor(EObject anyModelElement) {
        ArrayList<ContainerMapping> result = new ArrayList<ContainerMapping>();
        List<DiagramDescription> diagrams = DoremiDiagramElementHelper.getAvailableDoremiDiagramFor(anyModelElement);
        for (DiagramDescription iDiagram : diagrams) {
            EList allContainerMappings = ContentHelper.getAllContainerMappings((DiagramDescription)iDiagram, (boolean)true);
            result.addAll((Collection<ContainerMapping>)allContainerMappings);
            for (ContainerMapping containerMapping : allContainerMappings) {
                List<ContainerMapping> subResult = DoremiDiagramElementHelper.getSubContainers(containerMapping);
                if (subResult == null || subResult.size() <= 0) continue;
                result.addAll(subResult);
            }
        }
        return result;
    }

    private static List<ContainerMapping> getSubContainers(ContainerMapping container) {
        ArrayList<ContainerMapping> result = new ArrayList<ContainerMapping>();
        for (ContainerMapping containerMapping : container.getSubContainerMappings()) {
            List<ContainerMapping> subResult;
            if (!result.contains(containerMapping)) {
                result.add(containerMapping);
            }
            if ((subResult = DoremiDiagramElementHelper.getSubContainers(containerMapping)) == null || subResult.size() <= 0) continue;
            for (ContainerMapping containerMapping2 : subResult) {
                if (result.contains(containerMapping2)) continue;
                result.add(containerMapping2);
            }
        }
        return result;
    }

    public static List<NodeMapping> getAvailableNodeMappingsFor(EObject anyModelElement) {
        ArrayList<NodeMapping> result = new ArrayList<NodeMapping>();
        List<DiagramDescription> diagrams = DoremiDiagramElementHelper.getAvailableDoremiDiagramFor(anyModelElement);
        for (DiagramDescription iDiagram : diagrams) {
            EList allNodeMappings = ContentHelper.getAllNodeMappings((DiagramDescription)iDiagram, (boolean)true);
            result.addAll((Collection<NodeMapping>)allNodeMappings);
            for (NodeMapping iNodeMapping : allNodeMappings) {
                List<NodeMapping> borderedNodes = DoremiDiagramElementHelper.getBorderedNodes(iNodeMapping);
                if (borderedNodes == null || borderedNodes.size() <= 0) continue;
                for (NodeMapping nodeMapping : borderedNodes) {
                    if (result.contains(nodeMapping)) continue;
                    result.add(nodeMapping);
                }
            }
            for (ContainerMapping iContainerMapping : ContentHelper.getAllContainerMappings((DiagramDescription)iDiagram, (boolean)true)) {
                List<NodeMapping> subNodes = DoremiDiagramElementHelper.getSubNodes(iContainerMapping);
                if (subNodes == null || subNodes.size() <= 0) continue;
                result.addAll(subNodes);
            }
        }
        return result;
    }

    private static List<NodeMapping> getSubNodes(ContainerMapping container) {
        BasicEList result = new BasicEList();
        for (NodeMapping subNodeMapping : container.getSubNodeMappings()) {
            List<NodeMapping> nodeBorderedNodes;
            if (!result.contains(subNodeMapping)) {
                result.add(subNodeMapping);
            }
            if ((nodeBorderedNodes = DoremiDiagramElementHelper.getBorderedNodes(subNodeMapping)) == null || nodeBorderedNodes.size() <= 0) continue;
            for (NodeMapping nodeMapping : nodeBorderedNodes) {
                if (result.contains(nodeMapping)) continue;
                result.add(nodeMapping);
            }
        }
        for (NodeMapping borderedNodeMapping : container.getBorderedNodeMappings()) {
            if (result.contains(borderedNodeMapping)) continue;
            result.add(borderedNodeMapping);
        }
        for (ContainerMapping iContainerMapping : container.getSubContainerMappings()) {
            List<NodeMapping> subContainerSubNodes = DoremiDiagramElementHelper.getSubNodes(iContainerMapping);
            if (subContainerSubNodes == null || subContainerSubNodes.size() <= 0) continue;
            for (NodeMapping nodeMapping : subContainerSubNodes) {
                if (result.contains(nodeMapping)) continue;
                result.add(nodeMapping);
            }
        }
        return result;
    }

    private static List<NodeMapping> getBorderedNodes(NodeMapping node) {
        BasicEList result = new BasicEList();
        for (NodeMapping borderedNodeMapping : node.getBorderedNodeMappings()) {
            if (result.contains(borderedNodeMapping)) continue;
            result.add(borderedNodeMapping);
        }
        return result;
    }

    public static List<EdgeMapping> getAvailableEdgeMappingsFor(EObject anyModelElement) {
        ArrayList<EdgeMapping> result = new ArrayList<EdgeMapping>();
        List<DiagramDescription> diagrams = DoremiDiagramElementHelper.getAvailableDoremiDiagramFor(anyModelElement);
        for (DiagramDescription iDiagram : diagrams) {
            result.addAll((Collection<EdgeMapping>)ContentHelper.getAllEdgeMappings((DiagramDescription)iDiagram, (boolean)false));
        }
        return result;
    }

    private static List<DiagramDescription> getDiagrams(Object container) {
        ArrayList<DiagramDescription> result = new ArrayList<DiagramDescription>();
        if (container instanceof Group) {
            EList ownedViewpoints = ((Group)container).getOwnedViewpoints();
            for (org.eclipse.sirius.viewpoint.description.Viewpoint viewpoint : ownedViewpoints) {
                for (RepresentationDescription iRepresentationDescription : viewpoint.getOwnedRepresentations()) {
                    if (!(iRepresentationDescription instanceof DiagramDescription)) continue;
                    result.add((DiagramDescription)iRepresentationDescription);
                }
            }
        }
        if (container instanceof org.eclipse.sirius.viewpoint.description.Viewpoint) {
            for (RepresentationDescription iRepresentationDescription : ((org.eclipse.sirius.viewpoint.description.Viewpoint)container).getOwnedRepresentations()) {
                if (!(iRepresentationDescription instanceof DiagramDescription)) continue;
                result.add((DiagramDescription)iRepresentationDescription);
            }
        }
        return result;
    }
}

