/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration.ADataAnalyserHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration.AEdge;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration.ANode;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractAssociation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Association_Types;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ExternalClassAssociation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.LocalClassAssociation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.VpdescFactory;
import org.polarsys.kitalpha.emde.model.EmdePackage;

public class ADataAnalyser {
    private List<ANode> allNodes;
    private List<ANode> rootNodes;
    private List<AEdge> allEdges;
    private Class _contextClass;
    private boolean includeContextClassAsRoot = false;

    public ADataAnalyser(Class context) {
        this._contextClass = context;
    }

    public ADataAnalyser(Class context, boolean includeContextClassAsRoot) {
        this(context);
        this.includeContextClassAsRoot = includeContextClassAsRoot;
    }

    public Class getContextClass() {
        return this._contextClass;
    }

    public List<ANode> getAllNodes() {
        return this.allNodes;
    }

    public List<ANode> getRootNodes() {
        return this.rootNodes;
    }

    public List<AEdge> getAllEdges() {
        return this.allEdges;
    }

    public void Analyse() {
        this.allNodes = new ArrayList<ANode>();
        this.rootNodes = new ArrayList<ANode>();
        this.allEdges = new ArrayList<AEdge>();
        if (this.includeContextClassAsRoot) {
            ExternalClassAssociation eca = VpdescFactory.eINSTANCE.createExternalClassAssociation();
            eca.setName("external emde.ExtensibleElement.ownedExtensions");
            eca.setExternalTarget(EmdePackage.Literals.ELEMENT_EXTENSION);
            this.createRootNode(this._contextClass, (AbstractAssociation)eca);
        } else {
            this.createRootNodes();
        }
        for (ANode node : this.rootNodes) {
            this.createNodeChildren(node);
        }
        this.createEdges();
    }

    protected void createEdges() {
        for (ANode iNode : this.allNodes) {
            Class sourceClass = iNode.getVPClass();
            EList associations = sourceClass.getVP_Classes_Associations();
            for (AbstractAssociation abstractAssociation : associations) {
                if (!(abstractAssociation instanceof LocalClassAssociation) || !abstractAssociation.getType().equals((Object)Association_Types.REFERENCE)) continue;
                Class targetClass = ((LocalClassAssociation)abstractAssociation).getLocalTarget();
                if (targetClass.isAbstract()) {
                    EList<Class> localDescendantClasses = ADataAnalyserHelper.getLocalDescendantClasses(targetClass);
                    for (Class iClass : localDescendantClasses) {
                        this.createEdge(abstractAssociation, sourceClass, iClass);
                    }
                    continue;
                }
                this.createEdge(abstractAssociation, sourceClass, targetClass);
            }
        }
    }

    private AEdge createEdge(AbstractAssociation association, Class sourceClass, Class targetClass) {
        List<ANode> targetNodes = this.getNodesFor(targetClass);
        List<ANode> sourceNode = this.getNodesFor(sourceClass);
        if (sourceNode != null && !sourceNode.isEmpty() && targetNodes != null && !targetNodes.isEmpty()) {
            AEdge edge = this.getEdgeFor(association, true);
            if (!this.allEdges.contains(edge)) {
                this.allEdges.add(edge);
            }
            for (ANode aNode : sourceNode) {
                edge.addSourceNode(aNode);
            }
            for (ANode aNode : targetNodes) {
                edge.addTargetNode(aNode);
            }
            return edge;
        }
        return null;
    }

    protected void createRootNodes() {
        EList<AbstractAssociation> classAssociations = ADataAnalyserHelper.getAllLocalAssociations(this._contextClass);
        for (AbstractAssociation abstractAssociation : classAssociations) {
            LocalClassAssociation localAssociation;
            if (!(abstractAssociation instanceof LocalClassAssociation) || !(localAssociation = (LocalClassAssociation)abstractAssociation).getType().equals((Object)Association_Types.CONTAINMENT)) continue;
            Class targetClass = localAssociation.getLocalTarget();
            if (targetClass.isAbstract()) {
                EList<Class> localDescendantClasses = ADataAnalyserHelper.getLocalDescendantClasses(targetClass);
                for (Class iClass : localDescendantClasses) {
                    this.createRootNode(iClass, (AbstractAssociation)localAssociation);
                }
                continue;
            }
            this.createRootNode(targetClass, (AbstractAssociation)localAssociation);
        }
    }

    protected void createNodeChildren(ANode parent) {
        Class rootClass = parent.getVPClass();
        EList<AbstractAssociation> classAssociations = ADataAnalyserHelper.getAllLocalAssociations(rootClass);
        for (AbstractAssociation abstractAssociation : classAssociations) {
            LocalClassAssociation localAssociation;
            if (!(abstractAssociation instanceof LocalClassAssociation) || !(localAssociation = (LocalClassAssociation)abstractAssociation).getType().equals((Object)Association_Types.CONTAINMENT)) continue;
            Class targetClass = localAssociation.getLocalTarget();
            if (targetClass.isAbstract()) {
                EList<Class> localDescendantClasses = ADataAnalyserHelper.getLocalDescendantClasses(targetClass);
                for (Class iClass : localDescendantClasses) {
                    this.createChildNode(parent, localAssociation, iClass);
                }
                continue;
            }
            this.createChildNode(parent, localAssociation, targetClass);
        }
    }

    private void createRootNode(Class clazz, AbstractAssociation containingRef) {
        ANode node = new ANode(clazz, containingRef);
        this.rootNodes.add(node);
        this.allNodes.add(node);
    }

    private void createChildNode(ANode parent, LocalClassAssociation containingAssociation, Class clazz) {
        ANode node = this.getNodeFor(clazz, (AbstractAssociation)containingAssociation);
        if (node != null) {
            parent.addReuse(node);
        } else {
            node = new ANode(clazz, (AbstractAssociation)containingAssociation);
            parent.addChildren(node);
            this.allNodes.add(node);
            if (this.isContainer(clazz)) {
                this.createNodeChildren(node);
            }
        }
    }

    private ANode getNodeFor(Class clazz, AbstractAssociation containingRef) {
        for (ANode iNode : this.allNodes) {
            if (!iNode.getVPClass().equals(clazz) || !iNode.getContainingReference().equals(containingRef)) continue;
            return iNode;
        }
        return null;
    }

    private List<ANode> getNodesFor(Class clazz) {
        UniqueEList result = new UniqueEList();
        for (ANode iNode : this.allNodes) {
            if (!iNode.getVPClass().equals(clazz)) continue;
            result.add(iNode);
        }
        return result;
    }

    private AEdge getEdgeFor(AbstractAssociation containingRef, boolean forceEdge) {
        for (AEdge iEdge : this.allEdges) {
            if (!iEdge.getTargetReference().equals(containingRef)) continue;
            return iEdge;
        }
        return forceEdge ? new AEdge(containingRef) : null;
    }

    private boolean isContainer(Class clazz) {
        EList<AbstractAssociation> classAssociations = ADataAnalyserHelper.getAllLocalAssociations(clazz);
        for (AbstractAssociation abstractAssociation : classAssociations) {
            LocalClassAssociation localAssociation;
            if (!(abstractAssociation instanceof LocalClassAssociation) || !(localAssociation = (LocalClassAssociation)abstractAssociation).getType().equals((Object)Association_Types.CONTAINMENT)) continue;
            return true;
        }
        return false;
    }
}

