/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.text.reconciler;

import java.util.function.Function;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.ui.IWorkingCopyManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class WorkingCopyReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private final Function<IDocument, ISourceFile> documentToSourceFile;
    private volatile ISourceFile sourceFile;
    private volatile IProgressMonitor monitor;

    public WorkingCopyReconcilingStrategy(IWorkingCopyManager workingCopyManager) {
        this(workingCopyManager::getWorkingCopy);
    }

    public WorkingCopyReconcilingStrategy(Function<IDocument, ISourceFile> documentToSourceFile) {
        if (documentToSourceFile == null) {
            throw new IllegalArgumentException();
        }
        this.documentToSourceFile = documentToSourceFile;
    }

    public void setDocument(IDocument document) {
        this.setSourceFile(this.documentToSourceFile.apply(document));
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public final void initialReconcile() {
        this.reconcile(true);
    }

    public final void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(false);
    }

    public final void reconcile(IRegion partition) {
        this.reconcile(false);
    }

    protected void reconcile(ISourceFile sourceFile, boolean initialReconcile, IProgressMonitor monitor) throws CoreException {
        Elements.reconcile((ISourceFile)sourceFile, (IProgressMonitor)monitor);
    }

    private void reconcile(boolean initialReconcile) {
        ISourceFile sourceFile = this.getSourceFile();
        if (sourceFile == null) {
            return;
        }
        SafeRunner.run(() -> this.reconcile(sourceFile, initialReconcile, this.monitor));
    }

    private void setSourceFile(ISourceFile sourceFile) {
        this.sourceFile = sourceFile;
    }

    private ISourceFile getSourceFile() {
        return this.sourceFile;
    }
}

