/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.quickoutline;

import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.model.adapter.IContentAdapterProvider;
import org.eclipse.handly.ui.quickoutline.IOutlinePopupHost;
import org.eclipse.handly.ui.quickoutline.Messages;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class OutlinePopup
extends PopupDialog {
    private IOutlinePopupHost host;
    private KeyStroke invokingKeyStroke;
    private TreeViewer treeViewer;
    private Object initialSelection;

    public OutlinePopup() {
        super(null, 540692, true, true, false, true, true, null, null);
    }

    public void init(IOutlinePopupHost host, KeyStroke invokingKeyStroke) {
        this.setParentShell(host.getControl().getShell());
        this.host = host;
        this.invokingKeyStroke = invokingKeyStroke;
        this.setInfoText("");
        this.create();
        this.treeViewer.setUseHashlookup(this.shouldUseHashlookup());
        this.treeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        IBaseLabelProvider labelProvider = this.getLabelProvider();
        this.setUpDecorationContextFor(labelProvider);
        this.treeViewer.setLabelProvider(labelProvider);
        this.treeViewer.setInput(this.computeInput());
        this.initialSelection = this.computeInitialSelection();
        if (this.initialSelection != null) {
            if (this.initialSelection.equals(this.treeViewer.getInput())) {
                this.initialSelection = null;
            } else {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(this.initialSelection), true);
            }
        }
        this.updateInfoText();
    }

    protected final IOutlinePopupHost getHost() {
        return this.host;
    }

    protected final KeyStroke getInvokingKeyStroke() {
        return this.invokingKeyStroke;
    }

    protected final TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected final Object getInitialSelection() {
        return this.initialSelection;
    }

    protected final Object getSelectedElement() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    protected Control getFocusControl() {
        return this.treeViewer.getControl();
    }

    protected void setTabOrder(Composite composite) {
        composite.setTabList(new Control[]{this.treeViewer.getTree()});
    }

    protected Point getDefaultLocation(Point initialSize) {
        Control control = this.host.getControl();
        Point size = control.getSize();
        Point location = new Point(size.x / 2 - initialSize.x / 2, size.y / 2 - initialSize.y / 2);
        return control.toDisplay(location);
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName = "QuickOutline";
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    protected Control createDialogArea(Composite parent) {
        this.treeViewer = this.createTreeViewer(parent);
        Tree tree = this.treeViewer.getTree();
        this.addKeyListener(tree);
        this.addSelectionListener(tree);
        this.addMouseHoverListener(tree);
        this.addMouseListener(tree);
        return tree;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Tree tree = new Tree(parent, 772);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        return new OutlineTreeViewer(tree);
    }

    protected void updateInfoText() {
        this.setInfoText(Messages.OutlinePopup_text);
    }

    protected void gotoSelectedElement() {
        Object element = this.getSelectedElement();
        if (element == null) {
            return;
        }
        if (this.revealInHost(element)) {
            this.close();
        }
    }

    protected void changeOutlineMode() {
    }

    protected boolean shouldUseHashlookup() {
        return true;
    }

    protected abstract ITreeContentProvider getContentProvider();

    protected abstract IBaseLabelProvider getLabelProvider();

    protected abstract Object computeInput();

    protected Object computeInitialSelection() {
        ISelection hostSelection = this.host.getSelectionProvider().getSelection();
        if (hostSelection == null || hostSelection.isEmpty()) {
            return null;
        }
        return this.getCorrespondingElement(hostSelection);
    }

    protected abstract Object getCorrespondingElement(ISelection var1);

    protected abstract boolean revealInHost(Object var1);

    protected boolean isAutoExpandable(TreeItem item) {
        return item.getParentItem() == null;
    }

    protected void initDecorationContext(DecorationContext context) {
        if (this instanceof IContentAdapterProvider) {
            context.putProperty(IContentAdapterProvider.class.getName(), (Object)this);
        }
    }

    protected final KeyListener getInvokingKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator);
                if (keyStroke.equals((Object)OutlinePopup.this.invokingKeyStroke)) {
                    OutlinePopup.this.changeOutlineMode();
                    OutlinePopup.this.updateInfoText();
                    e.doit = false;
                }
            }
        };
    }

    private void addKeyListener(Tree tree) {
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    OutlinePopup.this.close();
                }
            }
        });
        if (this.invokingKeyStroke != null) {
            tree.addKeyListener(this.getInvokingKeyListener());
        }
    }

    private void addSelectionListener(Tree tree) {
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                OutlinePopup.this.gotoSelectedElement();
            }
        });
    }

    private void addMouseHoverListener(final Tree tree) {
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem lastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem treeItem;
                if (tree.equals(e.getSource()) && (treeItem = tree.getItem(new Point(e.x, e.y))) != null) {
                    if (!treeItem.equals(this.lastItem)) {
                        this.lastItem = treeItem;
                        tree.setSelection(new TreeItem[]{this.lastItem});
                    } else if (e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = OutlinePopup.this.treeViewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.lastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.lastItem});
                        }
                    } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = OutlinePopup.this.treeViewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.lastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.lastItem});
                        }
                    }
                }
            }
        });
    }

    private void addMouseListener(final Tree tree) {
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        OutlinePopup.this.gotoSelectedElement();
                    }
                }
            }
        });
    }

    private void setUpDecorationContextFor(IBaseLabelProvider labelProvider) {
        if (labelProvider instanceof DecoratingLabelProvider) {
            DecoratingLabelProvider dlp = (DecoratingLabelProvider)labelProvider;
            dlp.setDecorationContext(this.createDecorationContext(dlp.getDecorationContext()));
        } else if (labelProvider instanceof DecoratingStyledCellLabelProvider) {
            DecoratingStyledCellLabelProvider dsclp = (DecoratingStyledCellLabelProvider)labelProvider;
            dsclp.setDecorationContext(this.createDecorationContext(dsclp.getDecorationContext()));
        }
    }

    private IDecorationContext createDecorationContext(IDecorationContext existingContext) {
        DecorationContext newContext = new DecorationContext();
        this.initDecorationContext(newContext);
        if (existingContext != null) {
            String[] stringArray = existingContext.getProperties();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                newContext.putProperty(property, existingContext.getProperty(property));
                ++n2;
            }
        }
        return newContext;
    }

    protected class OutlineTreeViewer
    extends TreeViewer {
        public OutlineTreeViewer(Tree tree) {
            super(tree);
            this.setAutoExpandLevel(-1);
        }

        protected void internalExpandToLevel(Widget node, int level) {
            TreeItem item;
            if (node instanceof TreeItem && !this.canExpand(item = (TreeItem)node)) {
                this.setExpanded((Item)item, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        protected boolean canExpand(TreeItem item) {
            return OutlinePopup.this.isAutoExpandable(item);
        }
    }
}

