/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.SAPoint;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.ui.structure.support.DiagramUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ConnectionProvider {
    private Map<String, Anchor> connectionMap = new HashMap<String, Anchor>();
    private IFeatureProvider fp;

    public ConnectionProvider(IFeatureProvider featureProvider) {
        this.fp = featureProvider;
    }

    public void insertAnchors(Collection<Shape> collection) {
        for (Shape shape : collection) {
            if (!shape.getAnchors().isEmpty()) {
                EObject bo = (EObject)this.fp.getBusinessObjectForPictogramElement((PictogramElement)shape);
                Object parentBo = this.fp.getBusinessObjectForPictogramElement((PictogramElement)shape.getContainer());
                if (bo instanceof InterfaceItem) {
                    if (parentBo instanceof ActorContainerRef) {
                        this.connectionMap.put(this.getKey(bo, (ActorContainerRef)parentBo), (Anchor)shape.getAnchors().get(0));
                    } else {
                        this.connectionMap.put(this.getKey(bo, null), (Anchor)shape.getAnchors().get(0));
                    }
                } else if (bo instanceof ActorRef) {
                    this.connectionMap.put(this.getKey(bo, null), (Anchor)shape.getAnchors().get(0));
                }
            }
            if (!(shape instanceof ContainerShape)) continue;
            this.insertAnchors((Collection<Shape>)((ContainerShape)shape).getChildren());
        }
    }

    public Anchor getAnchor(BindingEndPoint endPoint) {
        return this.connectionMap.get(this.getKey((EObject)endPoint.getPort(), endPoint.getActorRef()));
    }

    public Anchor getAnchor(SAPoint point) {
        if (point instanceof RelaySAPoint) {
            return this.connectionMap.get(this.getKey((EObject)((RelaySAPoint)point).getRelay(), null));
        }
        if (point instanceof RefSAPoint) {
            return this.connectionMap.get(this.getKey((EObject)((RefSAPoint)point).getRef(), null));
        }
        assert (false) : "unexpected type";
        return null;
    }

    public Anchor getAnchor(SPPoint point) {
        return this.connectionMap.get(this.getKey((EObject)point.getService(), point.getRef()));
    }

    private String getKey(EObject item, ActorContainerRef acr) {
        if (acr != null) {
            return DiagramUtil.getResourcePath((EObject)acr) + DiagramUtil.getResourcePath(item);
        }
        return DiagramUtil.getResourcePath(item);
    }
}

